/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics;

import java.io.IOException;
import java.util.Iterator;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.graphics.PDFontSetting;
import org.apache.pdfbox.pdmodel.graphics.PDGraphicsState;
import org.apache.pdfbox.pdmodel.graphics.PDLineDashPattern;

public class PDExtendedGraphicsState
implements COSObjectable {
    private static final COSName LW = COSName.getPDFName("LW");
    private static final COSName LC = COSName.getPDFName("LC");
    private static final COSName LJ = COSName.getPDFName("LJ");
    private static final COSName ML = COSName.getPDFName("ML");
    private static final COSName D = COSName.getPDFName("D");
    private static final COSName RI = COSName.getPDFName("RI");
    private static final COSName OP = COSName.getPDFName("OP");
    private static final COSName OP_NS = COSName.getPDFName("op");
    private static final COSName OPM = COSName.getPDFName("OPM");
    private static final COSName FONT = COSName.getPDFName("Font");
    private static final COSName FL = COSName.getPDFName("FL");
    private static final COSName SM = COSName.getPDFName("SM");
    private static final COSName SA = COSName.getPDFName("SA");
    private static final COSName CA = COSName.getPDFName("CA");
    private static final COSName CA_NS = COSName.getPDFName("ca");
    private static final COSName AIS = COSName.getPDFName("AIS");
    private static final COSName TK = COSName.getPDFName("TK");
    public static final String RENDERING_INTENT_ABSOLUTE_COLORIMETRIC = "AbsoluteColorimetric";
    public static final String RENDERING_INTENT_RELATIVE_COLORIMETRIC = "RelativeColorimetric";
    public static final String RENDERING_INTENT_SATURATION = "Saturation";
    public static final String RENDERING_INTENT_PERCEPTUAL = "Perceptual";
    private COSDictionary graphicsState;

    public PDExtendedGraphicsState() {
        this.graphicsState = new COSDictionary();
        this.graphicsState.setItem(COSName.TYPE, (COSBase)COSName.getPDFName("ExtGState"));
    }

    public PDExtendedGraphicsState(COSDictionary dictionary) {
        this.graphicsState = dictionary;
    }

    public void copyIntoGraphicsState(PDGraphicsState gs) throws IOException {
        Iterator keys = this.graphicsState.keyList().iterator();
        while (keys.hasNext()) {
            COSName key = (COSName)keys.next();
            if (key.equals(LW)) {
                gs.setLineWidth(this.getLineWidth().doubleValue());
                continue;
            }
            if (key.equals(LC)) {
                gs.setLineCap(this.getLineCapStyle());
                continue;
            }
            if (key.equals(LJ)) {
                gs.setLineJoin(this.getLineJoinStyle());
                continue;
            }
            if (key.equals(ML)) {
                gs.setMiterLimit(this.getMiterLimit().doubleValue());
                continue;
            }
            if (key.equals(D)) {
                gs.setLineDashPattern(this.getLineDashPattern());
                continue;
            }
            if (key.equals(RI)) {
                gs.setRenderingIntent(this.getRenderingIntent());
                continue;
            }
            if (key.equals(OPM)) {
                gs.setOverprintMode(this.getOverprintMode().doubleValue());
                continue;
            }
            if (key.equals(FONT)) {
                PDFontSetting setting = this.getFontSetting();
                gs.getTextState().setFont(setting.getFont());
                gs.getTextState().setFontSize(setting.getFontSize());
                continue;
            }
            if (key.equals(FL)) {
                gs.setFlatness(this.getFlatnessTolerance().floatValue());
                continue;
            }
            if (key.equals(SM)) {
                gs.setSmoothness(this.getSmoothnessTolerance().floatValue());
                continue;
            }
            if (key.equals(SA)) {
                gs.setStrokeAdjustment(this.getAutomaticStrokeAdjustment());
                continue;
            }
            if (key.equals(CA)) {
                gs.setAlphaConstants(this.getStrokingAlpaConstant().floatValue());
                continue;
            }
            if (key.equals(AIS)) {
                gs.setAlphaSource(this.getAlphaSourceFlag());
                continue;
            }
            if (!key.equals(TK)) continue;
            gs.getTextState().setKnockoutFlag(this.getTextKnockoutFlag());
        }
    }

    public COSDictionary getCOSDictionary() {
        return this.graphicsState;
    }

    public COSBase getCOSObject() {
        return this.graphicsState;
    }

    public Float getLineWidth() {
        return this.getFloatItem(LW);
    }

    public void setLineWidth(Float width) {
        this.setFloatItem(LW, width);
    }

    public int getLineCapStyle() {
        return this.graphicsState.getInt(LC);
    }

    public void setLineCapStyle(int style) {
        this.graphicsState.setInt(LC, style);
    }

    public int getLineJoinStyle() {
        return this.graphicsState.getInt(LJ);
    }

    public void setLineJoinStyle(int style) {
        this.graphicsState.setInt(LJ, style);
    }

    public Float getMiterLimit() {
        return this.getFloatItem(ML);
    }

    public void setMiterLimit(Float miterLimit) {
        this.setFloatItem(ML, miterLimit);
    }

    public PDLineDashPattern getLineDashPattern() {
        PDLineDashPattern retval = null;
        COSArray dp = (COSArray)this.graphicsState.getDictionaryObject(D);
        if (dp != null) {
            retval = new PDLineDashPattern(dp);
        }
        return retval;
    }

    public void setLineDashPattern(PDLineDashPattern dashPattern) {
        this.graphicsState.setItem(D, dashPattern.getCOSObject());
    }

    public String getRenderingIntent() {
        return this.graphicsState.getNameAsString("RI");
    }

    public void setRenderingIntent(String ri) {
        this.graphicsState.setName("RI", ri);
    }

    public boolean getStrokingOverprintControl() {
        return this.graphicsState.getBoolean(OP, false);
    }

    public void setStrokingOverprintControl(boolean op) {
        this.graphicsState.setBoolean(OP, op);
    }

    public boolean getNonStrokingOverprintControl() {
        return this.graphicsState.getBoolean(OP_NS, this.getStrokingOverprintControl());
    }

    public void setNonStrokingOverprintControl(boolean op) {
        this.graphicsState.setBoolean(OP_NS, op);
    }

    public Float getOverprintMode() {
        return this.getFloatItem(OPM);
    }

    public void setOverprintMode(Float overprintMode) {
        this.setFloatItem(OPM, overprintMode);
    }

    public PDFontSetting getFontSetting() {
        PDFontSetting setting = null;
        COSArray font = (COSArray)this.graphicsState.getDictionaryObject(FONT);
        if (font != null) {
            setting = new PDFontSetting(font);
        }
        return setting;
    }

    public void setFontSetting(PDFontSetting fs) {
        this.graphicsState.setItem(FONT, (COSObjectable)fs);
    }

    public Float getFlatnessTolerance() {
        return this.getFloatItem(FL);
    }

    public void setFlatnessTolerance(Float flatness) {
        this.setFloatItem(FL, flatness);
    }

    public Float getSmoothnessTolerance() {
        return this.getFloatItem(SM);
    }

    public void setSmoothnessTolerance(Float smoothness) {
        this.setFloatItem(SM, smoothness);
    }

    public boolean getAutomaticStrokeAdjustment() {
        return this.graphicsState.getBoolean(SA, false);
    }

    public void setAutomaticStrokeAdjustment(boolean sa) {
        this.graphicsState.setBoolean(SA, sa);
    }

    public Float getStrokingAlpaConstant() {
        return this.getFloatItem(CA);
    }

    public void setStrokingAlphaConstant(Float alpha) {
        this.setFloatItem(CA, alpha);
    }

    public Float getNonStrokingAlpaConstant() {
        return this.getFloatItem(CA_NS);
    }

    public void setNonStrokingAlphaConstant(Float alpha) {
        this.setFloatItem(CA_NS, alpha);
    }

    public boolean getAlphaSourceFlag() {
        return this.graphicsState.getBoolean(AIS, false);
    }

    public void setAlphaSourceFlag(boolean alpha) {
        this.graphicsState.setBoolean(AIS, alpha);
    }

    public boolean getTextKnockoutFlag() {
        return this.graphicsState.getBoolean(TK, true);
    }

    public void setTextKnockoutFlag(boolean tk) {
        this.graphicsState.setBoolean(TK, tk);
    }

    private Float getFloatItem(COSName key) {
        Float retval = null;
        COSNumber value = (COSNumber)this.graphicsState.getDictionaryObject(key);
        if (value != null) {
            retval = new Float(value.floatValue());
        }
        return retval;
    }

    private void setFloatItem(COSName key, Float value) {
        if (value == null) {
            this.graphicsState.removeItem(key);
        } else {
            this.graphicsState.setItem(key, (COSBase)new COSFloat(value.floatValue()));
        }
    }
}

