/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.dangan.util.lha;

import java.io.IOException;
import java.io.OutputStream;
import jp.gr.java_conf.dangan.io.BitOutputStream;
import jp.gr.java_conf.dangan.util.lha.DynamicHuffman;
import jp.gr.java_conf.dangan.util.lha.PostLzssEncoder;

public class PostLh2Encoder
implements PostLzssEncoder {
    private static final int DictionarySize = 8192;
    private static final int MaxMatch = 256;
    private static final int Threshold = 3;
    private static final int CodeSize = 286;
    private BitOutputStream out;
    private DynamicHuffman codeHuffman;
    private DynamicHuffman offHiHuffman;
    private int position;
    private int nextPosition;
    private int matchLength;

    private PostLh2Encoder() {
    }

    public PostLh2Encoder(OutputStream outputStream) {
        if (outputStream == null) {
            throw new NullPointerException("out");
        }
        this.out = outputStream instanceof BitOutputStream ? (BitOutputStream)outputStream : new BitOutputStream(outputStream);
        this.codeHuffman = new DynamicHuffman(286);
        this.offHiHuffman = new DynamicHuffman(128, 1);
        this.position = 0;
        this.nextPosition = 64;
    }

    public void writeCode(int n) throws IOException {
        int n2 = this.codeHuffman.codeToNode(Math.min(n, 285));
        int n3 = 0;
        int n4 = 0;
        do {
            n3 >>>= 1;
            ++n4;
            if ((n2 & 1) == 0) continue;
            n3 |= Integer.MIN_VALUE;
        } while ((n2 = this.codeHuffman.parentNode(n2)) != 0);
        this.out.writeBits(n4, n3 >>> 32 - n4);
        if (n < 256) {
            ++this.position;
        } else {
            this.matchLength = (n & 0xFF) + 3;
            if (285 <= n) {
                this.out.writeBits(8, n - 285);
                n = 285;
            }
        }
        this.codeHuffman.update(n);
    }

    public void writeOffset(int n) throws IOException {
        if (this.nextPosition < 8192) {
            while (this.nextPosition < this.position) {
                this.offHiHuffman.addLeaf(this.nextPosition >> 6);
                this.nextPosition += 64;
                if (8192 > this.nextPosition) continue;
            }
        }
        int n2 = this.offHiHuffman.codeToNode(n >> 6);
        int n3 = 0;
        int n4 = 0;
        while (n2 != 0) {
            n3 >>>= 1;
            ++n4;
            if ((n2 & 1) != 0) {
                n3 |= Integer.MIN_VALUE;
            }
            n2 = this.offHiHuffman.parentNode(n2);
        }
        this.out.writeBits(n4, n3 >> 32 - n4);
        this.out.writeBits(6, n);
        this.offHiHuffman.update(n >> 6);
        this.position += this.matchLength;
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void close() throws IOException {
        this.out.close();
        this.out = null;
        this.codeHuffman = null;
        this.offHiHuffman = null;
    }

    public int getDictionarySize() {
        return 8192;
    }

    public int getMaxMatch() {
        return 256;
    }

    public int getThreshold() {
        return 3;
    }
}

