/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class MapUtil {
    protected static final MapFactory factory = MapUtil.getMapFactory();

    public static Map createHashMap() {
        return factory.create();
    }

    public static Map createHashMap(int initialCapacity) {
        return factory.create(initialCapacity);
    }

    public static Map createHashMap(int initialCapacity, float loadFactor) {
        return factory.create(initialCapacity, loadFactor);
    }

    protected static MapFactory getMapFactory() {
        try {
            Class<?> clazz = Class.forName("org.seasar.framework.util.ConcurrentMapFactory");
            return (MapFactory)clazz.newInstance();
        }
        catch (Throwable throwable) {
            return new SynchronizedMapFactory();
        }
    }

    public static class SynchronizedMapFactory
    implements MapFactory {
        public Map create() {
            return Collections.synchronizedMap(new HashMap());
        }

        public Map create(int initialCapacity) {
            return Collections.synchronizedMap(new HashMap(initialCapacity));
        }

        public Map create(int initialCapacity, float loadFactor) {
            return Collections.synchronizedMap(new HashMap(initialCapacity, loadFactor));
        }
    }

    static interface MapFactory {
        public Map create();

        public Map create(int var1);

        public Map create(int var1, float var2);
    }
}

