/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import javax.net.SocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.HAUtil;
import org.apache.hadoop.hdfs.protocol.AlreadyBeingCreatedException;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.protocolPB.ClientNamenodeProtocolPB;
import org.apache.hadoop.hdfs.protocolPB.ClientNamenodeProtocolTranslatorPB;
import org.apache.hadoop.hdfs.protocolPB.GetUserMappingsProtocolClientSideTranslatorPB;
import org.apache.hadoop.hdfs.protocolPB.GetUserMappingsProtocolPB;
import org.apache.hadoop.hdfs.protocolPB.JournalProtocolPB;
import org.apache.hadoop.hdfs.protocolPB.JournalProtocolTranslatorPB;
import org.apache.hadoop.hdfs.protocolPB.NamenodeProtocolPB;
import org.apache.hadoop.hdfs.protocolPB.NamenodeProtocolTranslatorPB;
import org.apache.hadoop.hdfs.protocolPB.RefreshAuthorizationPolicyProtocolClientSideTranslatorPB;
import org.apache.hadoop.hdfs.protocolPB.RefreshAuthorizationPolicyProtocolPB;
import org.apache.hadoop.hdfs.protocolPB.RefreshUserMappingsProtocolClientSideTranslatorPB;
import org.apache.hadoop.hdfs.protocolPB.RefreshUserMappingsProtocolPB;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.SafeModeException;
import org.apache.hadoop.hdfs.server.protocol.JournalProtocol;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocol;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocols;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.retry.DefaultFailoverProxyProvider;
import org.apache.hadoop.io.retry.FailoverProxyProvider;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.io.retry.RetryProxy;
import org.apache.hadoop.io.retry.RetryUtils;
import org.apache.hadoop.ipc.Client;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.RefreshUserMappingsProtocol;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.RefreshAuthorizationPolicyProtocol;
import org.apache.hadoop.tools.GetUserMappingsProtocol;

public class NameNodeProxies {
    private static final Log LOG = LogFactory.getLog(NameNodeProxies.class);

    public static <T> ProxyAndInfo<T> createProxy(Configuration conf, URI nameNodeUri, Class<T> xface) throws IOException {
        Class<FailoverProxyProvider<T>> failoverProxyProviderClass = NameNodeProxies.getFailoverProxyProviderClass(conf, nameNodeUri, xface);
        if (failoverProxyProviderClass == null) {
            return NameNodeProxies.createNonHAProxy(conf, NameNode.getAddress(nameNodeUri), xface, UserGroupInformation.getCurrentUser(), true);
        }
        FailoverProxyProvider<T> failoverProxyProvider = NameNodeProxies.createFailoverProxyProvider(conf, failoverProxyProviderClass, xface, nameNodeUri);
        DFSClient.Conf config = new DFSClient.Conf(conf);
        Object proxy = RetryProxy.create(xface, failoverProxyProvider, (RetryPolicy)RetryPolicies.failoverOnNetworkException((RetryPolicy)RetryPolicies.TRY_ONCE_THEN_FAIL, (int)config.maxFailoverAttempts, (long)config.failoverSleepBaseMillis, (long)config.failoverSleepMaxMillis));
        Text dtService = HAUtil.buildTokenServiceForLogicalUri(nameNodeUri);
        return new ProxyAndInfo<Object>(proxy, dtService);
    }

    public static <T> ProxyAndInfo<T> createNonHAProxy(Configuration conf, InetSocketAddress nnAddr, Class<T> xface, UserGroupInformation ugi, boolean withRetries) throws IOException {
        Object proxy;
        Text dtService = SecurityUtil.buildTokenService((InetSocketAddress)nnAddr);
        if (xface == ClientProtocol.class) {
            proxy = NameNodeProxies.createNNProxyWithClientProtocol(nnAddr, conf, ugi, withRetries);
        } else if (xface == JournalProtocol.class) {
            proxy = NameNodeProxies.createNNProxyWithJournalProtocol(nnAddr, conf, ugi);
        } else if (xface == NamenodeProtocol.class) {
            proxy = NameNodeProxies.createNNProxyWithNamenodeProtocol(nnAddr, conf, ugi, withRetries);
        } else if (xface == GetUserMappingsProtocol.class) {
            proxy = NameNodeProxies.createNNProxyWithGetUserMappingsProtocol(nnAddr, conf, ugi);
        } else if (xface == RefreshUserMappingsProtocol.class) {
            proxy = NameNodeProxies.createNNProxyWithRefreshUserMappingsProtocol(nnAddr, conf, ugi);
        } else if (xface == RefreshAuthorizationPolicyProtocol.class) {
            proxy = NameNodeProxies.createNNProxyWithRefreshAuthorizationPolicyProtocol(nnAddr, conf, ugi);
        } else {
            String message = "Upsupported protocol found when creating the proxy connection to NameNode: " + (xface != null ? xface.getClass().getName() : "null");
            LOG.error((Object)message);
            throw new IllegalStateException(message);
        }
        return new ProxyAndInfo<Object>(proxy, dtService);
    }

    private static JournalProtocol createNNProxyWithJournalProtocol(InetSocketAddress address, Configuration conf, UserGroupInformation ugi) throws IOException {
        JournalProtocolPB proxy = (JournalProtocolPB)NameNodeProxies.createNameNodeProxy(address, conf, ugi, JournalProtocolPB.class);
        return new JournalProtocolTranslatorPB(proxy);
    }

    private static RefreshAuthorizationPolicyProtocol createNNProxyWithRefreshAuthorizationPolicyProtocol(InetSocketAddress address, Configuration conf, UserGroupInformation ugi) throws IOException {
        RefreshAuthorizationPolicyProtocolPB proxy = (RefreshAuthorizationPolicyProtocolPB)NameNodeProxies.createNameNodeProxy(address, conf, ugi, RefreshAuthorizationPolicyProtocolPB.class);
        return new RefreshAuthorizationPolicyProtocolClientSideTranslatorPB(proxy);
    }

    private static RefreshUserMappingsProtocol createNNProxyWithRefreshUserMappingsProtocol(InetSocketAddress address, Configuration conf, UserGroupInformation ugi) throws IOException {
        RefreshUserMappingsProtocolPB proxy = (RefreshUserMappingsProtocolPB)NameNodeProxies.createNameNodeProxy(address, conf, ugi, RefreshUserMappingsProtocolPB.class);
        return new RefreshUserMappingsProtocolClientSideTranslatorPB(proxy);
    }

    private static GetUserMappingsProtocol createNNProxyWithGetUserMappingsProtocol(InetSocketAddress address, Configuration conf, UserGroupInformation ugi) throws IOException {
        GetUserMappingsProtocolPB proxy = (GetUserMappingsProtocolPB)NameNodeProxies.createNameNodeProxy(address, conf, ugi, GetUserMappingsProtocolPB.class);
        return new GetUserMappingsProtocolClientSideTranslatorPB(proxy);
    }

    private static NamenodeProtocol createNNProxyWithNamenodeProtocol(InetSocketAddress address, Configuration conf, UserGroupInformation ugi, boolean withRetries) throws IOException {
        NamenodeProtocolPB proxy = (NamenodeProtocolPB)NameNodeProxies.createNameNodeProxy(address, conf, ugi, NamenodeProtocolPB.class);
        if (withRetries) {
            RetryPolicy timeoutPolicy = RetryPolicies.exponentialBackoffRetry((int)5, (long)200L, (TimeUnit)TimeUnit.MILLISECONDS);
            HashMap exceptionToPolicyMap = new HashMap();
            RetryPolicy methodPolicy = RetryPolicies.retryByException((RetryPolicy)timeoutPolicy, exceptionToPolicyMap);
            HashMap<String, RetryPolicy> methodNameToPolicyMap = new HashMap<String, RetryPolicy>();
            methodNameToPolicyMap.put("getBlocks", methodPolicy);
            methodNameToPolicyMap.put("getAccessKeys", methodPolicy);
            proxy = (NamenodeProtocolPB)RetryProxy.create(NamenodeProtocolPB.class, (Object)proxy, methodNameToPolicyMap);
        }
        return new NamenodeProtocolTranslatorPB(proxy);
    }

    private static ClientProtocol createNNProxyWithClientProtocol(InetSocketAddress address, Configuration conf, UserGroupInformation ugi, boolean withRetries) throws IOException {
        RPC.setProtocolEngine((Configuration)conf, ClientNamenodeProtocolPB.class, ProtobufRpcEngine.class);
        RetryPolicy defaultPolicy = RetryUtils.getDefaultRetryPolicy((Configuration)conf, (String)"dfs.client.retry.policy.enabled", (boolean)false, (String)"dfs.client.retry.policy.spec", (String)"10000,6,60000,10", SafeModeException.class);
        long version = RPC.getProtocolVersion(ClientNamenodeProtocolPB.class);
        ClientNamenodeProtocolPB proxy = (ClientNamenodeProtocolPB)RPC.getProtocolProxy(ClientNamenodeProtocolPB.class, (long)version, (InetSocketAddress)address, (UserGroupInformation)ugi, (Configuration)conf, (SocketFactory)NetUtils.getDefaultSocketFactory((Configuration)conf), (int)Client.getTimeout((Configuration)conf), (RetryPolicy)defaultPolicy).getProxy();
        if (withRetries) {
            RetryPolicy createPolicy = RetryPolicies.retryUpToMaximumCountWithFixedSleep((int)5, (long)60000L, (TimeUnit)TimeUnit.MILLISECONDS);
            HashMap<Class<AlreadyBeingCreatedException>, RetryPolicy> remoteExceptionToPolicyMap = new HashMap<Class<AlreadyBeingCreatedException>, RetryPolicy>();
            remoteExceptionToPolicyMap.put(AlreadyBeingCreatedException.class, createPolicy);
            HashMap<Class<RemoteException>, RetryPolicy> exceptionToPolicyMap = new HashMap<Class<RemoteException>, RetryPolicy>();
            exceptionToPolicyMap.put(RemoteException.class, RetryPolicies.retryByRemoteException((RetryPolicy)defaultPolicy, remoteExceptionToPolicyMap));
            RetryPolicy methodPolicy = RetryPolicies.retryByException((RetryPolicy)defaultPolicy, exceptionToPolicyMap);
            HashMap<String, RetryPolicy> methodNameToPolicyMap = new HashMap<String, RetryPolicy>();
            methodNameToPolicyMap.put("create", methodPolicy);
            proxy = (ClientNamenodeProtocolPB)RetryProxy.create(ClientNamenodeProtocolPB.class, (FailoverProxyProvider)new DefaultFailoverProxyProvider(ClientNamenodeProtocolPB.class, (Object)proxy), methodNameToPolicyMap, (RetryPolicy)defaultPolicy);
        }
        return new ClientNamenodeProtocolTranslatorPB(proxy);
    }

    private static Object createNameNodeProxy(InetSocketAddress address, Configuration conf, UserGroupInformation ugi, Class xface) throws IOException {
        RPC.setProtocolEngine((Configuration)conf, (Class)xface, ProtobufRpcEngine.class);
        Object proxy = RPC.getProxy((Class)xface, (long)RPC.getProtocolVersion((Class)xface), (InetSocketAddress)address, (UserGroupInformation)ugi, (Configuration)conf, (SocketFactory)NetUtils.getDefaultSocketFactory((Configuration)conf));
        return proxy;
    }

    private static <T> Class<FailoverProxyProvider<T>> getFailoverProxyProviderClass(Configuration conf, URI nameNodeUri, Class<T> xface) throws IOException {
        if (nameNodeUri == null) {
            return null;
        }
        String host = nameNodeUri.getHost();
        String configKey = "dfs.client.failover.proxy.provider." + host;
        try {
            int port;
            Class ret = conf.getClass(configKey, null, FailoverProxyProvider.class);
            if (ret != null && (port = nameNodeUri.getPort()) > 0 && port != 8020) {
                throw new IOException("Port " + port + " specified in URI " + nameNodeUri + " but host '" + host + "' is a logical (HA) namenode" + " and does not use port information.");
            }
            return ret;
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof ClassNotFoundException) {
                throw new IOException("Could not load failover proxy provider class " + conf.get(configKey) + " which is configured for authority " + nameNodeUri, e);
            }
            throw e;
        }
    }

    private static <T> FailoverProxyProvider<T> createFailoverProxyProvider(Configuration conf, Class<FailoverProxyProvider<T>> failoverProxyProviderClass, Class<T> xface, URI nameNodeUri) throws IOException {
        Preconditions.checkArgument((boolean)xface.isAssignableFrom(NamenodeProtocols.class), (String)"Interface %s is not a NameNode protocol", (Object[])new Object[]{xface});
        try {
            Constructor<FailoverProxyProvider<T>> ctor = failoverProxyProviderClass.getConstructor(Configuration.class, URI.class, Class.class);
            FailoverProxyProvider<T> provider = ctor.newInstance(conf, nameNodeUri, xface);
            return provider;
        }
        catch (Exception e) {
            String message = "Couldn't create proxy provider " + failoverProxyProviderClass;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)message, (Throwable)e);
            }
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new IOException(message, e);
        }
    }

    public static class ProxyAndInfo<PROXYTYPE> {
        private final PROXYTYPE proxy;
        private final Text dtService;

        public ProxyAndInfo(PROXYTYPE proxy, Text dtService) {
            this.proxy = proxy;
            this.dtService = dtService;
        }

        public PROXYTYPE getProxy() {
            return this.proxy;
        }

        public Text getDelegationTokenService() {
            return this.dtService;
        }
    }
}

