/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools.offlineImageViewer;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.LayoutVersion;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.server.namenode.FSImageSerialization;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.ImageLoader;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.ImageVisitor;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.security.token.delegation.DelegationKey;

class ImageLoaderCurrent
implements ImageLoader {
    protected final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    private static int[] versions = new int[]{-16, -17, -18, -19, -20, -21, -22, -23, -24, -25, -26, -27, -28, -30, -31, -32, -33, -34, -35, -36, -37, -38, -39, -40};
    private int imageVersion = 0;

    ImageLoaderCurrent() {
    }

    @Override
    public boolean canLoadVersion(int version) {
        for (int v : versions) {
            if (v != version) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadImage(DataInputStream in, ImageVisitor v, boolean skipBlocks) throws IOException {
        boolean done = false;
        try {
            v.start();
            v.visitEnclosingElement(ImageVisitor.ImageElement.FS_IMAGE);
            this.imageVersion = in.readInt();
            if (!this.canLoadVersion(this.imageVersion)) {
                throw new IOException("Cannot process fslayout version " + this.imageVersion);
            }
            v.visit(ImageVisitor.ImageElement.IMAGE_VERSION, this.imageVersion);
            v.visit(ImageVisitor.ImageElement.NAMESPACE_ID, in.readInt());
            long numInodes = in.readLong();
            v.visit(ImageVisitor.ImageElement.GENERATION_STAMP, in.readLong());
            if (LayoutVersion.supports(LayoutVersion.Feature.STORED_TXIDS, this.imageVersion)) {
                v.visit(ImageVisitor.ImageElement.TRANSACTION_ID, in.readLong());
            }
            if (LayoutVersion.supports(LayoutVersion.Feature.FSIMAGE_COMPRESSION, this.imageVersion)) {
                boolean isCompressed = in.readBoolean();
                v.visit(ImageVisitor.ImageElement.IS_COMPRESSED, String.valueOf(isCompressed));
                if (isCompressed) {
                    String codecClassName = Text.readString((DataInput)in);
                    v.visit(ImageVisitor.ImageElement.COMPRESS_CODEC, codecClassName);
                    CompressionCodecFactory codecFac = new CompressionCodecFactory(new Configuration());
                    CompressionCodec codec = codecFac.getCodecByClassName(codecClassName);
                    if (codec == null) {
                        throw new IOException("Image compression codec not supported: " + codecClassName);
                    }
                    in = new DataInputStream((InputStream)codec.createInputStream((InputStream)in));
                }
            }
            this.processINodes(in, v, numInodes, skipBlocks);
            this.processINodesUC(in, v, skipBlocks);
            if (LayoutVersion.supports(LayoutVersion.Feature.DELEGATION_TOKEN, this.imageVersion)) {
                this.processDelegationTokens(in, v);
            }
            v.leaveEnclosingElement();
            done = true;
        }
        finally {
            if (done) {
                v.finish();
            } else {
                v.finishAbnormally();
            }
        }
    }

    private void processDelegationTokens(DataInputStream in, ImageVisitor v) throws IOException {
        v.visit(ImageVisitor.ImageElement.CURRENT_DELEGATION_KEY_ID, in.readInt());
        int numDKeys = in.readInt();
        v.visitEnclosingElement(ImageVisitor.ImageElement.DELEGATION_KEYS, ImageVisitor.ImageElement.NUM_DELEGATION_KEYS, numDKeys);
        for (int i = 0; i < numDKeys; ++i) {
            DelegationKey key = new DelegationKey();
            key.readFields((DataInput)in);
            v.visit(ImageVisitor.ImageElement.DELEGATION_KEY, key.toString());
        }
        v.leaveEnclosingElement();
        v.visit(ImageVisitor.ImageElement.DELEGATION_TOKEN_SEQUENCE_NUMBER, in.readInt());
        int numDTokens = in.readInt();
        v.visitEnclosingElement(ImageVisitor.ImageElement.DELEGATION_TOKENS, ImageVisitor.ImageElement.NUM_DELEGATION_TOKENS, numDTokens);
        for (int i = 0; i < numDTokens; ++i) {
            DelegationTokenIdentifier id = new DelegationTokenIdentifier();
            id.readFields(in);
            long expiryTime = in.readLong();
            v.visitEnclosingElement(ImageVisitor.ImageElement.DELEGATION_TOKEN_IDENTIFIER);
            v.visit(ImageVisitor.ImageElement.DELEGATION_TOKEN_IDENTIFIER_KIND, id.getKind().toString());
            v.visit(ImageVisitor.ImageElement.DELEGATION_TOKEN_IDENTIFIER_SEQNO, id.getSequenceNumber());
            v.visit(ImageVisitor.ImageElement.DELEGATION_TOKEN_IDENTIFIER_OWNER, id.getOwner().toString());
            v.visit(ImageVisitor.ImageElement.DELEGATION_TOKEN_IDENTIFIER_RENEWER, id.getRenewer().toString());
            v.visit(ImageVisitor.ImageElement.DELEGATION_TOKEN_IDENTIFIER_REALUSER, id.getRealUser().toString());
            v.visit(ImageVisitor.ImageElement.DELEGATION_TOKEN_IDENTIFIER_ISSUE_DATE, id.getIssueDate());
            v.visit(ImageVisitor.ImageElement.DELEGATION_TOKEN_IDENTIFIER_MAX_DATE, id.getMaxDate());
            v.visit(ImageVisitor.ImageElement.DELEGATION_TOKEN_IDENTIFIER_EXPIRY_TIME, expiryTime);
            v.visit(ImageVisitor.ImageElement.DELEGATION_TOKEN_IDENTIFIER_MASTER_KEY_ID, id.getMasterKeyId());
            v.leaveEnclosingElement();
        }
        v.leaveEnclosingElement();
    }

    private void processINodesUC(DataInputStream in, ImageVisitor v, boolean skipBlocks) throws IOException {
        int numINUC = in.readInt();
        v.visitEnclosingElement(ImageVisitor.ImageElement.INODES_UNDER_CONSTRUCTION, ImageVisitor.ImageElement.NUM_INODES_UNDER_CONSTRUCTION, numINUC);
        for (int i = 0; i < numINUC; ++i) {
            v.visitEnclosingElement(ImageVisitor.ImageElement.INODE_UNDER_CONSTRUCTION);
            byte[] name = FSImageSerialization.readBytes(in);
            String n = new String(name, "UTF8");
            v.visit(ImageVisitor.ImageElement.INODE_PATH, n);
            v.visit(ImageVisitor.ImageElement.REPLICATION, in.readShort());
            v.visit(ImageVisitor.ImageElement.MODIFICATION_TIME, this.formatDate(in.readLong()));
            v.visit(ImageVisitor.ImageElement.PREFERRED_BLOCK_SIZE, in.readLong());
            int numBlocks = in.readInt();
            this.processBlocks(in, v, numBlocks, skipBlocks);
            this.processPermission(in, v);
            v.visit(ImageVisitor.ImageElement.CLIENT_NAME, FSImageSerialization.readString(in));
            v.visit(ImageVisitor.ImageElement.CLIENT_MACHINE, FSImageSerialization.readString(in));
            int numLocs = in.readInt();
            for (int j = 0; j < numLocs; ++j) {
                in.readShort();
                in.readLong();
                in.readLong();
                in.readLong();
                in.readInt();
                FSImageSerialization.readString(in);
                FSImageSerialization.readString(in);
                WritableUtils.readEnum((DataInput)in, DatanodeInfo.AdminStates.class);
            }
            v.leaveEnclosingElement();
        }
        v.leaveEnclosingElement();
    }

    private void processBlocks(DataInputStream in, ImageVisitor v, int numBlocks, boolean skipBlocks) throws IOException {
        v.visitEnclosingElement(ImageVisitor.ImageElement.BLOCKS, ImageVisitor.ImageElement.NUM_BLOCKS, numBlocks);
        if (numBlocks == -1 || numBlocks == -2) {
            v.leaveEnclosingElement();
            return;
        }
        if (skipBlocks) {
            int bytesToSkip = 24 * numBlocks;
            if (in.skipBytes(bytesToSkip) != bytesToSkip) {
                throw new IOException("Error skipping over blocks");
            }
        } else {
            for (int j = 0; j < numBlocks; ++j) {
                v.visitEnclosingElement(ImageVisitor.ImageElement.BLOCK);
                v.visit(ImageVisitor.ImageElement.BLOCK_ID, in.readLong());
                v.visit(ImageVisitor.ImageElement.NUM_BYTES, in.readLong());
                v.visit(ImageVisitor.ImageElement.GENERATION_STAMP, in.readLong());
                v.leaveEnclosingElement();
            }
        }
        v.leaveEnclosingElement();
    }

    private void processPermission(DataInputStream in, ImageVisitor v) throws IOException {
        v.visitEnclosingElement(ImageVisitor.ImageElement.PERMISSIONS);
        v.visit(ImageVisitor.ImageElement.USER_NAME, Text.readString((DataInput)in));
        v.visit(ImageVisitor.ImageElement.GROUP_NAME, Text.readString((DataInput)in));
        FsPermission fsp = new FsPermission(in.readShort());
        v.visit(ImageVisitor.ImageElement.PERMISSION_STRING, fsp.toString());
        v.leaveEnclosingElement();
    }

    private void processINodes(DataInputStream in, ImageVisitor v, long numInodes, boolean skipBlocks) throws IOException {
        v.visitEnclosingElement(ImageVisitor.ImageElement.INODES, ImageVisitor.ImageElement.NUM_INODES, numInodes);
        if (LayoutVersion.supports(LayoutVersion.Feature.FSIMAGE_NAME_OPTIMIZATION, this.imageVersion)) {
            this.processLocalNameINodes(in, v, numInodes, skipBlocks);
        } else {
            this.processFullNameINodes(in, v, numInodes, skipBlocks);
        }
        v.leaveEnclosingElement();
    }

    private void processLocalNameINodes(DataInputStream in, ImageVisitor v, long numInodes, boolean skipBlocks) throws IOException {
        this.processINode(in, v, skipBlocks, "");
        --numInodes;
        while (numInodes > 0L) {
            numInodes -= (long)this.processDirectory(in, v, skipBlocks);
        }
    }

    private int processDirectory(DataInputStream in, ImageVisitor v, boolean skipBlocks) throws IOException {
        String parentName = FSImageSerialization.readString(in);
        int numChildren = in.readInt();
        for (int i = 0; i < numChildren; ++i) {
            this.processINode(in, v, skipBlocks, parentName);
        }
        return numChildren;
    }

    private void processFullNameINodes(DataInputStream in, ImageVisitor v, long numInodes, boolean skipBlocks) throws IOException {
        for (long i = 0L; i < numInodes; ++i) {
            this.processINode(in, v, skipBlocks, null);
        }
    }

    private void processINode(DataInputStream in, ImageVisitor v, boolean skipBlocks, String parentName) throws IOException {
        v.visitEnclosingElement(ImageVisitor.ImageElement.INODE);
        String pathName = FSImageSerialization.readString(in);
        if (parentName != null) {
            pathName = "/" + pathName;
            if (!"/".equals(parentName)) {
                pathName = parentName + pathName;
            }
        }
        v.visit(ImageVisitor.ImageElement.INODE_PATH, pathName);
        v.visit(ImageVisitor.ImageElement.REPLICATION, in.readShort());
        v.visit(ImageVisitor.ImageElement.MODIFICATION_TIME, this.formatDate(in.readLong()));
        if (LayoutVersion.supports(LayoutVersion.Feature.FILE_ACCESS_TIME, this.imageVersion)) {
            v.visit(ImageVisitor.ImageElement.ACCESS_TIME, this.formatDate(in.readLong()));
        }
        v.visit(ImageVisitor.ImageElement.BLOCK_SIZE, in.readLong());
        int numBlocks = in.readInt();
        this.processBlocks(in, v, numBlocks, skipBlocks);
        if (numBlocks > 0 || numBlocks == -1) {
            v.visit(ImageVisitor.ImageElement.NS_QUOTA, numBlocks == -1 ? in.readLong() : -1L);
            if (LayoutVersion.supports(LayoutVersion.Feature.DISKSPACE_QUOTA, this.imageVersion)) {
                v.visit(ImageVisitor.ImageElement.DS_QUOTA, numBlocks == -1 ? in.readLong() : -1L);
            }
        }
        if (numBlocks == -2) {
            v.visit(ImageVisitor.ImageElement.SYMLINK, Text.readString((DataInput)in));
        }
        this.processPermission(in, v);
        v.leaveEnclosingElement();
    }

    private String formatDate(long date) {
        return this.dateFormat.format(new Date(date));
    }
}

