/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.MD5MD5CRC32CastagnoliFileChecksum;
import org.apache.hadoop.fs.MD5MD5CRC32FileChecksum;
import org.apache.hadoop.fs.MD5MD5CRC32GzipFileChecksum;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.util.DataChecksum;
import org.apache.hadoop.util.StringUtils;
import org.mortbay.util.ajax.JSON;

public class JsonUtil {
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private static final DatanodeInfo[] EMPTY_DATANODE_INFO_ARRAY = new DatanodeInfo[0];

    public static String toJsonString(Token<? extends TokenIdentifier> token) throws IOException {
        return JsonUtil.toJsonString(Token.class, JsonUtil.toJsonMap(token));
    }

    private static Map<String, Object> toJsonMap(Token<? extends TokenIdentifier> token) throws IOException {
        if (token == null) {
            return null;
        }
        TreeMap<String, Object> m = new TreeMap<String, Object>();
        m.put("urlString", token.encodeToUrlString());
        return m;
    }

    public static Token<? extends TokenIdentifier> toToken(Map<?, ?> m) throws IOException {
        if (m == null) {
            return null;
        }
        Token token = new Token();
        token.decodeFromUrlString((String)m.get("urlString"));
        return token;
    }

    public static Token<DelegationTokenIdentifier> toDelegationToken(Map<?, ?> json) throws IOException {
        Map m = (Map)json.get(Token.class.getSimpleName());
        return JsonUtil.toToken(m);
    }

    private static Token<BlockTokenIdentifier> toBlockToken(Map<?, ?> m) throws IOException {
        return JsonUtil.toToken(m);
    }

    private static Object[] toJsonArray(Token<? extends TokenIdentifier>[] array) throws IOException {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_OBJECT_ARRAY;
        }
        Object[] a = new Object[array.length];
        for (int i = 0; i < array.length; ++i) {
            a[i] = JsonUtil.toJsonMap(array[i]);
        }
        return a;
    }

    public static String toJsonString(Token<? extends TokenIdentifier>[] tokens) throws IOException {
        if (tokens == null) {
            return null;
        }
        TreeMap<String, Object[]> m = new TreeMap<String, Object[]>();
        m.put(Token.class.getSimpleName(), JsonUtil.toJsonArray(tokens));
        return JsonUtil.toJsonString(Token.class.getSimpleName() + "s", m);
    }

    private static List<Token<?>> toTokenList(Object[] objects) throws IOException {
        if (objects == null) {
            return null;
        }
        if (objects.length == 0) {
            return Collections.emptyList();
        }
        ArrayList list = new ArrayList(objects.length);
        for (int i = 0; i < objects.length; ++i) {
            list.add(JsonUtil.toToken((Map)objects[i]));
        }
        return list;
    }

    public static List<Token<?>> toTokenList(Map<?, ?> json) throws IOException {
        if (json == null) {
            return null;
        }
        Map m = (Map)json.get(Token.class.getSimpleName() + "s");
        return JsonUtil.toTokenList((Object[])m.get(Token.class.getSimpleName()));
    }

    public static String toJsonString(Exception e) {
        TreeMap<String, String> m = new TreeMap<String, String>();
        m.put("exception", e.getClass().getSimpleName());
        m.put("message", e.getMessage());
        m.put("javaClassName", e.getClass().getName());
        return JsonUtil.toJsonString(RemoteException.class, m);
    }

    public static RemoteException toRemoteException(Map<?, ?> json) {
        Map m = (Map)json.get(RemoteException.class.getSimpleName());
        String message = (String)m.get("message");
        String javaClassName = (String)m.get("javaClassName");
        return new RemoteException(javaClassName, message);
    }

    private static String toJsonString(Class<?> clazz, Object value) {
        return JsonUtil.toJsonString(clazz.getSimpleName(), value);
    }

    public static String toJsonString(String key, Object value) {
        TreeMap<String, Object> m = new TreeMap<String, Object>();
        m.put(key, value);
        return JSON.toString(m);
    }

    private static String toString(FsPermission permission) {
        return String.format("%o", permission.toShort());
    }

    private static FsPermission toFsPermission(String s) {
        return new FsPermission(Short.parseShort(s, 8));
    }

    public static String toJsonString(HdfsFileStatus status, boolean includeType) {
        if (status == null) {
            return null;
        }
        TreeMap<String, Object> m = new TreeMap<String, Object>();
        m.put("pathSuffix", status.getLocalName());
        m.put("type", (Object)PathType.valueOf(status));
        if (status.isSymlink()) {
            m.put("symlink", status.getSymlink());
        }
        m.put("length", status.getLen());
        m.put("owner", status.getOwner());
        m.put("group", status.getGroup());
        m.put("permission", JsonUtil.toString(status.getPermission()));
        m.put("accessTime", status.getAccessTime());
        m.put("modificationTime", status.getModificationTime());
        m.put("blockSize", status.getBlockSize());
        m.put("replication", status.getReplication());
        return includeType ? JsonUtil.toJsonString(FileStatus.class, m) : JSON.toString(m);
    }

    public static HdfsFileStatus toFileStatus(Map<?, ?> json, boolean includesType) {
        if (json == null) {
            return null;
        }
        Map m = includesType ? (Map)json.get(FileStatus.class.getSimpleName()) : json;
        String localName = (String)m.get("pathSuffix");
        PathType type = PathType.valueOf((String)m.get("type"));
        byte[] symlink = type != PathType.SYMLINK ? null : DFSUtil.string2Bytes((String)m.get("symlink"));
        long len = (Long)m.get("length");
        String owner = (String)m.get("owner");
        String group = (String)m.get("group");
        FsPermission permission = JsonUtil.toFsPermission((String)m.get("permission"));
        long aTime = (Long)m.get("accessTime");
        long mTime = (Long)m.get("modificationTime");
        long blockSize = (Long)m.get("blockSize");
        short replication = (short)((Long)m.get("replication")).longValue();
        return new HdfsFileStatus(len, type == PathType.DIRECTORY, replication, blockSize, mTime, aTime, permission, owner, group, symlink, DFSUtil.string2Bytes(localName));
    }

    private static Map<String, Object> toJsonMap(ExtendedBlock extendedblock) {
        if (extendedblock == null) {
            return null;
        }
        TreeMap<String, Object> m = new TreeMap<String, Object>();
        m.put("blockPoolId", extendedblock.getBlockPoolId());
        m.put("blockId", extendedblock.getBlockId());
        m.put("numBytes", extendedblock.getNumBytes());
        m.put("generationStamp", extendedblock.getGenerationStamp());
        return m;
    }

    private static ExtendedBlock toExtendedBlock(Map<?, ?> m) {
        if (m == null) {
            return null;
        }
        String blockPoolId = (String)m.get("blockPoolId");
        long blockId = (Long)m.get("blockId");
        long numBytes = (Long)m.get("numBytes");
        long generationStamp = (Long)m.get("generationStamp");
        return new ExtendedBlock(blockPoolId, blockId, numBytes, generationStamp);
    }

    private static Map<String, Object> toJsonMap(DatanodeInfo datanodeinfo) {
        if (datanodeinfo == null) {
            return null;
        }
        TreeMap<String, Object> m = new TreeMap<String, Object>();
        m.put("ipAddr", datanodeinfo.getIpAddr());
        m.put("hostName", datanodeinfo.getHostName());
        m.put("storageID", datanodeinfo.getStorageID());
        m.put("xferPort", datanodeinfo.getXferPort());
        m.put("infoPort", datanodeinfo.getInfoPort());
        m.put("ipcPort", datanodeinfo.getIpcPort());
        m.put("capacity", datanodeinfo.getCapacity());
        m.put("dfsUsed", datanodeinfo.getDfsUsed());
        m.put("remaining", datanodeinfo.getRemaining());
        m.put("blockPoolUsed", datanodeinfo.getBlockPoolUsed());
        m.put("lastUpdate", datanodeinfo.getLastUpdate());
        m.put("xceiverCount", datanodeinfo.getXceiverCount());
        m.put("networkLocation", datanodeinfo.getNetworkLocation());
        m.put("adminState", datanodeinfo.getAdminState().name());
        return m;
    }

    private static DatanodeInfo toDatanodeInfo(Map<?, ?> m) {
        if (m == null) {
            return null;
        }
        return new DatanodeInfo((String)m.get("ipAddr"), (String)m.get("hostName"), (String)m.get("storageID"), (int)((Long)m.get("xferPort")).longValue(), (int)((Long)m.get("infoPort")).longValue(), (int)((Long)m.get("ipcPort")).longValue(), (Long)m.get("capacity"), (Long)m.get("dfsUsed"), (Long)m.get("remaining"), (Long)m.get("blockPoolUsed"), (Long)m.get("lastUpdate"), (int)((Long)m.get("xceiverCount")).longValue(), (String)m.get("networkLocation"), DatanodeInfo.AdminStates.valueOf((String)m.get("adminState")));
    }

    private static Object[] toJsonArray(DatanodeInfo[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_OBJECT_ARRAY;
        }
        Object[] a = new Object[array.length];
        for (int i = 0; i < array.length; ++i) {
            a[i] = JsonUtil.toJsonMap(array[i]);
        }
        return a;
    }

    private static DatanodeInfo[] toDatanodeInfoArray(Object[] objects) {
        if (objects == null) {
            return null;
        }
        if (objects.length == 0) {
            return EMPTY_DATANODE_INFO_ARRAY;
        }
        DatanodeInfo[] array = new DatanodeInfo[objects.length];
        for (int i = 0; i < array.length; ++i) {
            array[i] = JsonUtil.toDatanodeInfo((Map)objects[i]);
        }
        return array;
    }

    private static Map<String, Object> toJsonMap(LocatedBlock locatedblock) throws IOException {
        if (locatedblock == null) {
            return null;
        }
        TreeMap<String, Object> m = new TreeMap<String, Object>();
        m.put("blockToken", JsonUtil.toJsonMap(locatedblock.getBlockToken()));
        m.put("isCorrupt", locatedblock.isCorrupt());
        m.put("startOffset", locatedblock.getStartOffset());
        m.put("block", JsonUtil.toJsonMap(locatedblock.getBlock()));
        m.put("locations", JsonUtil.toJsonArray(locatedblock.getLocations()));
        return m;
    }

    private static LocatedBlock toLocatedBlock(Map<?, ?> m) throws IOException {
        if (m == null) {
            return null;
        }
        ExtendedBlock b = JsonUtil.toExtendedBlock((Map)m.get("block"));
        DatanodeInfo[] locations = JsonUtil.toDatanodeInfoArray((Object[])m.get("locations"));
        long startOffset = (Long)m.get("startOffset");
        boolean isCorrupt = (Boolean)m.get("isCorrupt");
        LocatedBlock locatedblock = new LocatedBlock(b, locations, startOffset, isCorrupt);
        locatedblock.setBlockToken(JsonUtil.toBlockToken((Map)m.get("blockToken")));
        return locatedblock;
    }

    private static Object[] toJsonArray(List<LocatedBlock> array) throws IOException {
        if (array == null) {
            return null;
        }
        if (array.size() == 0) {
            return EMPTY_OBJECT_ARRAY;
        }
        Object[] a = new Object[array.size()];
        for (int i = 0; i < array.size(); ++i) {
            a[i] = JsonUtil.toJsonMap(array.get(i));
        }
        return a;
    }

    private static List<LocatedBlock> toLocatedBlockList(Object[] objects) throws IOException {
        if (objects == null) {
            return null;
        }
        if (objects.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<LocatedBlock> list = new ArrayList<LocatedBlock>(objects.length);
        for (int i = 0; i < objects.length; ++i) {
            list.add(JsonUtil.toLocatedBlock((Map)objects[i]));
        }
        return list;
    }

    public static String toJsonString(LocatedBlocks locatedblocks) throws IOException {
        if (locatedblocks == null) {
            return null;
        }
        TreeMap<String, Object> m = new TreeMap<String, Object>();
        m.put("fileLength", locatedblocks.getFileLength());
        m.put("isUnderConstruction", locatedblocks.isUnderConstruction());
        m.put("locatedBlocks", JsonUtil.toJsonArray(locatedblocks.getLocatedBlocks()));
        m.put("lastLocatedBlock", JsonUtil.toJsonMap(locatedblocks.getLastLocatedBlock()));
        m.put("isLastBlockComplete", locatedblocks.isLastBlockComplete());
        return JsonUtil.toJsonString(LocatedBlocks.class, m);
    }

    public static LocatedBlocks toLocatedBlocks(Map<?, ?> json) throws IOException {
        if (json == null) {
            return null;
        }
        Map m = (Map)json.get(LocatedBlocks.class.getSimpleName());
        long fileLength = (Long)m.get("fileLength");
        boolean isUnderConstruction = (Boolean)m.get("isUnderConstruction");
        List<LocatedBlock> locatedBlocks = JsonUtil.toLocatedBlockList((Object[])m.get("locatedBlocks"));
        LocatedBlock lastLocatedBlock = JsonUtil.toLocatedBlock((Map)m.get("lastLocatedBlock"));
        boolean isLastBlockComplete = (Boolean)m.get("isLastBlockComplete");
        return new LocatedBlocks(fileLength, isUnderConstruction, locatedBlocks, lastLocatedBlock, isLastBlockComplete);
    }

    public static String toJsonString(ContentSummary contentsummary) {
        if (contentsummary == null) {
            return null;
        }
        TreeMap<String, Long> m = new TreeMap<String, Long>();
        m.put("length", contentsummary.getLength());
        m.put("fileCount", contentsummary.getFileCount());
        m.put("directoryCount", contentsummary.getDirectoryCount());
        m.put("quota", contentsummary.getQuota());
        m.put("spaceConsumed", contentsummary.getSpaceConsumed());
        m.put("spaceQuota", contentsummary.getSpaceQuota());
        return JsonUtil.toJsonString(ContentSummary.class, m);
    }

    public static ContentSummary toContentSummary(Map<?, ?> json) {
        if (json == null) {
            return null;
        }
        Map m = (Map)json.get(ContentSummary.class.getSimpleName());
        long length = (Long)m.get("length");
        long fileCount = (Long)m.get("fileCount");
        long directoryCount = (Long)m.get("directoryCount");
        long quota = (Long)m.get("quota");
        long spaceConsumed = (Long)m.get("spaceConsumed");
        long spaceQuota = (Long)m.get("spaceQuota");
        return new ContentSummary(length, fileCount, directoryCount, quota, spaceConsumed, spaceQuota);
    }

    public static String toJsonString(MD5MD5CRC32FileChecksum checksum) {
        if (checksum == null) {
            return null;
        }
        TreeMap<String, Object> m = new TreeMap<String, Object>();
        m.put("algorithm", checksum.getAlgorithmName());
        m.put("length", checksum.getLength());
        m.put("bytes", StringUtils.byteToHexString((byte[])checksum.getBytes()));
        return JsonUtil.toJsonString(FileChecksum.class, m);
    }

    public static MD5MD5CRC32FileChecksum toMD5MD5CRC32FileChecksum(Map<?, ?> json) throws IOException {
        MD5MD5CRC32GzipFileChecksum checksum;
        if (json == null) {
            return null;
        }
        Map m = (Map)json.get(FileChecksum.class.getSimpleName());
        String algorithm = (String)m.get("algorithm");
        int length = (int)((Long)m.get("length")).longValue();
        byte[] bytes = StringUtils.hexStringToByte((String)((String)m.get("bytes")));
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(bytes));
        DataChecksum.Type crcType = MD5MD5CRC32FileChecksum.getCrcTypeFromAlgorithmName((String)algorithm);
        switch (crcType) {
            case CRC32: {
                checksum = new MD5MD5CRC32GzipFileChecksum();
                break;
            }
            case CRC32C: {
                checksum = new MD5MD5CRC32CastagnoliFileChecksum();
                break;
            }
            default: {
                throw new IOException("Unknown algorithm: " + algorithm);
            }
        }
        checksum.readFields((DataInput)in);
        if (!checksum.getAlgorithmName().equals(algorithm)) {
            throw new IOException("Algorithm not matched. Expected " + algorithm + ", Received " + checksum.getAlgorithmName());
        }
        if (length != checksum.getLength()) {
            throw new IOException("Length not matched: length=" + length + ", checksum.getLength()=" + checksum.getLength());
        }
        return checksum;
    }

    static enum PathType {
        FILE,
        DIRECTORY,
        SYMLINK;


        static PathType valueOf(HdfsFileStatus status) {
            return status.isDir() ? DIRECTORY : (status.isSymlink() ? SYMLINK : FILE);
        }
    }
}

