/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.asserting;

import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.lucene.codecs.DocValuesConsumer;
import org.apache.lucene.codecs.DocValuesFormat;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.codecs.lucene42.Lucene42DocValuesFormat;
import org.apache.lucene.index.AssertingAtomicReader;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.OpenBitSet;

public class AssertingDocValuesFormat
extends DocValuesFormat {
    private final DocValuesFormat in = new Lucene42DocValuesFormat();

    public AssertingDocValuesFormat() {
        super("Asserting");
    }

    public DocValuesConsumer fieldsConsumer(SegmentWriteState state) throws IOException {
        DocValuesConsumer consumer = this.in.fieldsConsumer(state);
        assert (consumer != null);
        return new AssertingDocValuesConsumer(consumer, state.segmentInfo.getDocCount());
    }

    public DocValuesProducer fieldsProducer(SegmentReadState state) throws IOException {
        assert (state.fieldInfos.hasDocValues());
        DocValuesProducer producer = this.in.fieldsProducer(state);
        assert (producer != null);
        return new AssertingDocValuesProducer(producer, state.segmentInfo.getDocCount());
    }

    static class AssertingDocValuesProducer
    extends DocValuesProducer {
        private final DocValuesProducer in;
        private final int maxDoc;

        AssertingDocValuesProducer(DocValuesProducer in, int maxDoc) {
            this.in = in;
            this.maxDoc = maxDoc;
        }

        public NumericDocValues getNumeric(FieldInfo field) throws IOException {
            assert (field.getDocValuesType() == FieldInfo.DocValuesType.NUMERIC || field.getNormType() == FieldInfo.DocValuesType.NUMERIC);
            NumericDocValues values = this.in.getNumeric(field);
            assert (values != null);
            return new AssertingAtomicReader.AssertingNumericDocValues(values, this.maxDoc);
        }

        public BinaryDocValues getBinary(FieldInfo field) throws IOException {
            assert (field.getDocValuesType() == FieldInfo.DocValuesType.BINARY);
            BinaryDocValues values = this.in.getBinary(field);
            assert (values != null);
            return new AssertingAtomicReader.AssertingBinaryDocValues(values, this.maxDoc);
        }

        public SortedDocValues getSorted(FieldInfo field) throws IOException {
            assert (field.getDocValuesType() == FieldInfo.DocValuesType.SORTED);
            SortedDocValues values = this.in.getSorted(field);
            assert (values != null);
            return new AssertingAtomicReader.AssertingSortedDocValues(values, this.maxDoc);
        }

        public SortedSetDocValues getSortedSet(FieldInfo field) throws IOException {
            assert (field.getDocValuesType() == FieldInfo.DocValuesType.SORTED_SET);
            SortedSetDocValues values = this.in.getSortedSet(field);
            assert (values != null);
            return new AssertingAtomicReader.AssertingSortedSetDocValues(values, this.maxDoc);
        }

        public void close() throws IOException {
            this.in.close();
        }
    }

    static class AssertingDocValuesConsumer
    extends DocValuesConsumer {
        private final DocValuesConsumer in;
        private final int maxDoc;

        AssertingDocValuesConsumer(DocValuesConsumer in, int maxDoc) {
            this.in = in;
            this.maxDoc = maxDoc;
        }

        public void addNumericField(FieldInfo field, Iterable<Number> values) throws IOException {
            int count = 0;
            for (Number v : values) {
                assert (v != null);
                ++count;
            }
            assert (count == this.maxDoc);
            this.checkIterator(values.iterator(), this.maxDoc);
            this.in.addNumericField(field, values);
        }

        public void addBinaryField(FieldInfo field, Iterable<BytesRef> values) throws IOException {
            int count = 0;
            for (BytesRef b : values) {
                assert (b != null);
                assert (b.isValid());
                ++count;
            }
            assert (count == this.maxDoc);
            this.checkIterator(values.iterator(), this.maxDoc);
            this.in.addBinaryField(field, values);
        }

        public void addSortedField(FieldInfo field, Iterable<BytesRef> values, Iterable<Number> docToOrd) throws IOException {
            int valueCount = 0;
            BytesRef lastValue = null;
            for (BytesRef b : values) {
                assert (b != null);
                assert (b.isValid());
                if (valueCount > 0) assert (b.compareTo(lastValue) > 0);
                lastValue = BytesRef.deepCopyOf((BytesRef)b);
                ++valueCount;
            }
            assert (valueCount <= this.maxDoc);
            FixedBitSet seenOrds = new FixedBitSet(valueCount);
            int count = 0;
            for (Number v : docToOrd) {
                assert (v != null);
                int ord = v.intValue();
                assert (ord >= 0 && ord < valueCount);
                seenOrds.set(ord);
                ++count;
            }
            assert (count == this.maxDoc);
            assert (seenOrds.cardinality() == valueCount);
            this.checkIterator(values.iterator(), valueCount);
            this.checkIterator(docToOrd.iterator(), this.maxDoc);
            this.in.addSortedField(field, values, docToOrd);
        }

        public void addSortedSetField(FieldInfo field, Iterable<BytesRef> values, Iterable<Number> docToOrdCount, Iterable<Number> ords) throws IOException {
            long valueCount = 0L;
            BytesRef lastValue = null;
            for (BytesRef b : values) {
                assert (b != null);
                assert (b.isValid());
                if (valueCount > 0L) assert (b.compareTo(lastValue) > 0);
                lastValue = BytesRef.deepCopyOf((BytesRef)b);
                ++valueCount;
            }
            int docCount = 0;
            long ordCount = 0L;
            OpenBitSet seenOrds = new OpenBitSet(valueCount);
            Iterator<Number> ordIterator = ords.iterator();
            for (Number v : docToOrdCount) {
                assert (v != null);
                int count = v.intValue();
                assert (count >= 0);
                ++docCount;
                ordCount += (long)count;
                long lastOrd = -1L;
                for (int i = 0; i < count; ++i) {
                    Number o = ordIterator.next();
                    assert (o != null);
                    long ord = o.longValue();
                    assert (ord >= 0L && ord < valueCount);
                    assert (ord > lastOrd) : "ord=" + ord + ",lastOrd=" + lastOrd;
                    seenOrds.set(ord);
                    lastOrd = ord;
                }
            }
            assert (!ordIterator.hasNext());
            assert (docCount == this.maxDoc);
            assert (seenOrds.cardinality() == valueCount);
            this.checkIterator(values.iterator(), valueCount);
            this.checkIterator(docToOrdCount.iterator(), this.maxDoc);
            this.checkIterator(ords.iterator(), ordCount);
            this.in.addSortedSetField(field, values, docToOrdCount, ords);
        }

        private <T> void checkIterator(Iterator<T> iterator, long expectedSize) {
            for (long i = 0L; i < expectedSize; ++i) {
                boolean hasNext = iterator.hasNext();
                assert (hasNext);
                T v = iterator.next();
                assert (v != null);
                try {
                    iterator.remove();
                    throw new AssertionError((Object)("broken iterator (supports remove): " + iterator));
                }
                catch (UnsupportedOperationException expected) {
                    continue;
                }
            }
            assert (!iterator.hasNext());
            try {
                iterator.next();
                throw new AssertionError((Object)("broken iterator (allows next() when hasNext==false) " + iterator));
            }
            catch (NoSuchElementException expected) {
                return;
            }
        }

        public void close() throws IOException {
            this.in.close();
        }
    }
}

