/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene40;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.PostingsWriterBase;
import org.apache.lucene.codecs.TermStats;
import org.apache.lucene.codecs.lucene40.Lucene40SkipListWriter;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.RAMOutputStream;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;

public final class Lucene40PostingsWriter
extends PostingsWriterBase {
    final IndexOutput freqOut;
    final IndexOutput proxOut;
    final Lucene40SkipListWriter skipListWriter;
    static final int DEFAULT_SKIP_INTERVAL = 16;
    final int skipInterval;
    final int skipMinimum;
    final int maxSkipLevels = 10;
    final int totalNumDocs;
    IndexOutput termsOut;
    FieldInfo.IndexOptions indexOptions;
    boolean storePayloads;
    boolean storeOffsets;
    long freqStart;
    long proxStart;
    FieldInfo fieldInfo;
    int lastPayloadLength;
    int lastOffsetLength;
    int lastPosition;
    int lastOffset;
    int lastDocID;
    int df;
    private final List<PendingTerm> pendingTerms;
    private final RAMOutputStream bytesWriter;

    public Lucene40PostingsWriter(SegmentWriteState state) throws IOException {
        this(state, 16);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Lucene40PostingsWriter(SegmentWriteState state, int skipInterval) throws IOException {
        IndexOutput proxOut;
        block5: {
            this.maxSkipLevels = 10;
            this.pendingTerms = new ArrayList<PendingTerm>();
            this.bytesWriter = new RAMOutputStream();
            this.skipInterval = skipInterval;
            this.skipMinimum = skipInterval;
            String fileName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)"frq");
            this.freqOut = state.directory.createOutput(fileName, state.context);
            boolean success = false;
            proxOut = null;
            try {
                CodecUtil.writeHeader((DataOutput)this.freqOut, (String)"Lucene40PostingsWriterFrq", (int)1);
                if (state.fieldInfos.hasProx()) {
                    fileName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)"prx");
                    proxOut = state.directory.createOutput(fileName, state.context);
                    CodecUtil.writeHeader((DataOutput)proxOut, (String)"Lucene40PostingsWriterPrx", (int)1);
                } else {
                    proxOut = null;
                }
                this.proxOut = proxOut;
                success = true;
                if (success) break block5;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.freqOut, proxOut});
                }
                throw throwable;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.freqOut, proxOut});
        }
        this.totalNumDocs = state.segmentInfo.getDocCount();
        this.skipListWriter = new Lucene40SkipListWriter(skipInterval, 10, this.totalNumDocs, this.freqOut, proxOut);
    }

    public void start(IndexOutput termsOut) throws IOException {
        this.termsOut = termsOut;
        CodecUtil.writeHeader((DataOutput)termsOut, (String)"Lucene40PostingsWriterTerms", (int)1);
        termsOut.writeInt(this.skipInterval);
        termsOut.writeInt(10);
        termsOut.writeInt(this.skipMinimum);
    }

    public void startTerm() {
        this.freqStart = this.freqOut.getFilePointer();
        if (this.proxOut != null) {
            this.proxStart = this.proxOut.getFilePointer();
        }
        this.lastPayloadLength = -1;
        this.lastOffsetLength = -1;
        this.skipListWriter.resetSkip();
    }

    public void setField(FieldInfo fieldInfo) {
        this.fieldInfo = fieldInfo;
        this.indexOptions = fieldInfo.getIndexOptions();
        this.storeOffsets = this.indexOptions.compareTo((Enum)FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0;
        this.storePayloads = fieldInfo.hasPayloads();
    }

    public void startDoc(int docID, int termDocFreq) throws IOException {
        int delta = docID - this.lastDocID;
        if (docID < 0 || this.df > 0 && delta <= 0) {
            throw new CorruptIndexException("docs out of order (" + docID + " <= " + this.lastDocID + " ) (freqOut: " + this.freqOut + ")");
        }
        if (++this.df % this.skipInterval == 0) {
            this.skipListWriter.setSkipData(this.lastDocID, this.storePayloads, this.lastPayloadLength, this.storeOffsets, this.lastOffsetLength);
            this.skipListWriter.bufferSkip(this.df);
        }
        assert (docID < this.totalNumDocs) : "docID=" + docID + " totalNumDocs=" + this.totalNumDocs;
        this.lastDocID = docID;
        if (this.indexOptions == FieldInfo.IndexOptions.DOCS_ONLY) {
            this.freqOut.writeVInt(delta);
        } else if (1 == termDocFreq) {
            this.freqOut.writeVInt(delta << 1 | 1);
        } else {
            this.freqOut.writeVInt(delta << 1);
            this.freqOut.writeVInt(termDocFreq);
        }
        this.lastPosition = 0;
        this.lastOffset = 0;
    }

    public void addPosition(int position, BytesRef payload, int startOffset, int endOffset) throws IOException {
        assert (this.indexOptions.compareTo((Enum)FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0) : "invalid indexOptions: " + this.indexOptions;
        assert (this.proxOut != null);
        int delta = position - this.lastPosition;
        assert (delta >= 0) : "position=" + position + " lastPosition=" + this.lastPosition;
        this.lastPosition = position;
        int payloadLength = 0;
        if (this.storePayloads) {
            int n = payloadLength = payload == null ? 0 : payload.length;
            if (payloadLength != this.lastPayloadLength) {
                this.lastPayloadLength = payloadLength;
                this.proxOut.writeVInt(delta << 1 | 1);
                this.proxOut.writeVInt(payloadLength);
            } else {
                this.proxOut.writeVInt(delta << 1);
            }
        } else {
            this.proxOut.writeVInt(delta);
        }
        if (this.storeOffsets) {
            int offsetDelta = startOffset - this.lastOffset;
            int offsetLength = endOffset - startOffset;
            assert (offsetDelta >= 0 && offsetLength >= 0) : "startOffset=" + startOffset + ",lastOffset=" + this.lastOffset + ",endOffset=" + endOffset;
            if (offsetLength != this.lastOffsetLength) {
                this.proxOut.writeVInt(offsetDelta << 1 | 1);
                this.proxOut.writeVInt(offsetLength);
            } else {
                this.proxOut.writeVInt(offsetDelta << 1);
            }
            this.lastOffset = startOffset;
            this.lastOffsetLength = offsetLength;
        }
        if (payloadLength > 0) {
            this.proxOut.writeBytes(payload.bytes, payload.offset, payloadLength);
        }
    }

    public void finishDoc() {
    }

    public void finishTerm(TermStats stats) throws IOException {
        assert (stats.docFreq > 0);
        assert (stats.docFreq == this.df);
        long skipOffset = this.df >= this.skipMinimum ? this.skipListWriter.writeSkip(this.freqOut) - this.freqStart : -1L;
        this.pendingTerms.add(new PendingTerm(this.freqStart, this.proxStart, skipOffset));
        this.lastDocID = 0;
        this.df = 0;
    }

    public void flushTermsBlock(int start, int count) throws IOException {
        if (count == 0) {
            this.termsOut.writeByte((byte)0);
            return;
        }
        assert (start <= this.pendingTerms.size());
        assert (count <= start);
        int limit = this.pendingTerms.size() - start + count;
        PendingTerm firstTerm = this.pendingTerms.get(limit - count);
        this.bytesWriter.writeVLong(firstTerm.freqStart);
        if (firstTerm.skipOffset != -1L) {
            assert (firstTerm.skipOffset > 0L);
            this.bytesWriter.writeVLong(firstTerm.skipOffset);
        }
        if (this.indexOptions.compareTo((Enum)FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0) {
            this.bytesWriter.writeVLong(firstTerm.proxStart);
        }
        long lastFreqStart = firstTerm.freqStart;
        long lastProxStart = firstTerm.proxStart;
        for (int idx = limit - count + 1; idx < limit; ++idx) {
            PendingTerm term = this.pendingTerms.get(idx);
            this.bytesWriter.writeVLong(term.freqStart - lastFreqStart);
            lastFreqStart = term.freqStart;
            if (term.skipOffset != -1L) {
                assert (term.skipOffset > 0L);
                this.bytesWriter.writeVLong(term.skipOffset);
            }
            if (this.indexOptions.compareTo((Enum)FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) < 0) continue;
            this.bytesWriter.writeVLong(term.proxStart - lastProxStart);
            lastProxStart = term.proxStart;
        }
        this.termsOut.writeVInt((int)this.bytesWriter.getFilePointer());
        this.bytesWriter.writeTo(this.termsOut);
        this.bytesWriter.reset();
        this.pendingTerms.subList(limit - count, limit).clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            this.freqOut.close();
        }
        finally {
            if (this.proxOut != null) {
                this.proxOut.close();
            }
        }
    }

    private static class PendingTerm {
        public final long freqStart;
        public final long proxStart;
        public final long skipOffset;

        public PendingTerm(long freqStart, long proxStart, long skipOffset) {
            this.freqStart = freqStart;
            this.proxStart = proxStart;
            this.skipOffset = skipOffset;
        }
    }
}

