/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.cbean.ckey;

import java.util.List;
import org.seasar.dbflute.cbean.cipher.ColumnFunctionCipher;
import org.seasar.dbflute.cbean.ckey.ConditionKey;
import org.seasar.dbflute.cbean.coption.ConditionOption;
import org.seasar.dbflute.cbean.coption.LikeSearchOption;
import org.seasar.dbflute.cbean.cvalue.ConditionValue;
import org.seasar.dbflute.cbean.sqlclause.query.QueryClause;
import org.seasar.dbflute.dbmeta.name.ColumnRealName;

public class ConditionKeyLikeSearch
extends ConditionKey {
    private static final long serialVersionUID = 1L;

    protected ConditionKeyLikeSearch() {
        this._conditionKey = this.defineConditionKey();
        this._operand = this.defineOperand();
    }

    protected String defineConditionKey() {
        return "likeSearch";
    }

    protected String defineOperand() {
        return "like";
    }

    @Override
    protected boolean doIsValidRegistration(ConditionValue cvalue, Object value, ColumnRealName callerName) {
        return value != null;
    }

    @Override
    protected void doAddWhereClause(List<QueryClause> conditionList, ColumnRealName columnRealName, ConditionValue value, ColumnFunctionCipher cipher, ConditionOption option) {
        this.assertLikeSearchOption(columnRealName, value, option);
        conditionList.add(this.buildBindClause(columnRealName, this.getLocation(value), cipher, option));
    }

    protected void assertLikeSearchOption(ColumnRealName columnRealName, ConditionValue value, ConditionOption option) {
        if (option == null) {
            String msg = "The argument 'option' should not be null:";
            msg = msg + " columnName=" + columnRealName + " value=" + value;
            throw new IllegalArgumentException(msg);
        }
        if (!(option instanceof LikeSearchOption)) {
            String msg = "The argument 'option' should be LikeSearchOption:";
            msg = msg + " columnName=" + columnRealName + " value=" + value;
            msg = msg + " option=" + option;
            throw new IllegalArgumentException(msg);
        }
    }

    protected String getLocation(ConditionValue value) {
        return value.getLikeSearchLatestLocation();
    }

    @Override
    protected boolean isOutOfBindEncryptConditionKey() {
        return true;
    }

    @Override
    protected void doSetupConditionValue(ConditionValue cvalue, Object value, String location, ConditionOption option) {
        cvalue.setupLikeSearch((String)value, (LikeSearchOption)option, location);
    }
}

