/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.dbmeta.info;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.seasar.dbflute.Entity;
import org.seasar.dbflute.dbmeta.DBMeta;
import org.seasar.dbflute.dbmeta.info.ColumnInfo;
import org.seasar.dbflute.dbmeta.info.RelationInfo;
import org.seasar.dbflute.util.DfReflectionUtil;
import org.seasar.dbflute.util.Srl;

public class ReferrerInfo
implements RelationInfo {
    protected final String _constraintName;
    protected final String _referrerPropertyName;
    protected final DBMeta _localDBMeta;
    protected final DBMeta _referrerDBMeta;
    protected final Map<ColumnInfo, ColumnInfo> _localReferrerColumnInfoMap;
    protected final Map<ColumnInfo, ColumnInfo> _referrerLocalColumnInfoMap;
    protected final boolean _oneToOne;
    protected final String _reversePropertyName;
    protected final Method _readMethod;
    protected final Method _writeMethod;

    public ReferrerInfo(String constraintName, String referrerPropertyName, DBMeta localDBMeta, DBMeta referrerDBMeta, Map<ColumnInfo, ColumnInfo> localReferrerColumnInfoMap, boolean oneToOne, String reversePropertyName) {
        this.assertObjectNotNull("constraintName", constraintName);
        this.assertObjectNotNull("referrerPropertyName", referrerPropertyName);
        this.assertObjectNotNull("localDBMeta", localDBMeta);
        this.assertObjectNotNull("referrerDBMeta", referrerDBMeta);
        this.assertObjectNotNull("localReferrerColumnInfoMap", localReferrerColumnInfoMap);
        this._constraintName = constraintName;
        this._referrerPropertyName = referrerPropertyName;
        this._localDBMeta = localDBMeta;
        this._referrerDBMeta = referrerDBMeta;
        this._localReferrerColumnInfoMap = Collections.unmodifiableMap(localReferrerColumnInfoMap);
        LinkedHashMap<ColumnInfo, ColumnInfo> referrerLocalColumnInfoMap = new LinkedHashMap<ColumnInfo, ColumnInfo>(4);
        for (Map.Entry<ColumnInfo, ColumnInfo> entry : localReferrerColumnInfoMap.entrySet()) {
            referrerLocalColumnInfoMap.put(entry.getValue(), entry.getKey());
        }
        this._referrerLocalColumnInfoMap = Collections.unmodifiableMap(referrerLocalColumnInfoMap);
        this._oneToOne = oneToOne;
        this._reversePropertyName = reversePropertyName;
        this._readMethod = this.findReadMethod();
        this._writeMethod = this.findWriteMethod();
    }

    public boolean containsLocalColumn(ColumnInfo localColumn) {
        return this.doContainsLocalColumn(localColumn.getColumnDbName());
    }

    protected boolean doContainsLocalColumn(String columnName) {
        for (ColumnInfo columnInfo : this._localReferrerColumnInfoMap.keySet()) {
            if (!columnInfo.getColumnDbName().equals(columnName)) continue;
            return true;
        }
        return false;
    }

    public boolean containsReferrerColumn(ColumnInfo referrerColumn) {
        return this.doContainsReferrerColumn(referrerColumn.getColumnDbName());
    }

    protected boolean doContainsReferrerColumn(String columnName) {
        for (ColumnInfo columnInfo : this._referrerLocalColumnInfoMap.keySet()) {
            if (!columnInfo.getColumnDbName().equals(columnName)) continue;
            return true;
        }
        return false;
    }

    public ColumnInfo findLocalByReferrer(String referrerColumnDbName) {
        ColumnInfo keyColumnInfo = this._referrerDBMeta.findColumnInfo(referrerColumnDbName);
        ColumnInfo resultColumnInfo = this._referrerLocalColumnInfoMap.get(keyColumnInfo);
        if (resultColumnInfo == null) {
            String msg = "Not found by referrerColumnDbName in referrerLocalColumnInfoMap:";
            msg = msg + " referrerColumnDbName=" + referrerColumnDbName;
            msg = msg + " referrerLocalColumnInfoMap=" + this._referrerLocalColumnInfoMap;
            throw new IllegalArgumentException(msg);
        }
        return resultColumnInfo;
    }

    public ColumnInfo findReferrerByLocal(String localColumnDbName) {
        ColumnInfo keyColumnInfo = this._localDBMeta.findColumnInfo(localColumnDbName);
        ColumnInfo resultColumnInfo = this._localReferrerColumnInfoMap.get(keyColumnInfo);
        if (resultColumnInfo == null) {
            String msg = "Not found by localColumnDbName in localReferrerColumnInfoMap:";
            msg = msg + " localColumnDbName=" + localColumnDbName;
            msg = msg + " localReferrerColumnInfoMap=" + this._localReferrerColumnInfoMap;
            throw new IllegalArgumentException(msg);
        }
        return resultColumnInfo;
    }

    public <PROPERTY extends List<? extends Entity>> PROPERTY read(Entity localEntity) {
        return (PROPERTY)((List)this.invokeMethod(this.getReadMethod(), localEntity, new Object[0]));
    }

    public Method getReadMethod() {
        return this._readMethod;
    }

    public void write(Entity localEntity, List<? extends Entity> referrerEntityList) {
        this.invokeMethod(this.getWriteMethod(), localEntity, new Object[]{referrerEntityList});
    }

    public Method getWriteMethod() {
        return this._writeMethod;
    }

    protected Method findReadMethod() {
        String methodName;
        Class<? extends Entity> localType = this._localDBMeta.getEntityType();
        Method method = this.findMethod(localType, methodName = this.buildAccessorName("get"), new Class[0]);
        if (method == null) {
            String msg = "Not found the method by the name: " + methodName;
            throw new IllegalStateException(msg);
        }
        return method;
    }

    protected Method findWriteMethod() {
        Class<? extends Entity> localType = this._localDBMeta.getEntityType();
        String methodName = this.buildAccessorName("set");
        Class<List> propertyType = List.class;
        Method method = this.findMethod(localType, methodName, new Class[]{propertyType});
        if (method == null) {
            String msg = "Not found the method by the name and type: " + methodName + ", " + propertyType;
            throw new IllegalStateException(msg);
        }
        return method;
    }

    protected String buildAccessorName(String prefix) {
        return prefix + this.initCap(this._referrerPropertyName);
    }

    protected Method findMethod(Class<?> clazz, String methodName, Class<?>[] argTypes) {
        return DfReflectionUtil.getAccessibleMethod(clazz, methodName, argTypes);
    }

    protected Object invokeMethod(Method method, Object target, Object[] args) {
        return DfReflectionUtil.invoke(method, target, args);
    }

    @Override
    public String getRelationPropertyName() {
        return this.getReferrerPropertyName();
    }

    @Override
    public DBMeta getTargetDBMeta() {
        return this.getReferrerDBMeta();
    }

    @Override
    public Map<ColumnInfo, ColumnInfo> getLocalTargetColumnInfoMap() {
        return this.getLocalReferrerColumnInfoMap();
    }

    @Override
    public boolean isReferrer() {
        return true;
    }

    protected String initCap(String name) {
        return Srl.initCap(name);
    }

    protected void assertObjectNotNull(String variableName, Object value) {
        if (variableName == null) {
            String msg = "The value should not be null: variableName=null value=" + value;
            throw new IllegalArgumentException(msg);
        }
        if (value == null) {
            String msg = "The value should not be null: variableName=" + variableName;
            throw new IllegalArgumentException(msg);
        }
    }

    public int hashCode() {
        return this._referrerPropertyName.hashCode() + this._localDBMeta.hashCode() + this._referrerDBMeta.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ReferrerInfo)) {
            return false;
        }
        ReferrerInfo target = (ReferrerInfo)obj;
        if (!this._referrerPropertyName.equals(target.getReferrerPropertyName())) {
            return false;
        }
        if (!this._localDBMeta.equals(target.getLocalDBMeta())) {
            return false;
        }
        return this._referrerDBMeta.equals(target.getReferrerDBMeta());
    }

    public String toString() {
        return this._localDBMeta.getTableDbName() + "." + this._referrerPropertyName + "<-" + this._referrerDBMeta.getTableDbName();
    }

    @Override
    public String getConstraintName() {
        return this._constraintName;
    }

    public String getReferrerPropertyName() {
        return this._referrerPropertyName;
    }

    @Override
    public DBMeta getLocalDBMeta() {
        return this._localDBMeta;
    }

    public DBMeta getReferrerDBMeta() {
        return this._referrerDBMeta;
    }

    public Map<ColumnInfo, ColumnInfo> getLocalReferrerColumnInfoMap() {
        return this._localReferrerColumnInfoMap;
    }

    public Map<ColumnInfo, ColumnInfo> getReferrerLocalColumnInfoMap() {
        return this._referrerLocalColumnInfoMap;
    }

    @Override
    public boolean isOneToOne() {
        return this._oneToOne;
    }

    @Override
    public RelationInfo getReverseRelation() {
        return this._reversePropertyName != null ? this._referrerDBMeta.findRelationInfo(this._reversePropertyName) : null;
    }
}

