/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.s2dao.extension;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.seasar.dbflute.Entity;
import org.seasar.dbflute.dbmeta.DBMeta;
import org.seasar.dbflute.dbmeta.info.ColumnInfo;
import org.seasar.dbflute.helper.beans.DfPropertyAccessor;
import org.seasar.dbflute.jdbc.ValueType;
import org.seasar.dbflute.resource.ResourceContext;
import org.seasar.dbflute.s2dao.extension.TnRowCreatorExtension;
import org.seasar.dbflute.s2dao.metadata.TnBeanMetaData;
import org.seasar.dbflute.s2dao.metadata.TnPropertyMapping;
import org.seasar.dbflute.s2dao.metadata.TnPropertyType;
import org.seasar.dbflute.s2dao.metadata.TnRelationPropertyType;
import org.seasar.dbflute.s2dao.rowcreator.TnRelationKey;
import org.seasar.dbflute.s2dao.rowcreator.TnRelationRowCache;
import org.seasar.dbflute.s2dao.rowcreator.TnRelationRowCreationResource;
import org.seasar.dbflute.s2dao.rowcreator.impl.TnRelationRowCreatorImpl;
import org.seasar.dbflute.util.DfReflectionUtil;

public class TnRelationRowCreatorExtension
extends TnRelationRowCreatorImpl {
    public static TnRelationRowCreatorExtension createRelationRowCreator() {
        return new TnRelationRowCreatorExtension();
    }

    @Override
    protected void setupRelationKeyValue(TnRelationRowCreationResource res) {
        TnRelationPropertyType rpt = res.getRelationPropertyType();
        TnBeanMetaData yourBmd = rpt.getYourBeanMetaData();
        DBMeta dbmeta = yourBmd.getDBMeta();
        if (!res.hasRowInstance()) {
            Object row = dbmeta != null ? dbmeta.newEntity() : this.newRelationRow(rpt);
            res.setRow(row);
        }
    }

    protected Object newRelationRow(TnRelationPropertyType rpt) {
        return DfReflectionUtil.newInstance(rpt.getPropertyDesc().getPropertyType());
    }

    @Override
    protected void setupRelationAllValue(TnRelationRowCreationResource res) throws SQLException {
        Map<String, TnPropertyMapping> propertyCacheElement = res.extractPropertyCacheElement();
        for (Map.Entry<String, TnPropertyMapping> entry : propertyCacheElement.entrySet()) {
            TnPropertyMapping pt = entry.getValue();
            res.setCurrentPropertyType(pt);
            if (!this.isValidRelationPerPropertyLoop(res)) {
                res.clearRowInstance();
                return;
            }
            this.setupRelationProperty(res);
        }
        if (!this.isValidRelationAfterPropertyLoop(res)) {
            res.clearRowInstance();
            return;
        }
        res.clearValidValueCount();
        if (res.isStopNextRelationMapping()) {
            return;
        }
        this.setupNextRelationRow(res);
    }

    protected void setupRelationProperty(TnRelationRowCreationResource res) throws SQLException {
        String columnName = res.buildRelationColumnName();
        this.registerRelationValue(res, columnName);
    }

    protected void registerRelationValue(TnRelationRowCreationResource res, String columnName) throws SQLException {
        TnPropertyMapping mapping = res.getCurrentPropertyMapping();
        Object value = null;
        if (res.containsRelationKeyColumn(columnName)) {
            value = res.extractRelationKeyValue(columnName);
        } else {
            ValueType valueType = mapping.getValueType();
            Map<String, Integer> selectIndexMap = res.getSelectIndexMap();
            value = selectIndexMap != null ? ResourceContext.getValue(res.getResultSet(), columnName, valueType, selectIndexMap) : valueType.getValue(res.getResultSet(), columnName);
        }
        if (value != null) {
            res.incrementValidValueCount();
            this.setValue(res, mapping, value);
        }
    }

    protected void setValue(TnRelationRowCreationResource res, TnPropertyMapping mapping, Object value) {
        ColumnInfo columnInfo = mapping.getEntityColumnInfo();
        if (columnInfo != null) {
            columnInfo.write((Entity)res.getRow(), value);
        } else {
            DfPropertyAccessor accessor = mapping.getPropertyAccessor();
            accessor.setValue(res.getRow(), value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setupNextRelationRow(TnRelationRowCreationResource res) throws SQLException {
        TnBeanMetaData nextBmd = res.getRelationBeanMetaData();
        Object row = res.getRow();
        res.prepareNextLevelMapping();
        try {
            List<TnRelationPropertyType> nextRptList = nextBmd.getRelationPropertyTypeList();
            for (TnRelationPropertyType nextRpt : nextRptList) {
                this.setupNextRelationRowElement(res, row, nextRpt);
            }
        }
        finally {
            res.setRow(row);
            res.closeNextLevelMapping();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setupNextRelationRowElement(TnRelationRowCreationResource res, Object row, TnRelationPropertyType nextRpt) throws SQLException {
        res.prepareNextRelationProperty(nextRpt);
        try {
            this.mappingNextRelation(res, row);
        }
        finally {
            res.closeNextRelationProperty();
        }
    }

    protected void mappingNextRelation(TnRelationRowCreationResource res, Object row) throws SQLException {
        String relationNoSuffix;
        if (res.isStopCurrentRelationMapping()) {
            return;
        }
        TnRelationKey relKey = res.prepareRelationKey();
        if (relKey == null) {
            return;
        }
        TnRelationPropertyType nextRpt = res.getRelationPropertyType();
        TnRelationRowCache relRowCache = res.getRelRowCache();
        Object relationRow = relRowCache.getRelationRow(relationNoSuffix = res.getRelationNoSuffix(), relKey);
        if (relationRow == null && (relationRow = this.createRelationRow(res)) != null) {
            this.adjustCreatedRow(relationRow, nextRpt);
            relRowCache.addRelationRow(relationNoSuffix, relKey, relationRow);
        }
        if (relationRow != null) {
            nextRpt.getPropertyDesc().setValue(row, relationRow);
        }
    }

    protected void adjustCreatedRow(Object relationRow, TnRelationPropertyType rpt) {
        TnRowCreatorExtension.adjustCreatedRow(relationRow, rpt.getYourBeanMetaData());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setupPropertyCache(TnRelationRowCreationResource res) throws SQLException {
        if (res.isStopCurrentRelationMapping()) {
            return;
        }
        TnBeanMetaData nextBmd = res.getRelationBeanMetaData();
        List<TnPropertyType> ptList = nextBmd.getPropertyTypeList();
        for (TnPropertyType pt : ptList) {
            res.setCurrentPropertyType(pt);
            this.setupPropertyCacheElement(res);
        }
        if (res.isStopNextRelationMapping()) {
            return;
        }
        res.prepareNextLevelMapping();
        try {
            this.setupNextPropertyCache(res, nextBmd);
        }
        finally {
            res.closeNextLevelMapping();
        }
    }

    protected void setupNextPropertyCache(TnRelationRowCreationResource res, TnBeanMetaData nextBmd) throws SQLException {
        List<TnRelationPropertyType> nextRptList = nextBmd.getRelationPropertyTypeList();
        for (TnRelationPropertyType nextRpt : nextRptList) {
            this.setupNextPropertyCacheElement(res, nextRpt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setupNextPropertyCacheElement(TnRelationRowCreationResource res, TnRelationPropertyType nextRpt) throws SQLException {
        res.prepareNextRelationProperty(nextRpt);
        try {
            this.setupPropertyCache(res);
        }
        finally {
            res.closeNextRelationProperty();
        }
    }

    @Override
    protected boolean isCreateDeadLink() {
        return false;
    }

    @Override
    protected int getLimitRelationNestLevel() {
        return 2;
    }
}

