/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.s2dao.sqlhandler;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.dbflute.CallbackContext;
import org.seasar.dbflute.QLog;
import org.seasar.dbflute.bhv.core.SqlFireHook;
import org.seasar.dbflute.bhv.core.SqlFireReadyInfo;
import org.seasar.dbflute.bhv.core.SqlFireResultInfo;
import org.seasar.dbflute.exception.handler.SQLExceptionHandler;
import org.seasar.dbflute.exception.handler.SQLExceptionResource;
import org.seasar.dbflute.jdbc.ExecutionTimeInfo;
import org.seasar.dbflute.jdbc.SqlLogHandler;
import org.seasar.dbflute.jdbc.SqlLogInfo;
import org.seasar.dbflute.jdbc.SqlResultHandler;
import org.seasar.dbflute.jdbc.StatementFactory;
import org.seasar.dbflute.jdbc.ValueType;
import org.seasar.dbflute.resource.DBFluteSystem;
import org.seasar.dbflute.resource.InternalMapContext;
import org.seasar.dbflute.resource.ManualThreadDataSourceHandler;
import org.seasar.dbflute.resource.ResourceContext;
import org.seasar.dbflute.s2dao.extension.TnSqlLogRegistry;
import org.seasar.dbflute.s2dao.valuetype.TnValueTypes;
import org.seasar.dbflute.twowaysql.DisplaySqlBuilder;

public abstract class TnAbstractBasicSqlHandler {
    private static final Log _log = LogFactory.getLog(TnAbstractBasicSqlHandler.class);
    protected final DataSource _dataSource;
    protected final StatementFactory _statementFactory;
    protected final String _sql;
    protected Object[] _exceptionMessageSqlArgs;

    public TnAbstractBasicSqlHandler(DataSource dataSource, StatementFactory statementFactory, String sql) {
        this.assertObjectNotNull("dataSource", dataSource);
        this.assertObjectNotNull("statementFactory", statementFactory);
        this.assertObjectNotNull("sql", sql);
        this._dataSource = dataSource;
        this._statementFactory = statementFactory;
        this._sql = sql;
    }

    protected void bindArgs(Connection conn, PreparedStatement ps, Object[] args, ValueType[] valueTypes) {
        if (args == null) {
            return;
        }
        Object current = null;
        try {
            for (int i = 0; i < args.length; ++i) {
                ValueType valueType = valueTypes[i];
                current = args[i];
                valueType.bindValue(conn, ps, i + 1, current);
            }
        }
        catch (SQLException e) {
            SQLExceptionResource resource = this.createSQLExceptionResource();
            resource.setNotice("Failed to bind the value.");
            if (current != null) {
                resource.addResource("Bound Value", current);
            }
            this.handleSQLException(e, resource);
        }
    }

    protected void bindArgs(Connection conn, PreparedStatement ps, Object[] args, Class<?>[] argTypes) {
        this.bindArgs(conn, ps, args, argTypes, 0);
    }

    protected void bindArgs(Connection conn, PreparedStatement ps, Object[] args, Class<?>[] argTypes, int beginIndex) {
        if (args == null) {
            return;
        }
        Object current = null;
        try {
            for (int i = beginIndex; i < args.length; ++i) {
                current = args[i];
                ValueType valueType = this.findValueType(argTypes[i], current);
                valueType.bindValue(conn, ps, i + 1, current);
            }
        }
        catch (SQLException e) {
            SQLExceptionResource resource = this.createSQLExceptionResource();
            resource.setNotice("Failed to bind the value.");
            if (current != null) {
                resource.addResource("Bound Value", current);
            }
            this.handleSQLException(e, resource);
        }
    }

    protected ValueType findValueType(Class<?> type, Object instance) {
        return TnValueTypes.findByTypeOrValue(type, instance);
    }

    protected Class<?>[] getArgTypes(Object[] args) {
        if (args == null) {
            return null;
        }
        Class[] argTypes = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            if (arg == null) continue;
            argTypes[i] = arg.getClass();
        }
        return argTypes;
    }

    protected void logSql(Object[] args, Class<?>[] argTypes) {
        boolean hasRegistry;
        boolean logEnabled = this.isLogEnabled();
        boolean hasSqlFireHook = this.hasSqlFireHook();
        boolean hasSqlLog = this.hasSqlLogHandler();
        boolean hasSqlResult = this.hasSqlResultHandler();
        Object sqlLogRegistry = this.getSqlLogRegistry();
        boolean bl = hasRegistry = sqlLogRegistry != null;
        if (logEnabled || hasSqlFireHook || hasSqlLog || hasSqlResult || hasRegistry) {
            if (this.isInternalDebugEnabled()) {
                String determination = logEnabled + ", " + hasSqlFireHook + ", " + hasSqlLog + ", " + hasSqlResult + ", " + hasRegistry;
                _log.debug((Object)("...Logging SQL by " + determination));
            }
            if (this.processBeforeLogging(args, argTypes, logEnabled, hasSqlFireHook, hasSqlLog, hasSqlResult, sqlLogRegistry)) {
                return;
            }
            this.doLogSql(args, argTypes, logEnabled, hasSqlFireHook, hasSqlLog, hasSqlResult, sqlLogRegistry);
        }
    }

    protected boolean processBeforeLogging(Object[] args, Class<?>[] argTypes, boolean logEnabled, boolean hasSqlFireHook, boolean hasSqlLog, boolean hasSqlResult, Object sqlLogRegistry) {
        return false;
    }

    protected void doLogSql(Object[] args, Class<?>[] argTypes, boolean logEnabled, boolean hasSqlFireHook, boolean hasSqlLog, boolean hasSqlResult, Object sqlLogRegistry) {
        String firstDisplaySql;
        boolean hasRegistry;
        boolean bl = hasRegistry = sqlLogRegistry != null;
        if (logEnabled || hasRegistry) {
            if (this.isInternalDebugEnabled()) {
                _log.debug((Object)("...Building DisplaySql by " + logEnabled + ", " + hasRegistry));
            }
            firstDisplaySql = this.buildDisplaySql(this._sql, args);
            if (logEnabled) {
                this.logDisplaySql(firstDisplaySql);
            }
            if (hasRegistry) {
                this.pushToSqlLogRegistry(args, argTypes, firstDisplaySql, sqlLogRegistry);
            }
        } else {
            firstDisplaySql = null;
        }
        if (hasSqlFireHook || hasSqlLog || hasSqlResult) {
            SqlLogInfo sqlLogInfo;
            if (this.isInternalDebugEnabled()) {
                _log.debug((Object)("...Handling SqlFireHook or SqlLog or SqlResult by " + hasSqlFireHook + ", " + hasSqlLog + ", " + hasSqlResult));
            }
            if ((sqlLogInfo = this.prepareSqlLogInfo(args, argTypes, firstDisplaySql)) != null) {
                if (hasSqlLog) {
                    this.getSqlLogHander().handle(sqlLogInfo);
                }
                if (hasSqlFireHook) {
                    this.saveHookSqlLogInfo(sqlLogInfo);
                }
                if (hasSqlResult) {
                    this.saveResultSqlLogInfo(sqlLogInfo);
                }
            }
        }
    }

    protected void logDisplaySql(String displaySql) {
        this.log((this.isContainsLineSeparatorInSql(displaySql) ? this.ln() : "") + displaySql);
    }

    protected boolean isContainsLineSeparatorInSql(String displaySql) {
        return displaySql != null ? displaySql.contains(this.ln()) : false;
    }

    protected String buildDisplaySql(String sql, Object[] args) {
        return this.createDisplaySqlBuilder().buildDisplaySql(sql, args);
    }

    protected String getBindVariableText(Object bindVariable) {
        return this.createDisplaySqlBuilder().getBindVariableText(bindVariable);
    }

    protected DisplaySqlBuilder createDisplaySqlBuilder() {
        String logDateFormat = ResourceContext.getLogDateFormat();
        String logTimestampFormat = ResourceContext.getLogTimestampFormat();
        return new DisplaySqlBuilder(logDateFormat, logTimestampFormat);
    }

    protected SqlFireHook getSqlFireHook() {
        if (!CallbackContext.isExistCallbackContextOnThread()) {
            return null;
        }
        return CallbackContext.getCallbackContextOnThread().getSqlFireHook();
    }

    protected boolean hasSqlFireHook() {
        return this.getSqlFireHook() != null;
    }

    protected void saveHookSqlLogInfo(SqlLogInfo sqlLogInfo) {
        InternalMapContext.setHookSqlLogInfo(sqlLogInfo);
    }

    protected SqlLogHandler getSqlLogHander() {
        if (!CallbackContext.isExistCallbackContextOnThread()) {
            return null;
        }
        return CallbackContext.getCallbackContextOnThread().getSqlLogHandler();
    }

    protected boolean hasSqlLogHandler() {
        return this.getSqlLogHander() != null;
    }

    protected SqlLogInfo prepareSqlLogInfo(Object[] args, Class<?>[] argTypes, String alreadyBuiltDisplaySql) {
        SqlLogInfo.SqlLogDisplaySqlBuilder sqlLogDisplaySqlBuilder = this.createSqlLogDisplaySqlBuilder(alreadyBuiltDisplaySql);
        return new SqlLogInfo(ResourceContext.behaviorCommand(), this._sql, args, argTypes, sqlLogDisplaySqlBuilder);
    }

    protected SqlLogInfo.SqlLogDisplaySqlBuilder createSqlLogDisplaySqlBuilder(final String alreadyBuiltDisplaySql) {
        if (alreadyBuiltDisplaySql != null) {
            return new SqlLogInfo.SqlLogDisplaySqlBuilder(){

                @Override
                public String build(String executedSql, Object[] bindArgs, Class<?>[] bindArgTypes) {
                    if (TnAbstractBasicSqlHandler.this.isInternalDebugEnabled()) {
                        _log.debug((Object)"...Returning DisplaySql, already built");
                    }
                    return alreadyBuiltDisplaySql;
                }
            };
        }
        return new SqlLogInfo.SqlLogDisplaySqlBuilder(){

            @Override
            public String build(String executedSql, Object[] bindArgs, Class<?>[] bindArgTypes) {
                if (TnAbstractBasicSqlHandler.this.isInternalDebugEnabled()) {
                    _log.debug((Object)"...Building DisplaySql lazily");
                }
                return TnAbstractBasicSqlHandler.this.buildDisplaySql(executedSql, bindArgs);
            }
        };
    }

    protected SqlResultHandler getSqlResultHander() {
        if (!CallbackContext.isExistCallbackContextOnThread()) {
            return null;
        }
        return CallbackContext.getCallbackContextOnThread().getSqlResultHandler();
    }

    protected boolean hasSqlResultHandler() {
        return this.getSqlResultHander() != null;
    }

    protected void saveResultSqlLogInfo(SqlLogInfo sqlLogInfo) {
        InternalMapContext.setResultSqlLogInfo(sqlLogInfo);
    }

    protected Object getSqlLogRegistry() {
        return TnSqlLogRegistry.findContainerSqlLogRegistry();
    }

    protected void pushToSqlLogRegistry(Object[] args, Class<?>[] argTypes, String firstDisplaySql, Object sqlLogRegistry) {
        TnSqlLogRegistry.push(this._sql, firstDisplaySql, args, argTypes, sqlLogRegistry);
    }

    protected void handleSQLException(SQLException e, SQLExceptionResource resource) {
        resource.setExecutedSql(this._sql);
        resource.setDisplaySql(this.buildExceptionMessageSql());
        this.createSQLExceptionHandler().handleSQLException(e, resource);
    }

    protected SQLExceptionHandler createSQLExceptionHandler() {
        return ResourceContext.createSQLExceptionHandler();
    }

    protected SQLExceptionResource createSQLExceptionResource() {
        return new SQLExceptionResource();
    }

    protected String buildExceptionMessageSql() {
        String displaySql;
        block3: {
            displaySql = null;
            if (this._sql != null && this._exceptionMessageSqlArgs != null) {
                try {
                    displaySql = this.buildDisplaySql(this._sql, this._exceptionMessageSqlArgs);
                }
                catch (RuntimeException continued) {
                    if (!_log.isDebugEnabled()) break block3;
                    _log.debug((Object)("*Failed to build SQL for an exception message: " + continued.getMessage()));
                }
            }
        }
        return displaySql;
    }

    protected Connection getConnection() {
        try {
            ManualThreadDataSourceHandler handler = this.getManualThreadDataSourceHandler();
            if (handler != null) {
                return handler.getConnection(this._dataSource);
            }
            return this._dataSource.getConnection();
        }
        catch (SQLException e) {
            SQLExceptionResource resource = this.createSQLExceptionResource();
            resource.setNotice("Failed to get database connection.");
            this.handleSQLException(e, resource);
            return null;
        }
    }

    protected ManualThreadDataSourceHandler getManualThreadDataSourceHandler() {
        return ManualThreadDataSourceHandler.getDataSourceHandler();
    }

    protected PreparedStatement prepareStatement(Connection conn) {
        if (this._sql == null) {
            throw new IllegalStateException("The SQL should not be null.");
        }
        return this._statementFactory.createPreparedStatement(conn, this._sql);
    }

    protected CallableStatement prepareCall(Connection conn) {
        if (this._sql == null) {
            throw new IllegalStateException("The SQL should not be null.");
        }
        return this._statementFactory.createCallableStatement(conn, this._sql);
    }

    protected ResultSet executeQuery(PreparedStatement ps) throws SQLException {
        boolean saveMillis = this.isSaveMillis();
        if (saveMillis) {
            this.saveBeforeSqlTimeMillis();
        }
        this.hookSqlFireBefore();
        ResultSet rs = null;
        SQLException nativeCause = null;
        try {
            rs = ps.executeQuery();
            if (saveMillis) {
                this.saveAfterSqlTimeMillis();
            }
            ResultSet resultSet = rs;
            return resultSet;
        }
        catch (SQLException e) {
            nativeCause = e;
            throw e;
        }
        finally {
            this.hookSqlFireFinally(rs, nativeCause);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int executeUpdate(PreparedStatement ps) {
        boolean saveMillis = this.isSaveMillis();
        if (saveMillis) {
            this.saveBeforeSqlTimeMillis();
        }
        this.hookSqlFireBefore();
        Integer updated = null;
        SQLException nativeCause = null;
        try {
            updated = ps.executeUpdate();
            if (saveMillis) {
                this.saveAfterSqlTimeMillis();
            }
            int n = updated;
            return n;
        }
        catch (SQLException e) {
            nativeCause = e;
            SQLExceptionResource resource = this.createSQLExceptionResource();
            String processTitle = this.getUpdateSQLFailureProcessTitle();
            resource.setNotice("Failed to execute the SQL for " + processTitle + ".");
            resource.enableUniqueConstraintHandling();
            this.handleSQLException(e, resource);
            int n = -1;
            return n;
        }
        finally {
            this.hookSqlFireFinally(updated, nativeCause);
        }
    }

    protected String getUpdateSQLFailureProcessTitle() {
        return "update (non-select)";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int[] executeBatch(PreparedStatement ps, List<?> list) {
        boolean saveMillis = this.isSaveMillis();
        if (saveMillis) {
            this.saveBeforeSqlTimeMillis();
        }
        this.hookSqlFireBefore();
        int[] batchResult = null;
        SQLException nativeCause = null;
        try {
            batchResult = ps.executeBatch();
            if (saveMillis) {
                this.saveAfterSqlTimeMillis();
            }
            int[] nArray = batchResult;
            return nArray;
        }
        catch (SQLException e) {
            nativeCause = e;
            SQLExceptionResource resource = this.createSQLExceptionResource();
            String processTitle = this.getBatchUpdateSQLFailureProcessTitle();
            resource.setNotice("Failed to execute the SQL for " + processTitle + ".");
            resource.enableUniqueConstraintHandling();
            resource.enableDisplaySqlPartHandling();
            this.handleSQLException(e, resource);
            int[] nArray = null;
            return nArray;
        }
        finally {
            this.hookSqlFireFinally(batchResult, nativeCause);
        }
    }

    protected String getBatchUpdateSQLFailureProcessTitle() {
        return "batch update (non-select)";
    }

    protected void addBatch(PreparedStatement ps) {
        try {
            ps.addBatch();
        }
        catch (SQLException e) {
            SQLExceptionResource resource = this.createSQLExceptionResource();
            resource.setNotice("Failed to add the batch statement.");
            resource.enableUniqueConstraintHandling();
            this.handleSQLException(e, resource);
        }
    }

    protected boolean executeProcedure(CallableStatement cs) throws SQLException {
        boolean saveMillis = this.isSaveMillis();
        if (saveMillis) {
            this.saveBeforeSqlTimeMillis();
        }
        this.hookSqlFireBefore();
        Boolean executed = null;
        SQLException nativeCause = null;
        try {
            executed = cs.execute();
            if (saveMillis) {
                this.saveAfterSqlTimeMillis();
            }
            boolean bl = executed;
            return bl;
        }
        catch (SQLException e) {
            nativeCause = e;
            throw e;
        }
        finally {
            this.hookSqlFireFinally(executed, nativeCause);
        }
    }

    protected boolean isSaveMillis() {
        return this.hasSqlFireHook() || this.hasSqlResultHandler();
    }

    protected void saveBeforeSqlTimeMillis() {
        InternalMapContext.setSqlBeforeTimeMillis(this.systemTime());
    }

    protected void saveAfterSqlTimeMillis() {
        InternalMapContext.setSqlAfterTimeMillis(this.systemTime());
    }

    protected void hookSqlFireBefore() {
        if (!this.hasSqlFireHook()) {
            return;
        }
        SqlLogInfo sqlLogInfo = InternalMapContext.getHookSqlLogInfo();
        SqlFireReadyInfo fireReadyInfo = new SqlFireReadyInfo(sqlLogInfo);
        this.getSqlFireHook().hookBefore(ResourceContext.behaviorCommand(), fireReadyInfo);
    }

    protected void hookSqlFireFinally(Object nativeResult, SQLException nativeCause) {
        if (!this.hasSqlFireHook()) {
            return;
        }
        SqlLogInfo sqlLogInfo = InternalMapContext.getHookSqlLogInfo();
        Long sqlBefore = InternalMapContext.getSqlBeforeTimeMillis();
        Long sqlAfter = InternalMapContext.getSqlAfterTimeMillis();
        ExecutionTimeInfo timeInfo = new ExecutionTimeInfo(null, null, sqlBefore, sqlAfter);
        SqlFireResultInfo fireResultInfo = new SqlFireResultInfo(nativeResult, sqlLogInfo, timeInfo, nativeCause);
        this.getSqlFireHook().hookFinally(ResourceContext.behaviorCommand(), fireResultInfo);
    }

    protected void setFetchSize(Statement st, int fetchSize) {
        if (st == null) {
            return;
        }
        try {
            st.setFetchSize(fetchSize);
        }
        catch (SQLException e) {
            SQLExceptionResource resource = this.createSQLExceptionResource();
            resource.setNotice("Failed to set fetch size.");
            resource.addResource("Fetch Size", fetchSize);
            this.handleSQLException(e, resource);
        }
    }

    protected void setMaxRows(Statement st, int maxRows) {
        if (st == null) {
            return;
        }
        try {
            st.setMaxRows(maxRows);
        }
        catch (SQLException e) {
            SQLExceptionResource resource = this.createSQLExceptionResource();
            resource.setNotice("Failed to set max rows.");
            resource.addResource("Max Rows", maxRows);
            this.handleSQLException(e, resource);
        }
    }

    protected void close(Statement st) {
        if (st == null) {
            return;
        }
        try {
            st.close();
        }
        catch (SQLException e) {
            SQLExceptionResource resource = this.createSQLExceptionResource();
            resource.setNotice("Failed to close the statement.");
            this.handleSQLException(e, resource);
        }
    }

    protected void close(ResultSet resultSet) {
        if (resultSet == null) {
            return;
        }
        try {
            resultSet.close();
        }
        catch (SQLException e) {
            SQLExceptionResource resource = this.createSQLExceptionResource();
            resource.setNotice("Failed to close the result set.");
            this.handleSQLException(e, resource);
        }
    }

    protected void close(Connection conn) {
        if (conn == null) {
            return;
        }
        try {
            conn.close();
        }
        catch (SQLException e) {
            SQLExceptionResource resource = this.createSQLExceptionResource();
            resource.setNotice("Failed to close the database connection.");
            this.handleSQLException(e, resource);
        }
    }

    protected boolean isLogEnabled() {
        return QLog.isLogEnabled();
    }

    protected void log(String msg) {
        QLog.log(msg);
    }

    protected boolean isInternalDebugEnabled() {
        return ResourceContext.isInternalDebug() && _log.isDebugEnabled();
    }

    protected void assertObjectNotNull(String variableName, Object value) {
        if (variableName == null) {
            String msg = "The value should not be null: variableName=null value=" + value;
            throw new IllegalArgumentException(msg);
        }
        if (value == null) {
            String msg = "The value should not be null: variableName=" + variableName;
            throw new IllegalArgumentException(msg);
        }
    }

    protected String ln() {
        return DBFluteSystem.getBasicLn();
    }

    protected long systemTime() {
        return DBFluteSystem.currentTimeMillis();
    }

    public void setExceptionMessageSqlArgs(Object[] exceptionMessageSqlArgs) {
        this._exceptionMessageSqlArgs = exceptionMessageSqlArgs;
    }
}

