/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.cn.smart.hhmm;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.lucene.analysis.cn.smart.AnalyzerProfile;
import org.apache.lucene.analysis.cn.smart.hhmm.AbstractDictionary;

class BigramDictionary
extends AbstractDictionary {
    public static final char WORD_SEGMENT_CHAR = '@';
    private static BigramDictionary singleInstance;
    public static final int PRIME_BIGRAM_LENGTH = 402137;
    private long[] bigramHashTable;
    private int[] frequencyTable;
    private int max = 0;
    private int repeat = 0;

    private BigramDictionary() {
    }

    public static synchronized BigramDictionary getInstance() {
        if (singleInstance == null) {
            singleInstance = new BigramDictionary();
            try {
                singleInstance.load();
            }
            catch (IOException e) {
                String dictRoot = AnalyzerProfile.ANALYSIS_DATA_DIR;
                singleInstance.load(dictRoot);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return singleInstance;
    }

    private boolean loadFromObj(File serialObj) {
        try {
            this.loadFromInputStream(new FileInputStream(serialObj));
            return true;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void loadFromInputStream(InputStream serialObjectInputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream input = new ObjectInputStream(serialObjectInputStream);
        this.bigramHashTable = (long[])input.readObject();
        this.frequencyTable = (int[])input.readObject();
        input.close();
    }

    private void saveToObj(File serialObj) {
        try {
            ObjectOutputStream output = new ObjectOutputStream(new FileOutputStream(serialObj));
            output.writeObject(this.bigramHashTable);
            output.writeObject(this.frequencyTable);
            output.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void load() throws IOException, ClassNotFoundException {
        InputStream input = this.getClass().getResourceAsStream("bigramdict.mem");
        this.loadFromInputStream(input);
    }

    private void load(String dictRoot) {
        String bigramDictPath = dictRoot + "/bigramdict.dct";
        File serialObj = new File(dictRoot + "/bigramdict.mem");
        if (!serialObj.exists() || !this.loadFromObj(serialObj)) {
            try {
                this.bigramHashTable = new long[402137];
                this.frequencyTable = new int[402137];
                for (int i = 0; i < 402137; ++i) {
                    this.bigramHashTable[i] = 0L;
                    this.frequencyTable[i] = 0;
                }
                this.loadFromFile(bigramDictPath);
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage());
            }
            this.saveToObj(serialObj);
        }
    }

    public void loadFromFile(String dctFilePath) throws IOException {
        int total = 0;
        int[] buffer = new int[3];
        byte[] intBuffer = new byte[4];
        RandomAccessFile dctFile = new RandomAccessFile(dctFilePath, "r");
        for (int i = 1410; i < 8178; ++i) {
            String currentStr = this.getCCByGB2312Id(i);
            dctFile.read(intBuffer);
            int cnt = ByteBuffer.wrap(intBuffer).order(ByteOrder.LITTLE_ENDIAN).getInt();
            if (cnt <= 0) continue;
            total += cnt;
            for (int j = 0; j < cnt; ++j) {
                char[] carray;
                long hashId;
                int index;
                dctFile.read(intBuffer);
                buffer[0] = ByteBuffer.wrap(intBuffer).order(ByteOrder.LITTLE_ENDIAN).getInt();
                dctFile.read(intBuffer);
                buffer[1] = ByteBuffer.wrap(intBuffer).order(ByteOrder.LITTLE_ENDIAN).getInt();
                dctFile.read(intBuffer);
                int length = buffer[1];
                if (length <= 0) continue;
                byte[] lchBuffer = new byte[length];
                dctFile.read(lchBuffer);
                String tmpword = new String(lchBuffer, "GB2312");
                if (i != 5165) {
                    tmpword = currentStr + tmpword;
                }
                if ((index = this.getAvaliableIndex(hashId = this.hash1(carray = tmpword.toCharArray()), carray)) == -1) continue;
                if (this.bigramHashTable[index] == 0L) {
                    this.bigramHashTable[index] = hashId;
                }
                int n = index;
                this.frequencyTable[n] = this.frequencyTable[n] + buffer[0];
            }
        }
        dctFile.close();
    }

    private int getAvaliableIndex(long hashId, char[] carray) {
        int i;
        int hash1 = (int)(hashId % 402137L);
        int hash2 = this.hash2(carray) % 402137;
        if (hash1 < 0) {
            hash1 = 402137 + hash1;
        }
        if (hash2 < 0) {
            hash2 = 402137 + hash2;
        }
        int index = hash1;
        for (i = 1; this.bigramHashTable[index] != 0L && this.bigramHashTable[index] != hashId && i < 402137; ++i) {
            index = (hash1 + i * hash2) % 402137;
        }
        if (i < 402137 && (this.bigramHashTable[index] == 0L || this.bigramHashTable[index] == hashId)) {
            return index;
        }
        return -1;
    }

    private int getBigramItemIndex(char[] carray) {
        long hashId = this.hash1(carray);
        int hash1 = (int)(hashId % 402137L);
        int hash2 = this.hash2(carray) % 402137;
        if (hash1 < 0) {
            hash1 = 402137 + hash1;
        }
        if (hash2 < 0) {
            hash2 = 402137 + hash2;
        }
        int index = hash1;
        int i = 1;
        ++this.repeat;
        while (this.bigramHashTable[index] != 0L && this.bigramHashTable[index] != hashId && i < 402137) {
            index = (hash1 + i * hash2) % 402137;
            ++this.repeat;
            if (++i <= this.max) continue;
            this.max = i;
        }
        if (i < 402137 && this.bigramHashTable[index] == hashId) {
            return index;
        }
        return -1;
    }

    public int getFrequency(char[] carray) {
        int index = this.getBigramItemIndex(carray);
        if (index != -1) {
            return this.frequencyTable[index];
        }
        return 0;
    }
}

