/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.io.IOUtils;
import org.apache.solr.util.BaseTestHarness;
import org.apache.solr.util.RESTfulServerProvider;

public class RestTestHarness
extends BaseTestHarness {
    private RESTfulServerProvider serverProvider;

    public RestTestHarness(RESTfulServerProvider serverProvider) {
        this.serverProvider = serverProvider;
    }

    public String getBaseURL() {
        return this.serverProvider.getBaseURL();
    }

    public String validateQuery(String request, String ... tests) throws Exception {
        String res = this.query(request);
        return RestTestHarness.validateXPath(res, tests);
    }

    public String validatePut(String request, String content, String ... tests) throws Exception {
        String res = this.put(request, content);
        return RestTestHarness.validateXPath(res, tests);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String query(String request) throws Exception {
        StringWriter strWriter;
        URL url = new URL(this.getBaseURL() + request);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        InputStream inputStream = null;
        try {
            try {
                inputStream = connection.getInputStream();
            }
            catch (IOException e) {
                inputStream = connection.getErrorStream();
            }
            strWriter = new StringWriter();
            IOUtils.copy((Reader)new InputStreamReader(inputStream, "UTF-8"), (Writer)strWriter);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        return strWriter.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String put(String request, String content) throws IOException {
        StringWriter stringWriter;
        URL url = new URL(this.getBaseURL() + request);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("PUT");
        OutputStreamWriter out = new OutputStreamWriter(connection.getOutputStream(), "UTF-8");
        out.write(content);
        out.close();
        InputStream inputStream = null;
        try {
            try {
                inputStream = connection.getInputStream();
            }
            catch (IOException e) {
                inputStream = connection.getErrorStream();
            }
            stringWriter = new StringWriter();
            IOUtils.copy((Reader)new InputStreamReader(inputStream, "UTF-8"), (Writer)stringWriter);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        return stringWriter.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String post(String request, String content) throws IOException {
        StringWriter stringWriter;
        URL url = new URL(this.getBaseURL() + request);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/json; charset=utf-8");
        OutputStreamWriter out = new OutputStreamWriter(connection.getOutputStream(), "UTF-8");
        out.write(content);
        out.close();
        InputStream inputStream = null;
        try {
            try {
                inputStream = connection.getInputStream();
            }
            catch (IOException e) {
                inputStream = connection.getErrorStream();
            }
            stringWriter = new StringWriter();
            IOUtils.copy((Reader)new InputStreamReader(inputStream, "UTF-8"), (Writer)stringWriter);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        return stringWriter.toString();
    }

    public String checkResponseStatus(String xml, String code) throws Exception {
        try {
            String response = this.query(xml);
            String valid = RestTestHarness.validateXPath(response, "//int[@name='status']=" + code);
            return null == valid ? null : response;
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException("?!? static xpath has bug?", e);
        }
    }

    @Override
    public void reload() throws Exception {
        String xml = this.checkResponseStatus("/admin/cores?action=RELOAD", "0");
        if (null != xml) {
            throw new RuntimeException("RELOAD failed:\n" + xml);
        }
    }

    @Override
    public String update(String xml) {
        try {
            return this.query("/update?stream.body=" + URLEncoder.encode(xml, "UTF-8"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

