/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.compress.SnappyCodec;
import org.apache.hadoop.io.compress.zlib.ZlibFactory;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.util.NativeCodeLoader;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class NativeLibraryChecker {
    public static void main(String[] args) {
        String usage = "NativeLibraryChecker [-a|-h]\n  -a  use -a to check all libraries are available\n      by default just check hadoop library is available\n      exit with error code if check failed\n  -h  print this message\n";
        if (args.length > 1 || args.length == 1 && !args[0].equals("-a") && !args[0].equals("-h")) {
            System.err.println(usage);
            ExitUtil.terminate(1);
        }
        boolean checkAll = false;
        if (args.length == 1) {
            if (args[0].equals("-h")) {
                System.out.println(usage);
                return;
            }
            checkAll = true;
        }
        boolean nativeHadoopLoaded = NativeCodeLoader.isNativeCodeLoaded();
        boolean zlibLoaded = false;
        boolean snappyLoaded = false;
        boolean lz4Loaded = nativeHadoopLoaded;
        if (nativeHadoopLoaded) {
            zlibLoaded = ZlibFactory.isNativeZlibLoaded(new Configuration());
            snappyLoaded = NativeCodeLoader.buildSupportsSnappy() && SnappyCodec.isNativeCodeLoaded();
        }
        System.out.println("Native library checking:");
        System.out.printf("hadoop: %b\n", nativeHadoopLoaded);
        System.out.printf("zlib:   %b\n", zlibLoaded);
        System.out.printf("snappy: %b\n", snappyLoaded);
        System.out.printf("lz4:    %b\n", lz4Loaded);
        if (!(nativeHadoopLoaded && (!checkAll || zlibLoaded && snappyLoaded && lz4Loaded))) {
            ExitUtil.terminate(1);
        }
    }
}

