/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Preconditions;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableList;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Iterators;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ObjectArrays;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.UnmodifiableIterator;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.UnmodifiableListIterator;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;

final class EmptyImmutableList
extends ImmutableList {
    static final EmptyImmutableList INSTANCE = new EmptyImmutableList();

    private EmptyImmutableList() {
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    @Override
    public boolean contains(@Nullable Object object) {
        return false;
    }

    @Override
    public boolean containsAll(Collection collection) {
        return collection.isEmpty();
    }

    @Override
    public UnmodifiableIterator iterator() {
        return this.listIterator();
    }

    @Override
    public Object[] toArray() {
        return ObjectArrays.EMPTY_ARRAY;
    }

    @Override
    public Object[] toArray(Object[] objectArray) {
        if (objectArray.length > 0) {
            objectArray[0] = null;
        }
        return objectArray;
    }

    public Object get(int n) {
        Preconditions.checkElementIndex(n, 0);
        throw new AssertionError((Object)"unreachable");
    }

    @Override
    public int indexOf(@Nullable Object object) {
        return -1;
    }

    @Override
    public int lastIndexOf(@Nullable Object object) {
        return -1;
    }

    @Override
    public ImmutableList subList(int n, int n2) {
        Preconditions.checkPositionIndexes(n, n2, 0);
        return this;
    }

    @Override
    public UnmodifiableListIterator listIterator() {
        return Iterators.EMPTY_LIST_ITERATOR;
    }

    @Override
    public UnmodifiableListIterator listIterator(int n) {
        Preconditions.checkPositionIndex(n, 0);
        return Iterators.EMPTY_LIST_ITERATOR;
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (object instanceof List) {
            List list = (List)object;
            return list.isEmpty();
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 1;
    }

    @Override
    public String toString() {
        return "[]";
    }
}

