/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Objects;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Preconditions;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.BiMap;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.HashBiMap$BiEntry;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.HashBiMap$EntrySet;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.HashBiMap$Inverse;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.HashBiMap$KeySet;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Hashing;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Set;
import javax.annotation.Nullable;

public final class HashBiMap
extends AbstractMap
implements BiMap,
Serializable {
    private transient HashBiMap$BiEntry[] hashTableKToV;
    private transient HashBiMap$BiEntry[] hashTableVToK;
    private transient int size;
    private transient int mask;
    private transient int modCount;
    private transient BiMap inverse;

    public static HashBiMap create() {
        return HashBiMap.create(16);
    }

    public static HashBiMap create(int n) {
        return new HashBiMap(n);
    }

    private HashBiMap(int n) {
        this.init(n);
    }

    private void init(int n) {
        Preconditions.checkArgument(n >= 0, "expectedSize must be >= 0 but was %s", n);
        int n2 = Hashing.closedTableSize(n, 1.0);
        this.hashTableKToV = this.createTable(n2);
        this.hashTableVToK = this.createTable(n2);
        this.mask = n2 - 1;
        this.modCount = 0;
        this.size = 0;
    }

    private void delete(HashBiMap$BiEntry hashBiMap$BiEntry) {
        int n = hashBiMap$BiEntry.keyHash & this.mask;
        HashBiMap$BiEntry hashBiMap$BiEntry2 = null;
        HashBiMap$BiEntry hashBiMap$BiEntry3 = this.hashTableKToV[n];
        while (true) {
            if (hashBiMap$BiEntry3 == hashBiMap$BiEntry) {
                if (hashBiMap$BiEntry2 == null) {
                    this.hashTableKToV[n] = hashBiMap$BiEntry.nextInKToVBucket;
                    break;
                }
                hashBiMap$BiEntry2.nextInKToVBucket = hashBiMap$BiEntry.nextInKToVBucket;
                break;
            }
            hashBiMap$BiEntry2 = hashBiMap$BiEntry3;
            hashBiMap$BiEntry3 = hashBiMap$BiEntry3.nextInKToVBucket;
        }
        int n2 = hashBiMap$BiEntry.valueHash & this.mask;
        hashBiMap$BiEntry2 = null;
        HashBiMap$BiEntry hashBiMap$BiEntry4 = this.hashTableVToK[n2];
        while (true) {
            if (hashBiMap$BiEntry4 == hashBiMap$BiEntry) {
                if (hashBiMap$BiEntry2 == null) {
                    this.hashTableVToK[n2] = hashBiMap$BiEntry.nextInVToKBucket;
                    break;
                }
                hashBiMap$BiEntry2.nextInVToKBucket = hashBiMap$BiEntry.nextInVToKBucket;
                break;
            }
            hashBiMap$BiEntry2 = hashBiMap$BiEntry4;
            hashBiMap$BiEntry4 = hashBiMap$BiEntry4.nextInVToKBucket;
        }
        --this.size;
        ++this.modCount;
    }

    private void insert(HashBiMap$BiEntry hashBiMap$BiEntry) {
        int n = hashBiMap$BiEntry.keyHash & this.mask;
        hashBiMap$BiEntry.nextInKToVBucket = this.hashTableKToV[n];
        this.hashTableKToV[n] = hashBiMap$BiEntry;
        int n2 = hashBiMap$BiEntry.valueHash & this.mask;
        hashBiMap$BiEntry.nextInVToKBucket = this.hashTableVToK[n2];
        this.hashTableVToK[n2] = hashBiMap$BiEntry;
        ++this.size;
        ++this.modCount;
    }

    private static int hash(@Nullable Object object) {
        return Hashing.smear(object == null ? 0 : object.hashCode());
    }

    private HashBiMap$BiEntry seekByKey(@Nullable Object object, int n) {
        HashBiMap$BiEntry hashBiMap$BiEntry = this.hashTableKToV[n & this.mask];
        while (hashBiMap$BiEntry != null) {
            if (n == hashBiMap$BiEntry.keyHash && Objects.equal(object, hashBiMap$BiEntry.key)) {
                return hashBiMap$BiEntry;
            }
            hashBiMap$BiEntry = hashBiMap$BiEntry.nextInKToVBucket;
        }
        return null;
    }

    private HashBiMap$BiEntry seekByValue(@Nullable Object object, int n) {
        HashBiMap$BiEntry hashBiMap$BiEntry = this.hashTableVToK[n & this.mask];
        while (hashBiMap$BiEntry != null) {
            if (n == hashBiMap$BiEntry.valueHash && Objects.equal(object, hashBiMap$BiEntry.value)) {
                return hashBiMap$BiEntry;
            }
            hashBiMap$BiEntry = hashBiMap$BiEntry.nextInVToKBucket;
        }
        return null;
    }

    @Override
    public boolean containsKey(@Nullable Object object) {
        return this.seekByKey(object, HashBiMap.hash(object)) != null;
    }

    @Override
    public boolean containsValue(@Nullable Object object) {
        return this.seekByValue(object, HashBiMap.hash(object)) != null;
    }

    @Nullable
    public Object get(@Nullable Object object) {
        HashBiMap$BiEntry hashBiMap$BiEntry = this.seekByKey(object, HashBiMap.hash(object));
        return hashBiMap$BiEntry == null ? null : hashBiMap$BiEntry.value;
    }

    @Override
    public Object put(@Nullable Object object, @Nullable Object object2) {
        return this.put(object, object2, false);
    }

    private Object put(@Nullable Object object, @Nullable Object object2, boolean bl) {
        int n = HashBiMap.hash(object);
        int n2 = HashBiMap.hash(object2);
        HashBiMap$BiEntry hashBiMap$BiEntry = this.seekByKey(object, n);
        if (hashBiMap$BiEntry != null && n2 == hashBiMap$BiEntry.valueHash && Objects.equal(object2, hashBiMap$BiEntry.value)) {
            return object2;
        }
        HashBiMap$BiEntry hashBiMap$BiEntry2 = this.seekByValue(object2, n2);
        if (hashBiMap$BiEntry2 != null) {
            if (bl) {
                this.delete(hashBiMap$BiEntry2);
            } else {
                throw new IllegalArgumentException("value already present: " + object2);
            }
        }
        if (hashBiMap$BiEntry != null) {
            this.delete(hashBiMap$BiEntry);
        }
        HashBiMap$BiEntry hashBiMap$BiEntry3 = new HashBiMap$BiEntry(object, n, object2, n2);
        this.insert(hashBiMap$BiEntry3);
        this.rehashIfNecessary();
        return hashBiMap$BiEntry == null ? null : hashBiMap$BiEntry.value;
    }

    @Nullable
    private Object putInverse(@Nullable Object object, @Nullable Object object2, boolean bl) {
        int n = HashBiMap.hash(object);
        int n2 = HashBiMap.hash(object2);
        HashBiMap$BiEntry hashBiMap$BiEntry = this.seekByValue(object, n);
        if (hashBiMap$BiEntry != null && n2 == hashBiMap$BiEntry.keyHash && Objects.equal(object2, hashBiMap$BiEntry.key)) {
            return object2;
        }
        HashBiMap$BiEntry hashBiMap$BiEntry2 = this.seekByKey(object2, n2);
        if (hashBiMap$BiEntry2 != null) {
            if (bl) {
                this.delete(hashBiMap$BiEntry2);
            } else {
                throw new IllegalArgumentException("value already present: " + object2);
            }
        }
        if (hashBiMap$BiEntry != null) {
            this.delete(hashBiMap$BiEntry);
        }
        HashBiMap$BiEntry hashBiMap$BiEntry3 = new HashBiMap$BiEntry(object2, n2, object, n);
        this.insert(hashBiMap$BiEntry3);
        this.rehashIfNecessary();
        return hashBiMap$BiEntry == null ? null : hashBiMap$BiEntry.key;
    }

    private void rehashIfNecessary() {
        HashBiMap$BiEntry[] hashBiMap$BiEntryArray = this.hashTableKToV;
        if (Hashing.needsResizing(this.size, hashBiMap$BiEntryArray.length, 1.0)) {
            int n = hashBiMap$BiEntryArray.length * 2;
            this.hashTableKToV = this.createTable(n);
            this.hashTableVToK = this.createTable(n);
            this.mask = n - 1;
            this.size = 0;
            for (int i = 0; i < hashBiMap$BiEntryArray.length; ++i) {
                HashBiMap$BiEntry hashBiMap$BiEntry = hashBiMap$BiEntryArray[i];
                while (hashBiMap$BiEntry != null) {
                    HashBiMap$BiEntry hashBiMap$BiEntry2 = hashBiMap$BiEntry.nextInKToVBucket;
                    this.insert(hashBiMap$BiEntry);
                    hashBiMap$BiEntry = hashBiMap$BiEntry2;
                }
            }
            ++this.modCount;
        }
    }

    private HashBiMap$BiEntry[] createTable(int n) {
        return new HashBiMap$BiEntry[n];
    }

    public Object remove(@Nullable Object object) {
        HashBiMap$BiEntry hashBiMap$BiEntry = this.seekByKey(object, HashBiMap.hash(object));
        if (hashBiMap$BiEntry == null) {
            return null;
        }
        this.delete(hashBiMap$BiEntry);
        return hashBiMap$BiEntry.value;
    }

    @Override
    public void clear() {
        this.size = 0;
        Arrays.fill(this.hashTableKToV, null);
        Arrays.fill(this.hashTableVToK, null);
        ++this.modCount;
    }

    @Override
    public int size() {
        return this.size;
    }

    public Set keySet() {
        return new HashBiMap$KeySet(this, null);
    }

    public Set values() {
        return this.inverse().keySet();
    }

    public Set entrySet() {
        return new HashBiMap$EntrySet(this, null);
    }

    @Override
    public BiMap inverse() {
        return this.inverse == null ? (this.inverse = new HashBiMap$Inverse(this, null)) : this.inverse;
    }

    static /* synthetic */ int access$000(HashBiMap hashBiMap) {
        return hashBiMap.modCount;
    }

    static /* synthetic */ HashBiMap$BiEntry[] access$100(HashBiMap hashBiMap) {
        return hashBiMap.hashTableKToV;
    }

    static /* synthetic */ void access$200(HashBiMap hashBiMap, HashBiMap$BiEntry hashBiMap$BiEntry) {
        hashBiMap.delete(hashBiMap$BiEntry);
    }

    static /* synthetic */ int access$400(Object object) {
        return HashBiMap.hash(object);
    }

    static /* synthetic */ HashBiMap$BiEntry access$500(HashBiMap hashBiMap, Object object, int n) {
        return hashBiMap.seekByKey(object, n);
    }

    static /* synthetic */ HashBiMap$BiEntry access$700(HashBiMap hashBiMap, Object object, int n) {
        return hashBiMap.seekByValue(object, n);
    }

    static /* synthetic */ void access$800(HashBiMap hashBiMap, HashBiMap$BiEntry hashBiMap$BiEntry) {
        hashBiMap.insert(hashBiMap$BiEntry);
    }

    static /* synthetic */ int access$1000(HashBiMap hashBiMap) {
        return hashBiMap.size;
    }

    static /* synthetic */ Object access$1100(HashBiMap hashBiMap, Object object, Object object2, boolean bl) {
        return hashBiMap.putInverse(object, object2, bl);
    }
}

