/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Preconditions;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableBiMap;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableCollection;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableEnumMap;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableMap$Builder;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableMapKeySet;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableMapValues;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableSet;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableSortedMap;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Maps;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.RegularImmutableMap;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.SingletonImmutableBiMap;
import java.io.Serializable;
import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nullable;

public abstract class ImmutableMap
implements Serializable,
Map {
    private transient ImmutableSet entrySet;
    private transient ImmutableSet keySet;
    private transient ImmutableCollection values;

    public static ImmutableMap of() {
        return ImmutableBiMap.of();
    }

    public static ImmutableMap of(Object object, Object object2) {
        return ImmutableBiMap.of(object, object2);
    }

    public static ImmutableMap$Builder builder() {
        return new ImmutableMap$Builder();
    }

    static Map.Entry entryOf(Object object, Object object2) {
        Preconditions.checkNotNull(object, "null key in entry: null=%s", object2);
        Preconditions.checkNotNull(object2, "null value in entry: %s=null", object);
        return Maps.immutableEntry(object, object2);
    }

    public static ImmutableMap copyOf(Map map) {
        Map.Entry[] entryArray;
        if (map instanceof ImmutableMap && !(map instanceof ImmutableSortedMap)) {
            entryArray = (Map.Entry[])map;
            if (!entryArray.isPartialView()) {
                return entryArray;
            }
        } else if (map instanceof EnumMap) {
            EnumMap enumMap = (EnumMap)map;
            for (Map.Entry entry : enumMap.entrySet()) {
                Preconditions.checkNotNull(entry.getKey());
                Preconditions.checkNotNull(entry.getValue());
            }
            ImmutableMap immutableMap = ImmutableEnumMap.asImmutable(new EnumMap(enumMap));
            return immutableMap;
        }
        entryArray = map.entrySet().toArray(new Map.Entry[0]);
        switch (entryArray.length) {
            case 0: {
                return ImmutableMap.of();
            }
            case 1: {
                return new SingletonImmutableBiMap(ImmutableMap.entryOf(entryArray[0].getKey(), entryArray[0].getValue()));
            }
        }
        for (int i = 0; i < entryArray.length; ++i) {
            Object k = entryArray[i].getKey();
            Object v = entryArray[i].getValue();
            entryArray[i] = ImmutableMap.entryOf(k, v);
        }
        return new RegularImmutableMap(entryArray);
    }

    ImmutableMap() {
    }

    @Deprecated
    public final Object put(Object object, Object object2) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public final Object remove(Object object) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public final void putAll(Map map) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(@Nullable Object object) {
        return this.get(object) != null;
    }

    @Override
    public boolean containsValue(@Nullable Object object) {
        return object != null && Maps.containsValueImpl(this, object);
    }

    public abstract Object get(@Nullable Object var1);

    public ImmutableSet entrySet() {
        ImmutableSet immutableSet = this.entrySet;
        return immutableSet == null ? (this.entrySet = this.createEntrySet()) : immutableSet;
    }

    abstract ImmutableSet createEntrySet();

    public ImmutableSet keySet() {
        ImmutableSet immutableSet = this.keySet;
        return immutableSet == null ? (this.keySet = this.createKeySet()) : immutableSet;
    }

    ImmutableSet createKeySet() {
        return new ImmutableMapKeySet(this);
    }

    public ImmutableCollection values() {
        ImmutableCollection immutableCollection = this.values;
        return immutableCollection == null ? (this.values = new ImmutableMapValues(this)) : immutableCollection;
    }

    @Override
    public boolean equals(@Nullable Object object) {
        return Maps.equalsImpl(this, object);
    }

    abstract boolean isPartialView();

    @Override
    public int hashCode() {
        return this.entrySet().hashCode();
    }

    public String toString() {
        return Maps.toStringImpl(this);
    }
}

