/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.eventbus;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Throwables;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.CacheBuilder;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.LoadingCache;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.HashMultimap;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableList;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableList$Builder;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Multimap;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.eventbus.AllowConcurrentEvents;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.eventbus.AnnotatedHandlerFinder$1;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.eventbus.EventHandler;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.eventbus.HandlerFindingStrategy;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.eventbus.Subscribe;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.eventbus.SynchronizedEventHandler;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.reflect.TypeToken;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.util.concurrent.UncheckedExecutionException;
import java.lang.reflect.Method;
import java.util.Set;

class AnnotatedHandlerFinder
implements HandlerFindingStrategy {
    private static final LoadingCache handlerMethodsCache = CacheBuilder.newBuilder().weakKeys().build(new AnnotatedHandlerFinder$1());

    AnnotatedHandlerFinder() {
    }

    @Override
    public Multimap findAllHandlers(Object object) {
        HashMultimap hashMultimap = HashMultimap.create();
        Class<?> clazz = object.getClass();
        for (Method method : AnnotatedHandlerFinder.getAnnotatedMethods(clazz)) {
            Class<?>[] classArray = method.getParameterTypes();
            Class<?> clazz2 = classArray[0];
            EventHandler eventHandler = AnnotatedHandlerFinder.makeHandler(object, method);
            hashMultimap.put(clazz2, eventHandler);
        }
        return hashMultimap;
    }

    private static ImmutableList getAnnotatedMethods(Class clazz) {
        try {
            return (ImmutableList)handlerMethodsCache.getUnchecked(clazz);
        }
        catch (UncheckedExecutionException uncheckedExecutionException) {
            throw Throwables.propagate(uncheckedExecutionException.getCause());
        }
    }

    private static ImmutableList getAnnotatedMethodsInternal(Class clazz) {
        Set set = TypeToken.of(clazz).getTypes().rawTypes();
        ImmutableList$Builder immutableList$Builder = ImmutableList.builder();
        block2: for (Method method : clazz.getMethods()) {
            for (Class clazz2 : set) {
                try {
                    Method method2 = clazz2.getMethod(method.getName(), method.getParameterTypes());
                    if (!method2.isAnnotationPresent(Subscribe.class)) continue;
                    Class<?>[] classArray = method.getParameterTypes();
                    if (classArray.length != 1) {
                        throw new IllegalArgumentException("Method " + method + " has @Subscribe annotation, but requires " + classArray.length + " arguments.  Event handler methods must require a single argument.");
                    }
                    Class<?> clazz3 = classArray[0];
                    immutableList$Builder.add(method);
                    continue block2;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
            }
        }
        return immutableList$Builder.build();
    }

    private static EventHandler makeHandler(Object object, Method method) {
        EventHandler eventHandler = AnnotatedHandlerFinder.methodIsDeclaredThreadSafe(method) ? new EventHandler(object, method) : new SynchronizedEventHandler(object, method);
        return eventHandler;
    }

    private static boolean methodIsDeclaredThreadSafe(Method method) {
        return method.getAnnotation(AllowConcurrentEvents.class) != null;
    }

    static /* synthetic */ ImmutableList access$000(Class clazz) {
        return AnnotatedHandlerFinder.getAnnotatedMethodsInternal(clazz);
    }
}

