/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.io;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Preconditions;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.io.ByteSink;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.io.ByteSource;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.io.ByteStreams;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.io.CharSink;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.io.CharSource;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.io.CharStreams;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.io.FileWriteMode;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.io.Files$FileByteSink;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.io.Files$FileByteSource;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.io.OutputSupplier;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;

public final class Files {
    public static BufferedReader newReader(File file, Charset charset) {
        Preconditions.checkNotNull(file);
        Preconditions.checkNotNull(charset);
        return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), charset));
    }

    public static BufferedWriter newWriter(File file, Charset charset) {
        Preconditions.checkNotNull(file);
        Preconditions.checkNotNull(charset);
        return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), charset));
    }

    public static ByteSource asByteSource(File file) {
        return new Files$FileByteSource(file, null);
    }

    public static ByteSink asByteSink(File file, FileWriteMode ... fileWriteModeArray) {
        return new Files$FileByteSink(file, fileWriteModeArray, null);
    }

    public static CharSource asCharSource(File file, Charset charset) {
        return Files.asByteSource(file).asCharSource(charset);
    }

    public static CharSink asCharSink(File file, Charset charset, FileWriteMode ... fileWriteModeArray) {
        return Files.asByteSink(file, fileWriteModeArray).asCharSink(charset);
    }

    public static OutputSupplier newOutputStreamSupplier(File file, boolean bl) {
        return ByteStreams.asOutputSupplier(Files.asByteSink(file, Files.modes(bl)));
    }

    private static FileWriteMode[] modes(boolean bl) {
        FileWriteMode[] fileWriteModeArray;
        if (bl) {
            FileWriteMode[] fileWriteModeArray2 = new FileWriteMode[1];
            fileWriteModeArray = fileWriteModeArray2;
            fileWriteModeArray2[0] = FileWriteMode.APPEND;
        } else {
            fileWriteModeArray = new FileWriteMode[]{};
        }
        return fileWriteModeArray;
    }

    public static OutputSupplier newWriterSupplier(File file, Charset charset, boolean bl) {
        return CharStreams.asOutputSupplier(Files.asCharSink(file, charset, Files.modes(bl)));
    }

    public static String toString(File file, Charset charset) {
        return Files.asCharSource(file, charset).read();
    }

    public static void write(byte[] byArray, File file) {
        Files.asByteSink(file, new FileWriteMode[0]).write(byArray);
    }

    public static void copy(File file, OutputSupplier outputSupplier) {
        Files.asByteSource(file).copyTo(ByteStreams.asByteSink(outputSupplier));
    }

    public static void write(CharSequence charSequence, File file, Charset charset) {
        Files.asCharSink(file, charset, new FileWriteMode[0]).write(charSequence);
    }

    public static void createParentDirs(File file) {
        Preconditions.checkNotNull(file);
        File file2 = file.getCanonicalFile().getParentFile();
        if (file2 == null) {
            return;
        }
        file2.mkdirs();
        if (!file2.isDirectory()) {
            throw new IOException("Unable to create parent directories of " + file);
        }
    }
}

