/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.reflect;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Preconditions;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableMap;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableMap$Builder;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.reflect.TypeResolver$1;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.reflect.TypeResolver$TypeMappingIntrospector;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.reflect.Types;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.reflect.Types$WildcardTypeImpl;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Map;

class TypeResolver {
    private final ImmutableMap typeTable;

    public TypeResolver() {
        this.typeTable = ImmutableMap.of();
    }

    private TypeResolver(ImmutableMap immutableMap) {
        this.typeTable = immutableMap;
    }

    static TypeResolver accordingTo(Type type) {
        return new TypeResolver().where(TypeResolver$TypeMappingIntrospector.getTypeMappings(type));
    }

    final TypeResolver where(Map map) {
        ImmutableMap$Builder immutableMap$Builder = ImmutableMap.builder();
        immutableMap$Builder.putAll(this.typeTable);
        for (Map.Entry entry : map.entrySet()) {
            Type type;
            TypeVariable typeVariable = (TypeVariable)entry.getKey();
            Preconditions.checkArgument(!typeVariable.equals(type = (Type)entry.getValue()), "Type variable %s bound to itself", typeVariable);
            immutableMap$Builder.put(typeVariable, type);
        }
        return new TypeResolver(immutableMap$Builder.build());
    }

    public final Type resolveType(Type type) {
        Preconditions.checkNotNull(type);
        if (type instanceof TypeVariable) {
            return this.resolveTypeVariable((TypeVariable)type);
        }
        if (type instanceof ParameterizedType) {
            return this.resolveParameterizedType((ParameterizedType)type);
        }
        if (type instanceof GenericArrayType) {
            return this.resolveGenericArrayType((GenericArrayType)type);
        }
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            return new Types$WildcardTypeImpl(this.resolveTypes(wildcardType.getLowerBounds()), this.resolveTypes(wildcardType.getUpperBounds()));
        }
        return type;
    }

    private Type[] resolveTypes(Type[] typeArray) {
        Type[] typeArray2 = new Type[typeArray.length];
        for (int i = 0; i < typeArray.length; ++i) {
            typeArray2[i] = this.resolveType(typeArray[i]);
        }
        return typeArray2;
    }

    private Type resolveGenericArrayType(GenericArrayType genericArrayType) {
        Type type = this.resolveType(genericArrayType.getGenericComponentType());
        return Types.newArrayType(type);
    }

    private Type resolveTypeVariable(TypeVariable typeVariable) {
        TypeResolver typeResolver = this;
        TypeResolver$1 typeResolver$1 = new TypeResolver$1(this, this.typeTable, typeVariable, typeResolver);
        return this.resolveTypeVariable(typeVariable, typeResolver$1);
    }

    Type resolveTypeVariable(TypeVariable typeVariable, TypeResolver typeResolver) {
        Preconditions.checkNotNull(typeResolver);
        Type type = (Type)this.typeTable.get(typeVariable);
        if (type == null) {
            Type[] typeArray = typeVariable.getBounds();
            if (typeArray.length == 0) {
                return typeVariable;
            }
            return Types.newTypeVariable(typeVariable.getGenericDeclaration(), typeVariable.getName(), typeResolver.resolveTypes(typeArray));
        }
        return typeResolver.resolveType(type);
    }

    private ParameterizedType resolveParameterizedType(ParameterizedType parameterizedType) {
        Type type = parameterizedType.getOwnerType();
        Type type2 = type == null ? null : this.resolveType(type);
        Type type3 = this.resolveType(parameterizedType.getRawType());
        Type[] typeArray = parameterizedType.getActualTypeArguments();
        Type[] typeArray2 = new Type[typeArray.length];
        for (int i = 0; i < typeArray.length; ++i) {
            typeArray2[i] = this.resolveType(typeArray[i]);
        }
        return Types.newParameterizedTypeWithOwner(type2, (Class)type3, typeArray2);
    }

    /* synthetic */ TypeResolver(ImmutableMap immutableMap, TypeResolver$1 typeResolver$1) {
        this(immutableMap);
    }
}

