/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic.util;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TimeZone;
import net.arnx.jsonic.util.ExtendedDateFormat;

public class LocalCache {
    private static final int CACHE_SIZE = 256;
    private ResourceBundle resources;
    private Locale locale;
    private TimeZone timeZone;
    private StringBuilder builderCache;
    private String[] stringCache;
    private BigDecimal[] numberCache;
    private Map<String, DateFormat> dateFormatCache;
    private Map<String, NumberFormat> numberFormatCache;

    public LocalCache(String string, Locale locale, TimeZone timeZone) {
        this.resources = ResourceBundle.getBundle(string, locale);
        this.locale = locale;
        this.timeZone = timeZone;
    }

    public StringBuilder getCachedBuffer() {
        if (this.builderCache == null) {
            this.builderCache = new StringBuilder();
        } else {
            this.builderCache.setLength(0);
        }
        return this.builderCache;
    }

    public String getString(StringBuilder stringBuilder) {
        if (stringBuilder.length() == 0) {
            return "";
        }
        if (stringBuilder.length() < 32) {
            String string;
            int n = this.getCacheIndex(stringBuilder);
            if (n < 0) {
                return stringBuilder.toString();
            }
            if (this.stringCache == null) {
                this.stringCache = new String[256];
            }
            if (this.numberCache == null) {
                this.numberCache = new BigDecimal[256];
            }
            if ((string = this.stringCache[n]) == null || string.length() != stringBuilder.length()) {
                this.stringCache[n] = string = stringBuilder.toString();
                this.numberCache[n] = null;
                return string;
            }
            for (int i = 0; i < stringBuilder.length(); ++i) {
                if (string.charAt(i) == stringBuilder.charAt(i)) continue;
                this.stringCache[n] = string = stringBuilder.toString();
                this.numberCache[n] = null;
                return string;
            }
            return string;
        }
        return stringBuilder.toString();
    }

    public BigDecimal getBigDecimal(StringBuilder stringBuilder) {
        if (stringBuilder.length() == 1) {
            if (stringBuilder.charAt(0) == '0') {
                return BigDecimal.ZERO;
            }
            if (stringBuilder.charAt(0) == '1') {
                return BigDecimal.ONE;
            }
        }
        if (stringBuilder.length() < 32) {
            int n = this.getCacheIndex(stringBuilder);
            if (n < 0) {
                return new BigDecimal(stringBuilder.toString());
            }
            if (this.stringCache == null) {
                this.stringCache = new String[256];
            }
            if (this.numberCache == null) {
                this.numberCache = new BigDecimal[256];
            }
            String string = this.stringCache[n];
            BigDecimal bigDecimal = this.numberCache[n];
            if (string == null || string.length() != stringBuilder.length()) {
                string = stringBuilder.toString();
                bigDecimal = new BigDecimal(string);
                this.stringCache[n] = string;
                this.numberCache[n] = bigDecimal;
                return bigDecimal;
            }
            for (int i = 0; i < stringBuilder.length(); ++i) {
                if (string.charAt(i) == stringBuilder.charAt(i)) continue;
                string = stringBuilder.toString();
                bigDecimal = new BigDecimal(string);
                this.stringCache[n] = string;
                this.numberCache[n] = bigDecimal;
                return bigDecimal;
            }
            if (bigDecimal == null) {
                this.numberCache[n] = bigDecimal = new BigDecimal(string);
            }
            return bigDecimal;
        }
        return new BigDecimal(stringBuilder.toString());
    }

    private int getCacheIndex(StringBuilder stringBuilder) {
        int n = 0;
        int n2 = Math.min(16, stringBuilder.length());
        for (int i = 0; i < n2; ++i) {
            n = n * 31 + stringBuilder.charAt(i);
        }
        return n & 0xFF;
    }

    public NumberFormat getNumberFormat(String string) {
        NumberFormat numberFormat = null;
        if (this.numberFormatCache == null) {
            this.numberFormatCache = new HashMap<String, NumberFormat>();
        } else {
            numberFormat = this.numberFormatCache.get(string);
        }
        if (numberFormat == null) {
            numberFormat = new DecimalFormat(string, new DecimalFormatSymbols(this.locale));
            this.numberFormatCache.put(string, numberFormat);
        }
        return numberFormat;
    }

    public DateFormat getDateFormat(String string) {
        DateFormat dateFormat = null;
        if (this.dateFormatCache == null) {
            this.dateFormatCache = new HashMap<String, DateFormat>();
        } else {
            dateFormat = this.dateFormatCache.get(string);
        }
        if (dateFormat == null) {
            dateFormat = new ExtendedDateFormat(string, this.locale);
            dateFormat.setTimeZone(this.timeZone);
            this.dateFormatCache.put(string, dateFormat);
        }
        return dateFormat;
    }

    public String getMessage(String string) {
        return this.getMessage(string, null);
    }

    public String getMessage(String string, Object ... objectArray) {
        if (objectArray != null && objectArray.length > 0) {
            return MessageFormat.format(this.resources.getString(string), objectArray);
        }
        return this.resources.getString(string);
    }
}

