/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.client.smb;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Resource;
import jcifs.smb.ACE;
import jcifs.smb.SmbException;
import jcifs.smb.SmbFile;
import jcifs.smb.SmbFileInputStream;
import org.apache.commons.io.IOUtils;
import org.seasar.framework.container.SingletonS2Container;
import org.seasar.framework.container.annotation.tiger.Binding;
import org.seasar.framework.container.annotation.tiger.BindingType;
import org.seasar.framework.container.annotation.tiger.DestroyMethod;
import org.seasar.framework.exception.IORuntimeException;
import org.seasar.framework.util.FileOutputStreamUtil;
import org.seasar.framework.util.InputStreamUtil;
import org.seasar.framework.util.OutputStreamUtil;
import org.seasar.framework.util.StringUtil;
import org.seasar.robot.MaxLengthExceededException;
import org.seasar.robot.RobotCrawlAccessException;
import org.seasar.robot.RobotSystemException;
import org.seasar.robot.client.AbstractS2RobotClient;
import org.seasar.robot.client.fs.ChildUrlsException;
import org.seasar.robot.client.smb.SmbAuthentication;
import org.seasar.robot.client.smb.SmbAuthenticationHolder;
import org.seasar.robot.entity.ResponseData;
import org.seasar.robot.helper.ContentLengthHelper;
import org.seasar.robot.helper.MimeTypeHelper;
import org.seasar.robot.util.TemporaryFileInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmbClient
extends AbstractS2RobotClient {
    private static final Logger logger = LoggerFactory.getLogger(SmbClient.class);
    public static final String SMB_AUTHENTICATIONS_PROPERTY = "smbAuthentications";
    public static final String SMB_ACCESS_CONTROL_ENTRIES = "smbAccessControlEntries";
    protected String charset = "UTF-8";
    protected boolean resolveSids = true;
    @Binding(bindingType=BindingType.MAY)
    @Resource
    protected ContentLengthHelper contentLengthHelper;
    public volatile SmbAuthenticationHolder smbAuthenticationHolder;

    public synchronized void init() {
        if (this.smbAuthenticationHolder != null) {
            return;
        }
        SmbAuthentication[] smbAuthentications = this.getInitParameter(SMB_AUTHENTICATIONS_PROPERTY, new SmbAuthentication[0]);
        if (smbAuthentications != null) {
            SmbAuthenticationHolder smbAuthenticationHolder = new SmbAuthenticationHolder();
            for (SmbAuthentication smbAuthentication : smbAuthentications) {
                smbAuthenticationHolder.add(smbAuthentication);
            }
            this.smbAuthenticationHolder = smbAuthenticationHolder;
        }
    }

    @DestroyMethod
    public void destroy() {
        this.smbAuthenticationHolder = null;
    }

    public ResponseData doGet(String uri) {
        return this.getResponseData(uri, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResponseData getResponseData(String uri, boolean includeContent) {
        ResponseData responseData;
        block21: {
            if (this.smbAuthenticationHolder == null) {
                this.init();
            }
            responseData = new ResponseData();
            responseData.setMethod("GET");
            String filePath = this.preprocessUri(uri);
            responseData.setUrl(filePath);
            SmbFile file = null;
            SmbAuthentication smbAuthentication = this.smbAuthenticationHolder.get(filePath);
            try {
                file = smbAuthentication == null ? new SmbFile(filePath) : new SmbFile(filePath, smbAuthentication.getAuthentication());
            }
            catch (MalformedURLException e) {
                logger.warn("Could not parse url: " + filePath, (Throwable)e);
            }
            try {
                block22: {
                    if (file == null) {
                        responseData.setHttpStatusCode(404);
                        responseData.setCharSet(this.charset);
                        responseData.setContentLength(0L);
                        break block21;
                    }
                    if (!file.isFile()) break block22;
                    MimeTypeHelper mimeTypeHelper = (MimeTypeHelper)SingletonS2Container.getComponent((String)"mimeTypeHelper");
                    SmbFileInputStream is = null;
                    try {
                        is = new SmbFileInputStream(file);
                        responseData.setMimeType(mimeTypeHelper.getContentType((InputStream)is, file.getName()));
                    }
                    catch (Exception e) {
                        try {
                            responseData.setMimeType(mimeTypeHelper.getContentType(null, file.getName()));
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(is);
                            throw throwable;
                        }
                        IOUtils.closeQuietly((InputStream)is);
                    }
                    IOUtils.closeQuietly((InputStream)is);
                    responseData.setContentLength(file.length());
                    if (this.contentLengthHelper != null) {
                        long maxLength = this.contentLengthHelper.getMaxLength(responseData.getMimeType());
                        if (responseData.getContentLength() > maxLength) {
                            throw new MaxLengthExceededException("The content length (" + responseData.getContentLength() + " byte) is over " + maxLength + " byte. The url is " + filePath);
                        }
                    }
                    responseData.setHttpStatusCode(200);
                    responseData.setCharSet(this.geCharSet(file));
                    responseData.setLastModified(new Date(file.lastModified()));
                    this.processAccessControlEntries(responseData, file);
                    Map headerFieldMap = file.getHeaderFields();
                    if (headerFieldMap != null) {
                        for (Map.Entry entry : headerFieldMap.entrySet()) {
                            responseData.addMetaData((String)entry.getKey(), entry.getValue());
                        }
                    }
                    if (file.canRead()) {
                        if (!includeContent) break block21;
                        File outputFile = null;
                        try {
                            outputFile = File.createTempFile("s2robot-SmbClient-", ".out");
                            this.copy(file, outputFile);
                            responseData.setResponseBody(new TemporaryFileInputStream(outputFile));
                        }
                        catch (Exception e) {
                            logger.warn("I/O Exception.", (Throwable)e);
                            responseData.setHttpStatusCode(500);
                            if (outputFile != null && !outputFile.delete()) {
                                logger.warn("Could not delete " + outputFile.getAbsolutePath());
                            }
                            break block21;
                        }
                    }
                    responseData.setHttpStatusCode(403);
                    break block21;
                }
                if (file.isDirectory()) {
                    SmbFile[] files;
                    HashSet<String> childUrlSet = new HashSet<String>();
                    if (includeContent && (files = file.listFiles()) != null) {
                        for (SmbFile f : files) {
                            String chileUri = f.toString();
                            childUrlSet.add(chileUri);
                        }
                    }
                    throw new ChildUrlsException(childUrlSet);
                }
                responseData.setHttpStatusCode(404);
                responseData.setCharSet(this.charset);
                responseData.setContentLength(0L);
            }
            catch (SmbException e) {
                throw new RobotCrawlAccessException("Could not access " + uri, e);
            }
        }
        return responseData;
    }

    protected void processAccessControlEntries(ResponseData responseData, SmbFile file) {
        try {
            ACE[] aces = file.getSecurity(this.resolveSids);
            if (aces != null) {
                responseData.addMetaData(SMB_ACCESS_CONTROL_ENTRIES, aces);
            }
        }
        catch (IOException e) {
            throw new RobotCrawlAccessException("Could not access " + file.getPath(), e);
        }
    }

    protected String preprocessUri(String uri) {
        if (StringUtil.isEmpty((String)uri)) {
            throw new RobotSystemException("The uri is empty.");
        }
        return uri;
    }

    protected String geCharSet(SmbFile file) {
        return this.charset;
    }

    public ResponseData doHead(String url) {
        try {
            ResponseData responseData = this.getResponseData(url, false);
            responseData.setMethod("HEAD");
            return responseData;
        }
        catch (ChildUrlsException e) {
            return null;
        }
    }

    private void copy(SmbFile src, File dest) {
        if (dest.exists() && !dest.canWrite()) {
            return;
        }
        BufferedInputStream in = null;
        BufferedOutputStream out = null;
        try {
            int length;
            in = new BufferedInputStream((InputStream)new SmbFileInputStream(src));
            out = new BufferedOutputStream(FileOutputStreamUtil.create((File)dest));
            byte[] buf = new byte[1024];
            while (-1 < (length = in.read(buf))) {
                out.write(buf, 0, length);
                out.flush();
            }
        }
        catch (IOException e) {
            try {
                throw new IORuntimeException(e);
            }
            catch (Throwable throwable) {
                InputStreamUtil.close(in);
                OutputStreamUtil.close(out);
                throw throwable;
            }
        }
        InputStreamUtil.close((InputStream)in);
        OutputStreamUtil.close((OutputStream)out);
    }

    public boolean isResolveSids() {
        return this.resolveSids;
    }

    public void setResolveSids(boolean resolveSids) {
        this.resolveSids = resolveSids;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }
}

