/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.impl;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import org.apache.http.client.HttpClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpClientUtil;
import org.apache.solr.client.solrj.impl.LBHttpSolrServer;
import org.apache.solr.client.solrj.request.IsUpdateRequest;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.Aliases;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.cloud.ZooKeeperException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.StrUtils;
import org.apache.zookeeper.KeeperException;

public class CloudSolrServer
extends SolrServer {
    private volatile ZkStateReader zkStateReader;
    private String zkHost;
    private int zkConnectTimeout = 10000;
    private int zkClientTimeout = 10000;
    private volatile String defaultCollection;
    private LBHttpSolrServer lbServer;
    private HttpClient myClient;
    Random rand = new Random();
    private Object cachLock = new Object();
    private Map<String, List<String>> urlLists = new HashMap<String, List<String>>();
    private Map<String, List<String>> leaderUrlLists = new HashMap<String, List<String>>();
    private Map<String, List<String>> replicasLists = new HashMap<String, List<String>>();
    private volatile int lastClusterStateHashCode;
    private final boolean updatesToLeaders;

    public CloudSolrServer(String zkHost) throws MalformedURLException {
        this.zkHost = zkHost;
        this.myClient = HttpClientUtil.createClient(null);
        this.lbServer = new LBHttpSolrServer(this.myClient, new String[0]);
        this.updatesToLeaders = true;
    }

    public CloudSolrServer(String zkHost, boolean updatesToLeaders) throws MalformedURLException {
        this.zkHost = zkHost;
        this.myClient = HttpClientUtil.createClient(null);
        this.lbServer = new LBHttpSolrServer(this.myClient, new String[0]);
        this.updatesToLeaders = updatesToLeaders;
    }

    public CloudSolrServer(String zkHost, LBHttpSolrServer lbServer) {
        this.zkHost = zkHost;
        this.lbServer = lbServer;
        this.updatesToLeaders = true;
    }

    public CloudSolrServer(String zkHost, LBHttpSolrServer lbServer, boolean updatesToLeaders) {
        this.zkHost = zkHost;
        this.lbServer = lbServer;
        this.updatesToLeaders = updatesToLeaders;
    }

    public ZkStateReader getZkStateReader() {
        return this.zkStateReader;
    }

    public void setDefaultCollection(String collection) {
        this.defaultCollection = collection;
    }

    public String getDefaultCollection() {
        return this.defaultCollection;
    }

    public void setZkConnectTimeout(int zkConnectTimeout) {
        this.zkConnectTimeout = zkConnectTimeout;
    }

    public void setZkClientTimeout(int zkClientTimeout) {
        this.zkClientTimeout = zkClientTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect() {
        if (this.zkStateReader == null) {
            CloudSolrServer cloudSolrServer = this;
            synchronized (cloudSolrServer) {
                if (this.zkStateReader == null) {
                    try {
                        ZkStateReader zk = new ZkStateReader(this.zkHost, this.zkConnectTimeout, this.zkClientTimeout);
                        zk.createClusterStateWatchersAndUpdate();
                        this.zkStateReader = zk;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
                    }
                    catch (KeeperException e) {
                        throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
                    }
                    catch (IOException e) {
                        throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
                    }
                    catch (TimeoutException e) {
                        throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NamedList<Object> request(SolrRequest request) throws SolrServerException, IOException {
        SolrParams reqParams;
        this.connect();
        ClusterState clusterState = this.zkStateReader.getClusterState();
        boolean sendToLeaders = false;
        ArrayList<String> replicas = null;
        if (request instanceof IsUpdateRequest && this.updatesToLeaders) {
            sendToLeaders = true;
            replicas = new ArrayList<String>();
        }
        if ((reqParams = request.getParams()) == null) {
            reqParams = new ModifiableSolrParams();
        }
        ArrayList<String> theUrlList = new ArrayList<String>();
        if (request.getPath().equals("/admin/collections") || request.getPath().equals("/admin/cores")) {
            Set<String> liveNodes = clusterState.getLiveNodes();
            for (String liveNode : liveNodes) {
                int splitPointBetweenHostPortAndContext = liveNode.indexOf("_");
                theUrlList.add("http://" + liveNode.substring(0, splitPointBetweenHostPortAndContext) + "/" + URLDecoder.decode(liveNode, "UTF-8").substring(splitPointBetweenHostPortAndContext + 1));
            }
        } else {
            String collection = reqParams.get("collection", this.defaultCollection);
            if (collection == null) {
                throw new SolrServerException("No collection param specified on request and no default collection has been set.");
            }
            Set<String> collectionsList = this.getCollectionList(clusterState, collection);
            if (collectionsList.size() == 0) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Could not find collection: " + collection);
            }
            collection = collectionsList.iterator().next();
            StringBuilder collectionString = new StringBuilder();
            Iterator<String> it = collectionsList.iterator();
            for (int i = 0; i < collectionsList.size(); ++i) {
                String col = it.next();
                collectionString.append(col);
                if (i >= collectionsList.size() - 1) continue;
                collectionString.append(",");
            }
            HashMap<String, Slice> slices = new HashMap<String, Slice>();
            for (String collectionName : collectionsList) {
                Collection<Slice> colSlices = clusterState.getActiveSlices(collectionName);
                if (colSlices == null) {
                    throw new SolrServerException("Could not find collection:" + collectionName);
                }
                ClientUtils.addSlices(slices, collectionName, colSlices, true);
            }
            Set<String> liveNodes = clusterState.getLiveNodes();
            Object object = this.cachLock;
            synchronized (object) {
                List<String> leaderUrlList = this.leaderUrlLists.get(collection);
                List<String> urlList = this.urlLists.get(collection);
                List<String> replicasList = this.replicasLists.get(collection);
                if (sendToLeaders && leaderUrlList == null || !sendToLeaders && urlList == null || clusterState.hashCode() != this.lastClusterStateHashCode) {
                    HashMap<String, Replica> nodes = new HashMap<String, Replica>();
                    ArrayList<String> urlList2 = new ArrayList<String>();
                    for (Slice slice : slices.values()) {
                        for (Replica nodeProps : slice.getReplicasMap().values()) {
                            String url;
                            ZkCoreNodeProps coreNodeProps = new ZkCoreNodeProps(nodeProps);
                            String node = coreNodeProps.getNodeName();
                            if (!liveNodes.contains(coreNodeProps.getNodeName()) || !coreNodeProps.getState().equals("active") || nodes.put(node, nodeProps) != null) continue;
                            if (!sendToLeaders || sendToLeaders && coreNodeProps.isLeader()) {
                                url = coreNodeProps.getCoreUrl();
                                urlList2.add(url);
                                continue;
                            }
                            if (!sendToLeaders) continue;
                            url = coreNodeProps.getCoreUrl();
                            replicas.add(url);
                        }
                    }
                    if (sendToLeaders) {
                        this.leaderUrlLists.put(collection, urlList2);
                        leaderUrlList = urlList2;
                        this.replicasLists.put(collection, replicas);
                        replicasList = replicas;
                    } else {
                        this.urlLists.put(collection, urlList2);
                        urlList = urlList2;
                    }
                    this.lastClusterStateHashCode = clusterState.hashCode();
                }
                if (sendToLeaders) {
                    theUrlList = new ArrayList(leaderUrlList.size());
                    theUrlList.addAll(leaderUrlList);
                } else {
                    theUrlList = new ArrayList(urlList.size());
                    theUrlList.addAll(urlList);
                }
                Collections.shuffle(theUrlList, this.rand);
                if (sendToLeaders) {
                    ArrayList<String> theReplicas = new ArrayList<String>(replicasList.size());
                    theReplicas.addAll(replicasList);
                    Collections.shuffle(theReplicas, this.rand);
                    theUrlList.addAll(theReplicas);
                }
            }
        }
        LBHttpSolrServer.Req req = new LBHttpSolrServer.Req(request, theUrlList);
        LBHttpSolrServer.Rsp rsp = this.lbServer.request(req);
        return rsp.getResponse();
    }

    private Set<String> getCollectionList(ClusterState clusterState, String collection) {
        List<String> rawCollectionsList = StrUtils.splitSmart(collection, ",", true);
        HashSet<String> collectionsList = new HashSet<String>();
        for (String collectionName : rawCollectionsList) {
            if (!clusterState.getCollections().contains(collectionName)) {
                Aliases aliases = this.zkStateReader.getAliases();
                String alias = aliases.getCollectionAlias(collectionName);
                if (alias != null) {
                    List<String> aliasList = StrUtils.splitSmart(alias, ",", true);
                    collectionsList.addAll(aliasList);
                    continue;
                }
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Collection not found: " + collectionName);
            }
            collectionsList.add(collectionName);
        }
        return collectionsList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        if (this.zkStateReader != null) {
            CloudSolrServer cloudSolrServer = this;
            synchronized (cloudSolrServer) {
                if (this.zkStateReader != null) {
                    this.zkStateReader.close();
                }
                this.zkStateReader = null;
            }
        }
        if (this.myClient != null) {
            this.myClient.getConnectionManager().shutdown();
        }
    }

    public LBHttpSolrServer getLbServer() {
        return this.lbServer;
    }

    public boolean isUpdatesToLeaders() {
        return this.updatesToLeaders;
    }

    Map<String, List<String>> getUrlLists() {
        return this.urlLists;
    }

    Map<String, List<String>> getLeaderUrlLists() {
        return this.leaderUrlLists;
    }

    Map<String, List<String>> getReplicasLists() {
        return this.replicasLists;
    }
}

