/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.cloud;

import java.util.Collection;
import java.util.Collections;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.DocRouter;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.params.SolrParams;

public class ImplicitDocRouter
extends DocRouter {
    public static final String NAME = "implicit";

    @Override
    public Slice getTargetSlice(String id, SolrInputDocument sdoc, SolrParams params, DocCollection collection) {
        Object o;
        String shard = null;
        if (sdoc != null && (o = sdoc.getFieldValue("_shard_")) != null) {
            shard = o.toString();
        }
        if (shard == null) {
            shard = params.get("_shard_");
        }
        if (shard != null) {
            Slice slice = collection.getSlice(shard);
            if (slice == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No _shard_=" + shard + " in " + collection);
            }
            return slice;
        }
        return null;
    }

    @Override
    public boolean isTargetSlice(String id, SolrInputDocument sdoc, SolrParams params, String shardId, DocCollection collection) {
        return false;
    }

    @Override
    public Collection<Slice> getSearchSlicesSingle(String shardKey, SolrParams params, DocCollection collection) {
        if (shardKey == null) {
            return collection.getActiveSlices();
        }
        Slice slice = collection.getSlice(shardKey);
        if (slice == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "implicit router can't find shard " + shardKey + " in collection " + collection.getName());
        }
        return Collections.singleton(slice);
    }
}

