/*
 * Decompiled with CFR 0.152.
 */
package org.mobylet.core.http;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MobyletContext {
    public static final String CONTEXT_KEY = MobyletContext.class.getName();
    protected Map<Class<?>, Object> context = new HashMap();

    public <I> I get(Class<I> clazz) {
        return (I)this.context.get(clazz);
    }

    public void set(Object obj) {
        if (obj != null) {
            Set<Class<?>> interfaces = MobyletContext.getInterfaces(obj.getClass());
            if (interfaces != null && interfaces.size() > 0) {
                for (Class<?> clazz : interfaces) {
                    this.context.put(clazz, obj);
                }
            }
            this.context.put(obj.getClass(), obj);
        }
    }

    public void remove(Class<?> clazz) {
        Set<Class<?>> interfaces;
        if (clazz != null && (interfaces = MobyletContext.getInterfaces(clazz)) != null && interfaces.size() > 0) {
            for (Class<?> pClazz : interfaces) {
                this.context.remove(pClazz);
            }
        }
        this.context.remove(clazz);
    }

    private static Set<Class<?>> getInterfaces(Class<?> clazz) {
        HashSet classSet = new HashSet();
        Class<?>[] interfaces = clazz.getInterfaces();
        if (interfaces != null) {
            for (Class<?> i : interfaces) {
                classSet.add(i);
            }
        }
        Class<?> superClass = null;
        superClass = clazz.getSuperclass();
        if (superClass != null) {
            Set<Class<?>> tmpSet = MobyletContext.getInterfaces(superClass);
            classSet.addAll(tmpSet);
            if (!Object.class.equals(superClass)) {
                classSet.add(superClass);
            }
        }
        return classSet;
    }
}

