/*
 * Decompiled with CFR 0.152.
 */
package org.mobylet.core.xml;

import java.util.Stack;
import org.mobylet.core.xml.XmlNode;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlHandler
extends DefaultHandler {
    protected Stack<XmlNode> nodeStack;
    protected XmlNode root;

    public XmlHandler() {
        this.initialize();
    }

    public void initialize() {
        this.nodeStack = null;
        this.root = null;
    }

    public XmlNode getRootNode() {
        return this.root;
    }

    @Override
    public void startDocument() throws SAXException {
        this.nodeStack = new Stack();
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        XmlNode node = new XmlNode(name);
        int attributeLength = attributes.getLength();
        for (int i = 0; i < attributeLength; ++i) {
            node.addAttribute(attributes.getQName(i), attributes.getValue(i));
        }
        if (this.root == null) {
            this.root = node;
        } else {
            XmlNode parent = this.nodeStack.peek();
            parent.addChild(node);
            node.setParent(parent);
        }
        this.nodeStack.push(node);
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        XmlNode node = this.nodeStack.pop();
        String nodeValue = node.getValue();
        if (nodeValue != null) {
            String nodeValueString = nodeValue.toString().trim();
            node.setValue(nodeValueString);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        XmlNode node = this.nodeStack.peek();
        if (node.getValue() == null) {
            node.setValue(new String(ch, start, length));
        } else {
            node.setValue(node.getValue() + new String(ch, start, length));
        }
    }
}

