/*
 * Decompiled with CFR 0.152.
 */
package org.mobylet.view.xhtml;

import java.io.CharArrayWriter;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mobylet.core.MobyletRuntimeException;
import org.mobylet.view.xhtml.TagAttributes;
import org.mobylet.view.xhtml.TagElement;
import org.mobylet.view.xhtml.XhtmlHandler;

public class XhtmlParser {
    private static final Pattern REGEX_SPLIT_IN_TAG = Pattern.compile("[a-zA-Z0-9_?!-]+([\\s]?=[\\s]?[\"']?[^\"]*[\"']?)?");

    public void parse(char[] ch, XhtmlHandler handler) {
        CharArrayWriter writer = new CharArrayWriter(256);
        int offset = 0;
        int length = 0;
        boolean inComment = false;
        boolean inQuot = false;
        boolean inWQuot = false;
        boolean inTag = false;
        int pre1 = 0;
        int pre2 = 0;
        int pre3 = 0;
        try {
            handler.startDocument();
            for (int pos = 0; pos < ch.length; ++pos) {
                int c = ch[pos];
                switch (c) {
                    case 60: {
                        if (!(inComment || inWQuot || inQuot)) {
                            if (pos + 3 < ch.length && ch[pos + 1] == '!' && ch[pos + 2] == '-' && ch[pos + 3] == '-') {
                                pos += 3;
                                inComment = true;
                                if (length != 0 && !inTag) {
                                    handler.characters(ch, offset, length);
                                }
                            } else {
                                inTag = true;
                                if (length != 0) {
                                    handler.characters(ch, offset, length);
                                }
                            }
                            offset = pos + 1;
                            length = 0;
                            break;
                        }
                        if (inComment) break;
                        ++length;
                        if (!inTag) break;
                        writer.write(c);
                        break;
                    }
                    case 62: {
                        if (inComment && pre2 == 45 && pre1 == 45) {
                            inComment = false;
                            offset = pos + 1;
                            break;
                        }
                        if (!(inComment || inWQuot || inQuot)) {
                            if (length != 0) {
                                boolean existsBody = true;
                                boolean isEndTag = false;
                                String inTagStr = writer.toString();
                                if (inTagStr.endsWith("/")) {
                                    existsBody = false;
                                    inTagStr = inTagStr.substring(0, inTagStr.length() - 1);
                                } else if (inTagStr.startsWith("/")) {
                                    isEndTag = true;
                                    inTagStr = inTagStr.substring(1);
                                }
                                String[] elements = null;
                                ArrayList<String> elemList = new ArrayList<String>();
                                Matcher matcher = REGEX_SPLIT_IN_TAG.matcher(inTagStr);
                                while (matcher.find()) {
                                    elemList.add(matcher.group());
                                }
                                elements = new String[elemList.size()];
                                elemList.toArray(elements);
                                if (elements.length > 0 && !elements[0].equals("?xml") && !elements[0].equals("!DOCTYPE")) {
                                    TagElement tagElement = new TagElement(elements[0]);
                                    for (int i = 1; i < elements.length; ++i) {
                                        String key;
                                        int idxEq = elements[i].indexOf(61);
                                        if (idxEq < 0) {
                                            key = elements[i].trim();
                                            tagElement.putAttribute(key, key);
                                            continue;
                                        }
                                        key = elements[i].substring(0, idxEq).trim();
                                        String val = elements[i].substring(idxEq + 1).trim();
                                        if (val.startsWith("\"") || val.startsWith("'")) {
                                            val = val.substring(1, val.length() - 1);
                                        }
                                        tagElement.putAttribute(key, val);
                                    }
                                    if (isEndTag) {
                                        handler.endElement(tagElement.getName());
                                    } else {
                                        handler.startElement(tagElement.getName(), new TagAttributes(tagElement.getAttMap()), existsBody);
                                    }
                                }
                            }
                            offset = pos + 1;
                            length = 0;
                            inTag = false;
                            writer.reset();
                            break;
                        }
                        if (inComment) break;
                        ++length;
                        if (!inTag) break;
                        writer.write(c);
                        break;
                    }
                    case 45: {
                        if (!(inComment || inWQuot || inQuot || pre3 != 60 || pre2 != 33 || pre1 != 45)) {
                            inComment = true;
                            length = 0;
                            break;
                        }
                        if (inComment) break;
                        ++length;
                        if (!inTag) break;
                        writer.write(c);
                        break;
                    }
                    case 34: {
                        if (inComment || inQuot) break;
                        if (!inWQuot || pre1 != 92) {
                            inWQuot = !inWQuot;
                        }
                        ++length;
                        if (!inTag) break;
                        writer.write(c);
                        break;
                    }
                    case 39: {
                        if (inComment || inWQuot) break;
                        if (!inQuot || pre1 != 92) {
                            inQuot = !inQuot;
                        }
                        ++length;
                        if (!inTag) break;
                        writer.write(c);
                        break;
                    }
                    default: {
                        if (inComment) break;
                        ++length;
                        if (!inTag) break;
                        writer.write(c);
                    }
                }
                pre3 = pre2;
                pre2 = pre1;
                pre1 = c;
            }
        }
        catch (Exception e) {
            throw new MobyletRuntimeException("XHTML\u304c\u6b63\u3057\u304f\u8aad\u3081\u307e\u305b\u3093", e);
        }
        handler.endDocument();
    }
}

