/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update.processor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRef;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.impl.HttpSolrServer;
import org.apache.solr.client.solrj.request.CoreAdminRequest;
import org.apache.solr.cloud.CloudDescriptor;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.SolrInputField;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.DocRouter;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.cloud.ZooKeeperException;
import org.apache.solr.common.params.CoreAdminParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.Hash;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.handler.component.RealTimeGetComponent;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrRequestInfo;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.CommitUpdateCommand;
import org.apache.solr.update.DeleteUpdateCommand;
import org.apache.solr.update.SolrCmdDistributor;
import org.apache.solr.update.UpdateCommand;
import org.apache.solr.update.UpdateHandler;
import org.apache.solr.update.UpdateLog;
import org.apache.solr.update.VersionBucket;
import org.apache.solr.update.VersionInfo;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributedUpdateProcessor
extends UpdateRequestProcessor {
    private static final String TEST_DISTRIB_SKIP_SERVERS = "test.distrib.skip.servers";
    public static final Logger log = LoggerFactory.getLogger(DistributedUpdateProcessor.class);
    public static final String COMMIT_END_POINT = "commit_end_point";
    public static final String LOG_REPLAY = "log_replay";
    private final SolrQueryRequest req;
    private final SolrQueryResponse rsp;
    private final UpdateRequestProcessor next;
    public static final String VERSION_FIELD = "_version_";
    private final UpdateHandler updateHandler;
    private final UpdateLog ulog;
    private final VersionInfo vinfo;
    private final boolean versionsStored;
    private boolean returnVersions = true;
    private NamedList addsResponse = null;
    private NamedList deleteResponse = null;
    private NamedList deleteByQueryResponse = null;
    private CharsRef scratch;
    private final SchemaField idField;
    private SolrCmdDistributor cmdDistrib;
    private boolean zkEnabled = false;
    private CloudDescriptor cloudDesc;
    private String collection;
    private ZkController zkController;
    private boolean isLeader = true;
    private boolean forwardToLeader = false;
    private boolean isSubShardLeader = false;
    private List<SolrCmdDistributor.Node> nodes;
    private int numNodes;
    private UpdateCommand updateCommand;

    public DistributedUpdateProcessor(SolrQueryRequest req, SolrQueryResponse rsp, UpdateRequestProcessor next) {
        super(next);
        this.rsp = rsp;
        this.next = next;
        this.idField = req.getSchema().getUniqueKeyField();
        this.updateHandler = req.getCore().getUpdateHandler();
        this.ulog = this.updateHandler.getUpdateLog();
        this.vinfo = this.ulog == null ? null : this.ulog.getVersionInfo();
        this.versionsStored = this.vinfo != null && this.vinfo.getVersionField() != null;
        this.returnVersions = req.getParams().getBool("versions", false);
        SolrRequestInfo reqInfo = this.returnVersions ? SolrRequestInfo.getRequestInfo() : null;
        this.req = req;
        CoreDescriptor coreDesc = req.getCore().getCoreDescriptor();
        this.zkEnabled = coreDesc.getCoreContainer().isZooKeeperAware();
        this.zkController = req.getCore().getCoreDescriptor().getCoreContainer().getZkController();
        if (this.zkEnabled) {
            this.numNodes = this.zkController.getZkStateReader().getClusterState().getLiveNodes().size();
            this.cmdDistrib = new SolrCmdDistributor(this.numNodes, coreDesc.getCoreContainer().getZkController().getUpdateShardHandler());
        }
        this.cloudDesc = coreDesc.getCloudDescriptor();
        if (this.cloudDesc != null) {
            this.collection = this.cloudDesc.getCollectionName();
        }
    }

    private List<SolrCmdDistributor.Node> setupRequest(String id, SolrInputDocument doc) {
        ArrayList<SolrCmdDistributor.StdNode> nodes = null;
        if (this.zkEnabled) {
            String shardId;
            if ((this.updateCommand.getFlags() & (UpdateCommand.REPLAY | UpdateCommand.PEER_SYNC)) != 0) {
                this.isLeader = false;
                this.forwardToLeader = false;
                return nodes;
            }
            String coreName = this.req.getCore().getName();
            ClusterState cstate = this.zkController.getClusterState();
            this.numNodes = cstate.getLiveNodes().size();
            DocCollection coll = cstate.getCollection(this.collection);
            Slice slice = coll.getRouter().getTargetSlice(id, doc, this.req.getParams(), coll);
            if (slice == null && (slice = coll.getSlice(shardId = this.req.getCore().getCoreDescriptor().getCloudDescriptor().getShardId())) == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No shard " + shardId + " in " + coll);
            }
            shardId = slice.getName();
            try {
                Replica leaderReplica = this.zkController.getZkStateReader().getLeaderRetry(this.collection, shardId);
                this.isLeader = leaderReplica.getName().equals(this.req.getCore().getCoreDescriptor().getCloudDescriptor().getCoreNodeName());
                if (!this.isLeader) {
                    this.isSubShardLeader = this.amISubShardLeader(coll, slice, id, doc);
                    if (this.isSubShardLeader) {
                        String myShardId = this.req.getCore().getCoreDescriptor().getCloudDescriptor().getShardId();
                        slice = coll.getSlice(myShardId);
                        shardId = myShardId;
                        leaderReplica = this.zkController.getZkStateReader().getLeaderRetry(this.collection, myShardId);
                        List myReplicas = this.zkController.getZkStateReader().getReplicaProps(this.collection, shardId, leaderReplica.getName(), coreName, null, "down");
                    }
                }
                DistribPhase phase = DistribPhase.parseParam(this.req.getParams().get("update.distrib"));
                this.doDefensiveChecks(phase);
                if (DistribPhase.FROMLEADER == phase && !this.isSubShardLeader) {
                    this.forwardToLeader = false;
                } else if (this.isLeader || this.isSubShardLeader) {
                    this.forwardToLeader = false;
                    List replicaProps = this.zkController.getZkStateReader().getReplicaProps(this.collection, shardId, leaderReplica.getName(), coreName, null, "down");
                    if (replicaProps != null) {
                        if (nodes == null) {
                            nodes = new ArrayList(replicaProps.size());
                        }
                        String[] skipList = this.req.getParams().getParams(TEST_DISTRIB_SKIP_SERVERS);
                        HashSet<String> skipListSet = null;
                        if (skipList != null) {
                            skipListSet = new HashSet<String>(skipList.length);
                            skipListSet.addAll(Arrays.asList(skipList));
                            log.info("test.distrib.skip.servers was found and contains:" + skipListSet);
                        }
                        for (ZkCoreNodeProps props : replicaProps) {
                            if (skipList != null) {
                                boolean skip = skipListSet.contains(props.getCoreUrl());
                                log.info("check url:" + props.getCoreUrl() + " against:" + skipListSet + " result:" + skip);
                                if (skip) continue;
                                nodes.add(new SolrCmdDistributor.StdNode(props));
                                continue;
                            }
                            nodes.add(new SolrCmdDistributor.StdNode(props));
                        }
                    }
                } else {
                    nodes = new ArrayList<SolrCmdDistributor.StdNode>(1);
                    nodes.add(new RetryNode(new ZkCoreNodeProps((ZkNodeProps)leaderReplica), this.zkController.getZkStateReader(), this.collection, shardId));
                    this.forwardToLeader = true;
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
            }
        }
        return nodes;
    }

    private boolean amISubShardLeader(DocCollection coll, Slice parentSlice, String id, SolrInputDocument doc) throws InterruptedException {
        Replica myLeader;
        boolean amILeader;
        String myShardId = this.req.getCore().getCoreDescriptor().getCloudDescriptor().getShardId();
        Slice mySlice = coll.getSlice(myShardId);
        if (Slice.CONSTRUCTION.equals(mySlice.getState()) && (amILeader = (myLeader = this.zkController.getZkStateReader().getLeaderRetry(this.collection, myShardId)).getName().equals(this.req.getCore().getCoreDescriptor().getCloudDescriptor().getCoreNodeName()))) {
            DocRouter.Range myRange = mySlice.getRange();
            if (myRange == null) {
                myRange = new DocRouter.Range(Integer.MIN_VALUE, Integer.MAX_VALUE);
            }
            if (parentSlice != null) {
                boolean isSubset = parentSlice.getRange() != null && myRange.isSubsetOf(parentSlice.getRange());
                return isSubset && coll.getRouter().isTargetSlice(id, doc, this.req.getParams(), myShardId, coll);
            }
            return true;
        }
        return false;
    }

    private List<SolrCmdDistributor.Node> getSubShardLeaders(DocCollection coll, String shardId, String docId, SolrInputDocument doc) {
        Collection allSlices = coll.getSlices();
        ArrayList<SolrCmdDistributor.StdNode> nodes = null;
        for (Slice aslice : allSlices) {
            Replica sliceLeader;
            boolean isSubset;
            if (!Slice.CONSTRUCTION.equals(aslice.getState())) continue;
            DocRouter.Range myRange = coll.getSlice(shardId).getRange();
            if (myRange == null) {
                myRange = new DocRouter.Range(Integer.MIN_VALUE, Integer.MAX_VALUE);
            }
            if (!(isSubset = aslice.getRange() != null && aslice.getRange().isSubsetOf(myRange)) || docId != null && (docId == null || !coll.getRouter().isTargetSlice(docId, doc, this.req.getParams(), aslice.getName(), coll)) || (sliceLeader = aslice.getLeader()) == null || !this.zkController.getClusterState().liveNodesContain(sliceLeader.getNodeName())) continue;
            if (nodes == null) {
                nodes = new ArrayList<SolrCmdDistributor.StdNode>();
            }
            ZkCoreNodeProps nodeProps = new ZkCoreNodeProps((ZkNodeProps)sliceLeader);
            nodes.add(new SolrCmdDistributor.StdNode(nodeProps));
        }
        return nodes;
    }

    private void doDefensiveChecks(DistribPhase phase) {
        boolean isReplayOrPeersync;
        boolean bl = isReplayOrPeersync = (this.updateCommand.getFlags() & (UpdateCommand.REPLAY | UpdateCommand.PEER_SYNC)) != 0;
        if (isReplayOrPeersync) {
            return;
        }
        String from = this.req.getParams().get("distrib.from");
        ClusterState clusterState = this.zkController.getClusterState();
        CloudDescriptor cloudDescriptor = this.req.getCore().getCoreDescriptor().getCloudDescriptor();
        Slice mySlice = clusterState.getSlice(this.collection, cloudDescriptor.getShardId());
        boolean localIsLeader = cloudDescriptor.isLeader();
        if (DistribPhase.FROMLEADER == phase && localIsLeader && from != null) {
            String fromShard = this.req.getParams().get("distrib.from.parent");
            if (fromShard != null) {
                if (!Slice.CONSTRUCTION.equals(mySlice.getState())) {
                    throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "Request says it is coming from parent shard leader but we are not in construction state");
                }
                Slice fromSlice = this.zkController.getClusterState().getCollection(this.collection).getSlice(fromShard);
                DocRouter.Range parentRange = fromSlice.getRange();
                if (parentRange == null) {
                    parentRange = new DocRouter.Range(Integer.MIN_VALUE, Integer.MAX_VALUE);
                }
                if (mySlice.getRange() != null && !mySlice.getRange().isSubsetOf(parentRange)) {
                    throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "Request says it is coming from parent shard leader but parent hash range is not superset of my range");
                }
            } else {
                log.error("Request says it is coming from leader, but we are the leader: " + this.req.getParamString());
                throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "Request says it is coming from leader, but we are the leader");
            }
        }
        if (this.isLeader && !localIsLeader || this.isSubShardLeader && !localIsLeader) {
            log.error("ClusterState says we are the leader, but locally we don't think so");
            throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "ClusterState says we are the leader (" + this.zkController.getBaseUrl() + "/" + this.req.getCore().getName() + "), but locally we don't think so. Request came from " + from);
        }
    }

    private List<SolrCmdDistributor.Node> setupRequest() {
        ArrayList<SolrCmdDistributor.StdNode> nodes = null;
        String shardId = this.cloudDesc.getShardId();
        try {
            Replica leaderReplica = this.zkController.getZkStateReader().getLeaderRetry(this.collection, shardId);
            this.isLeader = leaderReplica.getName().equals(this.req.getCore().getCoreDescriptor().getCloudDescriptor().getCoreNodeName());
            this.forwardToLeader = false;
            List replicaProps = this.zkController.getZkStateReader().getReplicaProps(this.collection, shardId, leaderReplica.getName(), this.req.getCore().getName());
            if (replicaProps != null) {
                nodes = new ArrayList<SolrCmdDistributor.StdNode>(replicaProps.size());
                for (ZkCoreNodeProps props : replicaProps) {
                    nodes.add(new SolrCmdDistributor.StdNode(props));
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
        }
        return nodes;
    }

    @Override
    public void processAdd(AddUpdateCommand cmd) throws IOException {
        DocCollection coll;
        List<SolrCmdDistributor.Node> subShardLeaders;
        this.updateCommand = cmd;
        if (this.zkEnabled) {
            this.zkCheck();
            this.nodes = this.setupRequest(cmd.getHashableId(), cmd.getSolrInputDocument());
        } else {
            this.isLeader = DistributedUpdateProcessor.getNonZkLeaderAssumption(this.req);
        }
        boolean dropCmd = false;
        if (!this.forwardToLeader) {
            dropCmd = this.versionAdd(cmd);
        }
        if (dropCmd) {
            return;
        }
        if (this.zkEnabled && this.isLeader && !this.isSubShardLeader && (subShardLeaders = this.getSubShardLeaders(coll = this.zkController.getClusterState().getCollection(this.collection), this.cloudDesc.getShardId(), cmd.getHashableId(), cmd.getSolrInputDocument())) != null && !subShardLeaders.isEmpty()) {
            ModifiableSolrParams params = new ModifiableSolrParams((SolrParams)this.filterParams(this.req.getParams()));
            params.set("update.distrib", new String[]{DistribPhase.FROMLEADER.toString()});
            params.set("distrib.from", new String[]{ZkCoreNodeProps.getCoreUrl((String)this.zkController.getBaseUrl(), (String)this.req.getCore().getName())});
            params.set("distrib.from.parent", new String[]{this.req.getCore().getCoreDescriptor().getCloudDescriptor().getShardId()});
            for (SolrCmdDistributor.Node subShardLeader : subShardLeaders) {
                this.cmdDistrib.syncAdd(cmd, subShardLeader, params);
            }
        }
        ModifiableSolrParams params = null;
        if (this.nodes != null) {
            params = new ModifiableSolrParams((SolrParams)this.filterParams(this.req.getParams()));
            params.set("update.distrib", new String[]{this.isLeader || this.isSubShardLeader ? DistribPhase.FROMLEADER.toString() : DistribPhase.TOLEADER.toString()});
            if (this.isLeader || this.isSubShardLeader) {
                params.set("distrib.from", new String[]{ZkCoreNodeProps.getCoreUrl((String)this.zkController.getBaseUrl(), (String)this.req.getCore().getName())});
            }
            params.set("distrib.from", new String[]{ZkCoreNodeProps.getCoreUrl((String)this.zkController.getBaseUrl(), (String)this.req.getCore().getName())});
            this.cmdDistrib.distribAdd(cmd, this.nodes, params);
        }
        if (this.returnVersions && this.rsp != null && this.idField != null) {
            if (this.addsResponse == null) {
                this.addsResponse = new NamedList();
                this.rsp.add("adds", this.addsResponse);
            }
            if (this.scratch == null) {
                this.scratch = new CharsRef();
            }
            this.idField.getType().indexedToReadable(cmd.getIndexedId(), this.scratch);
            this.addsResponse.add(this.scratch.toString(), (Object)cmd.getVersion());
        }
    }

    private void doFinish() {
        this.cmdDistrib.finish();
        SolrCmdDistributor.Response response = this.cmdDistrib.getResponse();
        if (response.errors.size() > 0 && response.errors.get((int)0).node instanceof RetryNode) {
            this.rsp.setException(response.errors.get((int)0).e);
        }
        for (SolrCmdDistributor.Error error : response.errors) {
            if (error.node instanceof RetryNode) continue;
            String recoveryUrl = error.node.getBaseUrl();
            log.info("try and ask " + recoveryUrl + " to recover");
            try {
                HttpSolrServer server = new HttpSolrServer(recoveryUrl);
                server.setSoTimeout(15000);
                server.setConnectionTimeout(15000);
                CoreAdminRequest.RequestRecovery recoverRequestCmd = new CoreAdminRequest.RequestRecovery();
                recoverRequestCmd.setAction(CoreAdminParams.CoreAdminAction.REQUESTRECOVERY);
                recoverRequestCmd.setCoreName(error.node.getCoreName());
                server.request((SolrRequest)recoverRequestCmd);
            }
            catch (Exception e) {
                log.info("Could not tell a replica to recover", (Throwable)e);
            }
        }
    }

    private void doLocalAdd(AddUpdateCommand cmd) throws IOException {
        super.processAdd(cmd);
    }

    private void doLocalDelete(DeleteUpdateCommand cmd) throws IOException {
        super.processDelete(cmd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean versionAdd(AddUpdateCommand cmd) throws IOException {
        idBytes = cmd.getIndexedId();
        if (idBytes == null) {
            super.processAdd(cmd);
            return false;
        }
        if (this.vinfo == null) {
            if (DistributedUpdateProcessor.isAtomicUpdate(cmd)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Atomic document updates are not supported unless <updateLog/> is configured");
            }
            super.processAdd(cmd);
            return false;
        }
        bucketHash = Hash.murmurhash3_x86_32((byte[])idBytes.bytes, (int)idBytes.offset, (int)idBytes.length, (int)0);
        versionOnUpdate = cmd.getVersion();
        if (versionOnUpdate == 0L) {
            versionField = cmd.getSolrInputDocument().getField("_version_");
            versionOnUpdate = versionField != null ? ((o = versionField.getValue()) instanceof Number != false ? ((Number)o).longValue() : Long.parseLong(o.toString())) : ((versionOnUpdateS = this.req.getParams().get("_version_")) == null ? 0L : Long.parseLong(versionOnUpdateS));
        }
        isReplayOrPeersync = (cmd.getFlags() & (UpdateCommand.REPLAY | UpdateCommand.PEER_SYNC)) != 0;
        leaderLogic = this.isLeader != false && isReplayOrPeersync == false;
        bucket = this.vinfo.bucket(bucketHash);
        this.vinfo.lockForUpdate();
        var9_10 = bucket;
        synchronized (var9_10) {
            checkDeleteByQueries = false;
            if (!this.versionsStored) break block19;
            bucketVersion = bucket.highest;
            if (leaderLogic) {
                updated = this.getUpdatedDocument(cmd, versionOnUpdate);
                if (versionOnUpdate != 0L) {
                    lastVersion = this.vinfo.lookupVersion(cmd.getIndexedId());
                    v0 = foundVersion = lastVersion == null ? -1L : lastVersion;
                    if (versionOnUpdate != foundVersion && (versionOnUpdate >= 0L || foundVersion >= 0L)) {
                        if (versionOnUpdate != 1L) throw new SolrException(SolrException.ErrorCode.CONFLICT, "version conflict for " + cmd.getPrintableId() + " expected=" + versionOnUpdate + " actual=" + foundVersion);
                        if (foundVersion <= 0L) throw new SolrException(SolrException.ErrorCode.CONFLICT, "version conflict for " + cmd.getPrintableId() + " expected=" + versionOnUpdate + " actual=" + foundVersion);
                    }
                }
                version = this.vinfo.getNewClock();
                cmd.setVersion(version);
                cmd.getSolrInputDocument().setField("_version_", (Object)version);
                bucket.updateHighest(version);
                break block19;
            }
            cmd.setVersion(versionOnUpdate);
            if (this.ulog.getState() != UpdateLog.State.ACTIVE && (cmd.getFlags() & UpdateCommand.REPLAY) == 0) {
                cmd.setFlags(cmd.getFlags() | UpdateCommand.BUFFERING);
                this.ulog.add(cmd);
                updated = true;
                // MONITOREXIT @DISABLED, blocks:[0, 5, 10] lbl43 : MonitorExitStatement: MONITOREXIT : var9_10
                this.vinfo.unlockForUpdate();
                return updated;
            }
            if (bucketVersion != 0L && bucketVersion < versionOnUpdate) {
                bucket.updateHighest(versionOnUpdate);
                break block19;
            }
            lastVersion = this.vinfo.lookupVersion(cmd.getIndexedId());
            if (lastVersion == null) break block20;
        }
        {
            block19: {
                block20: {
                    if (Math.abs(lastVersion) >= versionOnUpdate) {
                        var14_19 = true;
                        // MONITOREXIT @DISABLED, blocks:[5, 9] lbl56 : MonitorExitStatement: MONITOREXIT : var9_10
                        this.vinfo.unlockForUpdate();
                        return var14_19;
                    }
                }
                ** try [egrp 3[TRYBLOCK] [6 : 570->653)] { 
lbl61:
                // 1 sources

                checkDeleteByQueries = true;
            }
            willDistrib = this.isLeader != false && this.nodes != null && this.nodes.size() > 0;
            clonedDoc = null;
            if (willDistrib) {
                clonedDoc = cmd.solrDoc.deepCopy();
            }
            this.doLocalAdd(cmd);
            if (willDistrib == false) return false;
            cmd.solrDoc = clonedDoc;
            return false;
lbl71:
            // 1 sources

            finally {
                this.vinfo.unlockForUpdate();
            }
        }
    }

    public static boolean isAtomicUpdate(AddUpdateCommand cmd) {
        SolrInputDocument sdoc = cmd.getSolrInputDocument();
        for (SolrInputField sif : sdoc.values()) {
            if (!(sif.getValue() instanceof Map)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean getUpdatedDocument(AddUpdateCommand cmd, long versionOnUpdate) throws IOException {
        if (!DistributedUpdateProcessor.isAtomicUpdate(cmd)) {
            return false;
        }
        SolrInputDocument sdoc = cmd.getSolrInputDocument();
        BytesRef id = cmd.getIndexedId();
        SolrInputDocument oldDoc = RealTimeGetComponent.getInputDocument(cmd.getReq().getCore(), id);
        if (oldDoc == null) {
            if (versionOnUpdate > 0L) throw new SolrException(SolrException.ErrorCode.CONFLICT, "Document not found for update.  id=" + cmd.getPrintableId());
            oldDoc = new SolrInputDocument();
        } else {
            oldDoc.remove((Object)VERSION_FIELD);
        }
        IndexSchema schema = cmd.getReq().getSchema();
        for (SolrInputField sif : sdoc.values()) {
            Object val = sif.getValue();
            if (val instanceof Map) {
                for (Map.Entry entry : ((Map)val).entrySet()) {
                    String key = (String)entry.getKey();
                    Object fieldVal = entry.getValue();
                    boolean updateField = false;
                    if ("add".equals(key)) {
                        updateField = true;
                        oldDoc.addField(sif.getName(), fieldVal, sif.getBoost());
                    } else if ("set".equals(key)) {
                        updateField = true;
                        oldDoc.setField(sif.getName(), fieldVal, sif.getBoost());
                    } else if ("inc".equals(key)) {
                        updateField = true;
                        SolrInputField numericField = oldDoc.get((Object)sif.getName());
                        if (numericField == null) {
                            oldDoc.setField(sif.getName(), fieldVal, sif.getBoost());
                        } else {
                            void var22_21;
                            String oldValS = numericField.getFirstValue().toString();
                            SchemaField sf = schema.getField(sif.getName());
                            BytesRef term = new BytesRef();
                            sf.getType().readableToIndexed(oldValS, term);
                            Object oldVal = sf.getType().toObject(sf, term);
                            String fieldValS = fieldVal.toString();
                            if (oldVal instanceof Long) {
                                Long l = (Long)oldVal + Long.parseLong(fieldValS);
                            } else if (oldVal instanceof Float) {
                                Float f = Float.valueOf(((Float)oldVal).floatValue() + Float.parseFloat(fieldValS));
                            } else if (oldVal instanceof Double) {
                                Double d = (Double)oldVal + Double.parseDouble(fieldValS);
                            } else {
                                Integer n = (Integer)oldVal + Integer.parseInt(fieldValS);
                            }
                            oldDoc.setField(sif.getName(), (Object)var22_21, sif.getBoost());
                        }
                    }
                    if (!updateField || !this.idField.getName().equals(sif.getName())) continue;
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid update of id field: " + sif);
                }
                continue;
            }
            oldDoc.put(sif.getName(), sif);
        }
        cmd.solrDoc = oldDoc;
        return true;
    }

    @Override
    public void processDelete(DeleteUpdateCommand cmd) throws IOException {
        DocCollection coll;
        List<SolrCmdDistributor.Node> subShardLeaders;
        this.updateCommand = cmd;
        if (!cmd.isDeleteById()) {
            this.doDeleteByQuery(cmd);
            return;
        }
        if (this.zkEnabled) {
            this.zkCheck();
            this.nodes = this.setupRequest(cmd.getId(), null);
        } else {
            this.isLeader = DistributedUpdateProcessor.getNonZkLeaderAssumption(this.req);
        }
        boolean dropCmd = false;
        if (!this.forwardToLeader) {
            dropCmd = this.versionDelete(cmd);
        }
        if (dropCmd) {
            return;
        }
        if (this.zkEnabled && this.isLeader && !this.isSubShardLeader && (subShardLeaders = this.getSubShardLeaders(coll = this.zkController.getClusterState().getCollection(this.collection), this.cloudDesc.getShardId(), null, null)) != null && !subShardLeaders.isEmpty()) {
            ModifiableSolrParams params = new ModifiableSolrParams((SolrParams)this.filterParams(this.req.getParams()));
            params.set("update.distrib", new String[]{DistribPhase.FROMLEADER.toString()});
            params.set("distrib.from", new String[]{ZkCoreNodeProps.getCoreUrl((String)this.zkController.getBaseUrl(), (String)this.req.getCore().getName())});
            params.set("distrib.from.parent", new String[]{this.cloudDesc.getShardId()});
            this.cmdDistrib.syncDelete(cmd, subShardLeaders, params);
        }
        ModifiableSolrParams params = null;
        if (this.nodes != null) {
            params = new ModifiableSolrParams((SolrParams)this.filterParams(this.req.getParams()));
            params.set("update.distrib", new String[]{this.isLeader || this.isSubShardLeader ? DistribPhase.FROMLEADER.toString() : DistribPhase.TOLEADER.toString()});
            if (this.isLeader || this.isSubShardLeader) {
                params.set("distrib.from", new String[]{ZkCoreNodeProps.getCoreUrl((String)this.zkController.getBaseUrl(), (String)this.req.getCore().getName())});
            }
            this.cmdDistrib.distribDelete(cmd, this.nodes, params);
        }
        if (this.returnVersions && this.rsp != null && cmd.getIndexedId() != null && this.idField != null) {
            if (this.deleteResponse == null) {
                this.deleteResponse = new NamedList();
                this.rsp.add("deletes", this.deleteResponse);
            }
            if (this.scratch == null) {
                this.scratch = new CharsRef();
            }
            this.idField.getType().indexedToReadable(cmd.getIndexedId(), this.scratch);
            this.deleteResponse.add(this.scratch.toString(), (Object)cmd.getVersion());
        }
    }

    private ModifiableSolrParams filterParams(SolrParams params) {
        ModifiableSolrParams fparams = new ModifiableSolrParams();
        this.passParam(params, fparams, "update.chain");
        this.passParam(params, fparams, TEST_DISTRIB_SKIP_SERVERS);
        return fparams;
    }

    private void passParam(SolrParams params, ModifiableSolrParams fparams, String param) {
        String[] values = params.getParams(param);
        if (values != null) {
            for (String value : values) {
                fparams.add(param, new String[]{value});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDeleteByQuery(DeleteUpdateCommand cmd) throws IOException {
        boolean leaderLogic;
        DocCollection coll;
        if (!this.zkEnabled) {
            this.isLeader = DistributedUpdateProcessor.getNonZkLeaderAssumption(this.req);
        } else {
            this.zkCheck();
        }
        DistribPhase phase = DistribPhase.parseParam(this.req.getParams().get("update.distrib"));
        DocCollection docCollection = coll = this.zkEnabled ? this.zkController.getClusterState().getCollection(this.collection) : null;
        if (this.zkEnabled && DistribPhase.NONE == phase) {
            boolean leaderForAnyShard = false;
            ModifiableSolrParams outParams = new ModifiableSolrParams((SolrParams)this.filterParams(this.req.getParams()));
            outParams.set("update.distrib", new String[]{DistribPhase.TOLEADER.toString()});
            SolrParams params = this.req.getParams();
            Collection slices = coll.getRouter().getSearchSlices(params.get("shard.keys"), params, coll);
            ArrayList<SolrCmdDistributor.Node> leaders = new ArrayList<SolrCmdDistributor.Node>(slices.size());
            for (Slice slice : slices) {
                Replica leader;
                String sliceName = slice.getName();
                try {
                    leader = this.zkController.getZkStateReader().getLeaderRetry(this.collection, sliceName);
                }
                catch (InterruptedException e) {
                    throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "Exception finding leader for shard " + sliceName, (Throwable)e);
                }
                ZkCoreNodeProps coreLeaderProps = new ZkCoreNodeProps((ZkNodeProps)leader);
                String leaderCoreNodeName = leader.getName();
                String coreNodeName = this.req.getCore().getCoreDescriptor().getCloudDescriptor().getCoreNodeName();
                this.isLeader = coreNodeName.equals(leaderCoreNodeName);
                if (this.isLeader) {
                    leaderForAnyShard = true;
                    continue;
                }
                leaders.add(new SolrCmdDistributor.StdNode(coreLeaderProps));
            }
            outParams.remove("commit");
            this.cmdDistrib.distribDelete(cmd, leaders, outParams);
            if (!leaderForAnyShard) {
                return;
            }
            phase = DistribPhase.TOLEADER;
        }
        List<SolrCmdDistributor.Node> replicas = null;
        if (this.zkEnabled && DistribPhase.TOLEADER == phase) {
            this.isLeader = true;
            replicas = this.setupRequest();
        } else if (DistribPhase.FROMLEADER == phase) {
            this.isLeader = false;
        }
        if (this.vinfo == null) {
            super.processDelete(cmd);
            return;
        }
        long versionOnUpdate = cmd.getVersion();
        if (versionOnUpdate == 0L) {
            String versionOnUpdateS = this.req.getParams().get(VERSION_FIELD);
            versionOnUpdate = versionOnUpdateS == null ? 0L : Long.parseLong(versionOnUpdateS);
        }
        versionOnUpdate = Math.abs(versionOnUpdate);
        boolean isReplayOrPeersync = (cmd.getFlags() & (UpdateCommand.REPLAY | UpdateCommand.PEER_SYNC)) != 0;
        boolean bl = leaderLogic = this.isLeader && !isReplayOrPeersync;
        if (!leaderLogic && versionOnUpdate == 0L) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "missing _version_ on update from leader");
        }
        this.vinfo.blockUpdates();
        try {
            if (this.versionsStored) {
                if (leaderLogic) {
                    long version = this.vinfo.getNewClock();
                    cmd.setVersion(-version);
                    this.doLocalDelete(cmd);
                } else {
                    cmd.setVersion(-versionOnUpdate);
                    if (this.ulog.getState() != UpdateLog.State.ACTIVE && (cmd.getFlags() & UpdateCommand.REPLAY) == 0) {
                        cmd.setFlags(cmd.getFlags() | UpdateCommand.BUFFERING);
                        this.ulog.deleteByQuery(cmd);
                        return;
                    }
                    this.doLocalDelete(cmd);
                }
            }
        }
        finally {
            this.vinfo.unblockUpdates();
        }
        if (this.zkEnabled) {
            ModifiableSolrParams params = new ModifiableSolrParams((SolrParams)this.filterParams(this.req.getParams()));
            params.set(VERSION_FIELD, new String[]{Long.toString(cmd.getVersion())});
            params.set("update.distrib", new String[]{DistribPhase.FROMLEADER.toString()});
            params.set("update.from", new String[]{ZkCoreNodeProps.getCoreUrl((String)this.zkController.getBaseUrl(), (String)this.req.getCore().getName())});
            boolean someReplicas = false;
            boolean subShardLeader = false;
            try {
                subShardLeader = this.amISubShardLeader(coll, null, null, null);
                if (subShardLeader) {
                    String myShardId = this.req.getCore().getCoreDescriptor().getCloudDescriptor().getShardId();
                    Replica leaderReplica = this.zkController.getZkStateReader().getLeaderRetry(this.collection, myShardId);
                    List replicaProps = this.zkController.getZkStateReader().getReplicaProps(this.collection, myShardId, leaderReplica.getName(), this.req.getCore().getName(), null, "down");
                    if (replicaProps != null) {
                        ArrayList<SolrCmdDistributor.Node> myReplicas = new ArrayList<SolrCmdDistributor.Node>();
                        for (ZkCoreNodeProps replicaProp : replicaProps) {
                            myReplicas.add(new SolrCmdDistributor.StdNode(replicaProp));
                        }
                        this.cmdDistrib.distribDelete(cmd, myReplicas, params);
                        someReplicas = true;
                    }
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
            }
            if (leaderLogic) {
                List<SolrCmdDistributor.Node> subShardLeaders = this.getSubShardLeaders(coll, this.cloudDesc.getShardId(), null, null);
                if (subShardLeaders != null) {
                    this.cmdDistrib.syncDelete(cmd, subShardLeaders, params);
                }
                if (replicas != null) {
                    this.cmdDistrib.distribDelete(cmd, replicas, params);
                    someReplicas = true;
                }
            }
            if (someReplicas) {
                this.cmdDistrib.finish();
            }
        }
        if (this.returnVersions && this.rsp != null) {
            if (this.deleteByQueryResponse == null) {
                this.deleteByQueryResponse = new NamedList();
                this.rsp.add("deleteByQuery", this.deleteByQueryResponse);
            }
            this.deleteByQueryResponse.add(cmd.getQuery(), (Object)cmd.getVersion());
        }
    }

    private void zkCheck() {
        if ((this.updateCommand.getFlags() & (UpdateCommand.REPLAY | UpdateCommand.PEER_SYNC)) != 0) {
            return;
        }
        if (this.zkController.isConnected()) {
            return;
        }
        long timeoutAt = System.currentTimeMillis() + (long)this.zkController.getClientTimeout();
        while (System.currentTimeMillis() < timeoutAt) {
            if (this.zkController.isConnected()) {
                return;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
        }
        throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "Cannot talk to ZooKeeper - Updates are disabled.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean versionDelete(DeleteUpdateCommand cmd) throws IOException {
        boolean bl;
        Long lastVersion;
        boolean leaderLogic;
        BytesRef idBytes = cmd.getIndexedId();
        if (this.vinfo == null || idBytes == null) {
            super.processDelete(cmd);
            return false;
        }
        int bucketHash = Hash.murmurhash3_x86_32((byte[])idBytes.bytes, (int)idBytes.offset, (int)idBytes.length, (int)0);
        long versionOnUpdate = cmd.getVersion();
        if (versionOnUpdate == 0L) {
            String versionOnUpdateS = this.req.getParams().get(VERSION_FIELD);
            versionOnUpdate = versionOnUpdateS == null ? 0L : Long.parseLong(versionOnUpdateS);
        }
        long signedVersionOnUpdate = versionOnUpdate;
        versionOnUpdate = Math.abs(versionOnUpdate);
        boolean isReplayOrPeersync = (cmd.getFlags() & (UpdateCommand.REPLAY | UpdateCommand.PEER_SYNC)) != 0;
        boolean bl2 = leaderLogic = this.isLeader && !isReplayOrPeersync;
        if (!leaderLogic && versionOnUpdate == 0L) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "missing _version_ on update from leader");
        }
        VersionBucket bucket = this.vinfo.bucket(bucketHash);
        this.vinfo.lockForUpdate();
        try {
            VersionBucket versionBucket = bucket;
            synchronized (versionBucket) {
                if (!this.versionsStored) break block16;
                long bucketVersion = bucket.highest;
                if (leaderLogic) {
                    if (signedVersionOnUpdate != 0L) {
                        long foundVersion;
                        Long lastVersion2 = this.vinfo.lookupVersion(cmd.getIndexedId());
                        long l = foundVersion = lastVersion2 == null ? -1L : lastVersion2;
                        if (!(signedVersionOnUpdate == foundVersion || signedVersionOnUpdate < 0L && foundVersion < 0L || signedVersionOnUpdate == 1L && foundVersion > 0L)) {
                            throw new SolrException(SolrException.ErrorCode.CONFLICT, "version conflict for " + cmd.getId() + " expected=" + signedVersionOnUpdate + " actual=" + foundVersion);
                        }
                    }
                    long version = this.vinfo.getNewClock();
                    cmd.setVersion(-version);
                    bucket.updateHighest(version);
                    break block16;
                }
                cmd.setVersion(-versionOnUpdate);
                if (this.ulog.getState() != UpdateLog.State.ACTIVE && (cmd.getFlags() & UpdateCommand.REPLAY) == 0) {
                    cmd.setFlags(cmd.getFlags() | UpdateCommand.BUFFERING);
                    this.ulog.delete(cmd);
                    boolean version = true;
                    // MONITOREXIT @DISABLED, blocks:[0, 5, 8] lbl38 : MonitorExitStatement: MONITOREXIT : var11_10
                    this.vinfo.unlockForUpdate();
                    return version;
                }
                if (bucketVersion != 0L && bucketVersion < versionOnUpdate) {
                    bucket.updateHighest(versionOnUpdate);
                    break block16;
                }
                lastVersion = this.vinfo.lookupVersion(cmd.getIndexedId());
                if (lastVersion == null) break block16;
            }
        }
        catch (Throwable throwable) {
            this.vinfo.unlockForUpdate();
            throw throwable;
        }
        {
            block16: {
                if (Math.abs(lastVersion) >= versionOnUpdate) {
                    boolean bl3 = true;
                    // MONITOREXIT @DISABLED, blocks:[5, 7] lbl52 : MonitorExitStatement: MONITOREXIT : var11_10
                    this.vinfo.unlockForUpdate();
                    return bl3;
                }
            }
            this.doLocalDelete(cmd);
            bl = false;
        }
        this.vinfo.unlockForUpdate();
        return bl;
    }

    @Override
    public void processCommit(CommitUpdateCommand cmd) throws IOException {
        this.updateCommand = cmd;
        List<SolrCmdDistributor.Node> nodes = null;
        boolean singleLeader = false;
        if (this.zkEnabled) {
            this.zkCheck();
            nodes = this.getCollectionUrls(this.req, this.req.getCore().getCoreDescriptor().getCloudDescriptor().getCollectionName());
            if (this.isLeader && nodes.size() == 1) {
                singleLeader = true;
            }
        }
        if (!this.zkEnabled || this.req.getParams().getBool(COMMIT_END_POINT, false) || singleLeader) {
            this.doLocalCommit(cmd);
        } else if (this.zkEnabled) {
            ModifiableSolrParams params = new ModifiableSolrParams((SolrParams)this.filterParams(this.req.getParams()));
            if (!this.req.getParams().getBool(COMMIT_END_POINT, false)) {
                params.set(COMMIT_END_POINT, true);
                if (nodes != null) {
                    this.cmdDistrib.distribCommit(cmd, nodes, params);
                    this.finish();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doLocalCommit(CommitUpdateCommand cmd) throws IOException {
        if (this.vinfo != null) {
            this.vinfo.lockForUpdate();
        }
        try {
            if (this.ulog == null || this.ulog.getState() == UpdateLog.State.ACTIVE || (cmd.getFlags() & UpdateCommand.REPLAY) != 0) {
                super.processCommit(cmd);
            } else {
                log.info("Ignoring commit while not ACTIVE - state: " + (Object)((Object)this.ulog.getState()) + " replay:" + (cmd.getFlags() & UpdateCommand.REPLAY));
            }
        }
        finally {
            if (this.vinfo != null) {
                this.vinfo.unlockForUpdate();
            }
        }
    }

    @Override
    public void finish() throws IOException {
        if (this.zkEnabled) {
            this.doFinish();
        }
        if (this.next != null && this.nodes == null) {
            this.next.finish();
        }
    }

    private List<SolrCmdDistributor.Node> getCollectionUrls(SolrQueryRequest req, String collection) {
        ClusterState clusterState = req.getCore().getCoreDescriptor().getCoreContainer().getZkController().getClusterState();
        ArrayList<SolrCmdDistributor.Node> urls = new ArrayList<SolrCmdDistributor.Node>();
        Map slices = clusterState.getSlicesMap(collection);
        if (slices == null) {
            throw new ZooKeeperException(SolrException.ErrorCode.BAD_REQUEST, "Could not find collection in zk: " + clusterState);
        }
        for (Map.Entry sliceEntry : slices.entrySet()) {
            Slice replicas = (Slice)slices.get(sliceEntry.getKey());
            Map shardMap = replicas.getReplicasMap();
            for (Map.Entry entry : shardMap.entrySet()) {
                ZkCoreNodeProps nodeProps = new ZkCoreNodeProps((ZkNodeProps)entry.getValue());
                if (!clusterState.liveNodesContain(nodeProps.getNodeName())) continue;
                urls.add(new SolrCmdDistributor.StdNode(nodeProps));
            }
        }
        if (urls.size() == 0) {
            return null;
        }
        return urls;
    }

    public static boolean getNonZkLeaderAssumption(SolrQueryRequest req) {
        DistribPhase phase = DistribPhase.parseParam(req.getParams().get("update.distrib"));
        return DistribPhase.FROMLEADER != phase;
    }

    public static class RetryNode
    extends SolrCmdDistributor.StdNode {
        private ZkStateReader zkStateReader;
        private String collection;
        private String shardId;

        public RetryNode(ZkCoreNodeProps nodeProps, ZkStateReader zkStateReader, String collection, String shardId) {
            super(nodeProps);
            this.zkStateReader = zkStateReader;
            this.collection = collection;
            this.shardId = shardId;
        }

        @Override
        public boolean checkRetry() {
            ZkCoreNodeProps leaderProps;
            try {
                leaderProps = new ZkCoreNodeProps((ZkNodeProps)this.zkStateReader.getLeaderRetry(this.collection, this.shardId));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
            this.nodeProps = leaderProps;
            return true;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.collection == null ? 0 : this.collection.hashCode());
            result = 31 * result + (this.shardId == null ? 0 : this.shardId.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RetryNode other = (RetryNode)obj;
            return !(this.nodeProps.getCoreUrl() == null ? other.nodeProps.getCoreUrl() != null : !this.nodeProps.getCoreUrl().equals(other.nodeProps.getCoreUrl()));
        }
    }

    public static enum DistribPhase {
        NONE,
        TOLEADER,
        FROMLEADER;


        public static DistribPhase parseParam(String param) {
            if (param == null || param.trim().isEmpty()) {
                return NONE;
            }
            try {
                return DistribPhase.valueOf(param);
            }
            catch (IllegalArgumentException e) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Illegal value for update.distrib: " + param, (Throwable)e);
            }
        }
    }
}

