/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.fess.solr.plugin.analysis;

import com.ibm.icu.text.Transliterator;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import jp.sf.fess.suggest.converter.SuggestConverter;
import org.apache.commons.io.IOUtils;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.ja.JapaneseTokenizer;
import org.apache.lucene.analysis.ja.dict.UserDictionary;
import org.apache.lucene.analysis.ja.tokenattributes.ReadingAttribute;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SuggestStringTokenizer
extends Tokenizer {
    private static final Logger logger = LoggerFactory.getLogger(SuggestStringTokenizer.class);
    private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private int offset = 0;
    private final List<String> termListByKuromoji = new ArrayList<String>();
    private final List<String> readingList = new ArrayList<String>();
    private String[] titleArray = null;
    private final UserDictionary userDictionary;
    private final boolean discardPunctuation;
    private final JapaneseTokenizer.Mode tokenizerMode;
    private final String wordSeparator;
    private final List<SuggestConverter> preConverterList;
    private final List<SuggestConverter> converterList;

    public SuggestStringTokenizer(Reader input, int bufferSize, UserDictionary userDictionaryPara, boolean discardPunctuationPara, JapaneseTokenizer.Mode modePara, List<SuggestConverter> preconverterList, List<SuggestConverter> converterList, String wordSeparator) {
        super(input);
        this.userDictionary = userDictionaryPara;
        this.discardPunctuation = discardPunctuationPara;
        this.tokenizerMode = modePara;
        this.termAtt.resizeBuffer(bufferSize);
        this.wordSeparator = wordSeparator;
        this.preConverterList = preconverterList;
        this.converterList = converterList;
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() {
        this.termListByKuromoji.clear();
        this.readingList.clear();
        this.titleArray = null;
        this.offset = 0;
        String inputStr = "";
        try {
            String s = IOUtils.toString((Reader)this.input);
            if (s != null && s.length() > 0) {
                inputStr = s;
                for (SuggestConverter converter : this.preConverterList) {
                    inputStr = converter.convert(inputStr);
                }
                this.titleArray = inputStr.split("\\$\\{and\\}");
                inputStr = inputStr.replace("${and}", " ");
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        StringReader rd = new StringReader(inputStr);
        JapaneseTokenizer stream = null;
        try {
            stream = new JapaneseTokenizer((Reader)rd, this.userDictionary, this.discardPunctuation, this.tokenizerMode);
            stream.reset();
            while (stream.incrementToken()) {
                CharTermAttribute att = (CharTermAttribute)stream.getAttribute(CharTermAttribute.class);
                this.termListByKuromoji.add(att.toString());
                ReadingAttribute rdAttr = (ReadingAttribute)stream.getAttribute(ReadingAttribute.class);
                String reading = rdAttr.getReading() != null ? rdAttr.getReading() : att.toString();
                for (SuggestConverter converter : this.converterList) {
                    reading = converter.convert(reading);
                }
                this.readingList.add(reading);
            }
        }
        catch (Exception e) {
            logger.warn("JapaneseTokenizer stream error", (Throwable)e);
        }
        finally {
            try {
                this.input.reset();
            }
            catch (Exception e) {}
            try {
                stream.end();
            }
            catch (Exception e) {}
            try {
                ((Reader)rd).close();
            }
            catch (Exception e) {}
        }
    }

    public boolean incrementToken() throws IOException {
        if (this.titleArray == null || this.offset >= this.titleArray.length) {
            return false;
        }
        this.termAtt.setEmpty();
        this.termAtt.append(this.convertSuggestString(this.titleArray[this.offset], this.getReading(this.titleArray[this.offset])));
        ++this.offset;
        return true;
    }

    public void reset() throws IOException {
        super.reset();
        this.initialize();
    }

    private String convertSuggestString(String term, String reading) {
        String suggestString = reading != null && reading.length() > 0 ? reading + this.wordSeparator + term : term;
        return suggestString;
    }

    private String getReading(String s) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            String term = "";
            int length = 0;
            for (int j = 0; j < this.termListByKuromoji.size(); ++j) {
                String tmpStr = this.termListByKuromoji.get(j);
                if (s.substring(i).indexOf(tmpStr) != 0 || tmpStr.length() <= term.length()) continue;
                term = this.readingList.get(j);
                length = tmpStr.length();
            }
            if (term.length() > 0) {
                buf.append(term);
                i += length - 1;
                continue;
            }
            char c = s.charAt(i);
            c = Transliterator.getInstance((String)"Hiragana-Katakana").transliterate(String.valueOf(c)).charAt(0);
            buf.append(c);
        }
        String reading = buf.toString();
        for (SuggestConverter converter : this.converterList) {
            reading = converter.convert(reading);
        }
        return reading;
    }
}

