/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.fess.solr.plugin.analysis;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import jp.sf.fess.solr.plugin.analysis.SuggestStringTokenizer;
import jp.sf.fess.solr.plugin.suggest.SuggestConverterCreator;
import jp.sf.fess.suggest.converter.SuggestConverter;
import org.apache.lucene.analysis.ja.JapaneseTokenizer;
import org.apache.lucene.analysis.ja.dict.UserDictionary;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.lucene.analysis.util.ResourceLoaderAware;
import org.apache.lucene.analysis.util.TokenizerFactory;
import org.apache.lucene.util.AttributeSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SuggestStringTokenizerFactory
extends TokenizerFactory
implements ResourceLoaderAware {
    private static final Logger logger = LoggerFactory.getLogger(SuggestStringTokenizerFactory.class);
    private static final String MODE = "mode";
    private static final String USER_DICT_PATH = "userDictionary";
    private static final String USER_DICT_ENCODING = "userDictionaryEncoding";
    private static final String BUFFER_SIZE = "bufferSize";
    private static final String WORD_SEPARATOR = "wordSeparator";
    private static final String DISCARD_PUNCTUATION = "discardPunctuation";
    private UserDictionary userDictionary;
    private final JapaneseTokenizer.Mode mode;
    private final String userDictionaryPath;
    private final String userDictionaryEncoding;
    private final boolean discardPunctuation;
    private final int bufferSize;
    private String wordSeparator;
    private final List<SuggestConverter> preConverterList;
    private final List<SuggestConverter> converterList;

    public SuggestStringTokenizerFactory(Map<String, String> args) {
        super(args);
        this.mode = this.getMode(args);
        this.userDictionaryPath = args.get(USER_DICT_PATH);
        this.userDictionaryEncoding = args.get(USER_DICT_ENCODING);
        this.bufferSize = this.getInt(args, BUFFER_SIZE, 256);
        this.discardPunctuation = this.getBoolean(args, DISCARD_PUNCTUATION, true);
        this.wordSeparator = args.get(WORD_SEPARATOR);
        if (this.wordSeparator == null) {
            this.wordSeparator = "_SP_";
        }
        this.preConverterList = SuggestConverterCreator.create(args.get("preConverters"));
        this.converterList = SuggestConverterCreator.create(args.get("converters"));
    }

    public void inform(ResourceLoader loader) {
        try {
            if (this.userDictionaryPath != null) {
                InputStream stream = loader.openResource(this.userDictionaryPath);
                String encoding = this.userDictionaryEncoding;
                if (encoding == null) {
                    encoding = "UTF-8";
                }
                CharsetDecoder decoder = Charset.forName(encoding).newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
                InputStreamReader reader = new InputStreamReader(stream, decoder);
                this.userDictionary = new UserDictionary((Reader)reader);
            } else {
                this.userDictionary = null;
            }
        }
        catch (Exception e) {
            logger.warn("Initialization failed.", (Throwable)e);
        }
    }

    public SuggestStringTokenizer create(AttributeSource.AttributeFactory factory, Reader input) {
        return new SuggestStringTokenizer(input, this.bufferSize, this.userDictionary, this.discardPunctuation, this.mode, this.preConverterList, this.converterList, this.wordSeparator);
    }

    private JapaneseTokenizer.Mode getMode(Map<String, String> args) {
        String modeArg = args.get(MODE);
        if (modeArg != null) {
            return JapaneseTokenizer.Mode.valueOf((String)modeArg.toUpperCase(Locale.ROOT));
        }
        return JapaneseTokenizer.Mode.NORMAL;
    }
}

