/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.fess.solr.plugin.analysis;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import jp.sf.fess.solr.plugin.analysis.SuggestTextTokenizer;
import jp.sf.fess.solr.plugin.suggest.SuggestConverterCreator;
import jp.sf.fess.suggest.converter.SuggestConverter;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.ja.JapaneseTokenizer;
import org.apache.lucene.analysis.ja.dict.UserDictionary;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.lucene.analysis.util.ResourceLoaderAware;
import org.apache.lucene.analysis.util.TokenizerFactory;
import org.apache.lucene.util.AttributeSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SuggestTextTokenizerFactory
extends TokenizerFactory
implements ResourceLoaderAware {
    private static final Logger logger = LoggerFactory.getLogger(SuggestTextTokenizerFactory.class);
    private static final String MODE = "mode";
    private static final String USER_DICT_PATH = "userDictionary";
    private static final String USER_DICT_ENCODING = "userDictionaryEncoding";
    private static final String BUFFER_SIZE = "bufferSize";
    private static final String WORD_SEPARATOR = "wordSeparator";
    private static final String INCLUDE_CHAR_TERM = "includeCharTerm";
    private static final String EXCLUDE_PART_OF_SPEECH = "excludePartOfSpeech";
    private static final String INCLUDE_PART_OF_SPEECH = "includePartOfSpeech";
    private static final String DISCARD_PUNCTUATION = "discardPunctuation";
    private static final String MAX_LENGTH = "maxLength";
    private UserDictionary userDictionary;
    private final JapaneseTokenizer.Mode mode;
    private final String userDictionaryPath;
    private final String userDictionaryEncoding;
    private final boolean discardPunctuation;
    private final int bufferSize;
    private final String wordSeparator;
    private final SuggestTextTokenizer.TermChecker termChecker;
    private final List<SuggestConverter> preConverterList;
    private final List<SuggestConverter> converterList;
    private final int maxLength;

    public SuggestTextTokenizerFactory(Map<String, String> args) {
        super(args);
        String includeCharTerm;
        String excludePartOfSpeech;
        this.mode = this.getMode(args);
        this.userDictionaryPath = args.get(USER_DICT_PATH);
        this.userDictionaryEncoding = args.get(USER_DICT_ENCODING);
        this.bufferSize = this.getInt(args, BUFFER_SIZE, 256);
        this.wordSeparator = this.get(args, WORD_SEPARATOR, "_SP_");
        this.discardPunctuation = this.getBoolean(args, DISCARD_PUNCTUATION, true);
        this.maxLength = this.getInt(args, MAX_LENGTH, 0);
        this.termChecker = new SuggestTextTokenizer.TermChecker();
        String includePartOfSpeech = args.get(INCLUDE_PART_OF_SPEECH);
        if (includePartOfSpeech != null) {
            for (String text : includePartOfSpeech.split(",")) {
                String[] values;
                if ((text = text.trim()).length() <= 0 || (values = text.split(":")).length != 2) continue;
                this.termChecker.includePartOfSpeech(values[0].trim(), values[1].trim());
            }
        }
        if ((excludePartOfSpeech = args.get(EXCLUDE_PART_OF_SPEECH)) != null) {
            for (String text : excludePartOfSpeech.split(",")) {
                String[] values;
                if ((text = text.trim()).length() <= 0 || (values = text.split(":")).length != 2) continue;
                this.termChecker.excludePartOfSpeech(values[0].trim(), values[1].trim());
            }
        }
        if ((includeCharTerm = args.get(INCLUDE_CHAR_TERM)) != null) {
            for (String text : includeCharTerm.split(",")) {
                String[] values;
                if ((text = text.trim()).length() <= 0 || (values = text.split(":")).length != 2) continue;
                this.termChecker.includeCharTerm(values[0].trim(), values[1].trim());
            }
        }
        this.preConverterList = SuggestConverterCreator.create(args.get("preConverters"));
        this.converterList = SuggestConverterCreator.create(args.get("converters"));
    }

    public Tokenizer create(AttributeSource.AttributeFactory factory, Reader input) {
        return new SuggestTextTokenizer(input, this.bufferSize, this.userDictionary, this.discardPunctuation, this.mode, this.termChecker, this.preConverterList, this.converterList, this.wordSeparator, this.maxLength);
    }

    public void inform(ResourceLoader loader) {
        try {
            if (this.userDictionaryPath != null) {
                InputStream stream = loader.openResource(this.userDictionaryPath);
                String encoding = this.userDictionaryEncoding;
                if (encoding == null) {
                    encoding = "UTF-8";
                }
                CharsetDecoder decoder = Charset.forName(encoding).newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
                InputStreamReader reader = new InputStreamReader(stream, decoder);
                this.userDictionary = new UserDictionary((Reader)reader);
            } else {
                this.userDictionary = null;
            }
        }
        catch (Exception e) {
            logger.warn("Initialization failed.", (Throwable)e);
        }
    }

    private JapaneseTokenizer.Mode getMode(Map<String, String> args) {
        String modeArg = args.get(MODE);
        if (modeArg != null) {
            return JapaneseTokenizer.Mode.valueOf((String)modeArg.toUpperCase(Locale.ROOT));
        }
        return JapaneseTokenizer.Mode.NORMAL;
    }
}

