/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.util.beans.impl;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Map;
import org.seasar.util.beans.BeanDesc;
import org.seasar.util.beans.FieldDesc;
import org.seasar.util.beans.ParameterizedClassDesc;
import org.seasar.util.beans.factory.ParameterizedClassDescFactory;
import org.seasar.util.exception.FieldNotStaticRuntimeException;
import org.seasar.util.lang.FieldUtil;
import org.seasar.util.misc.AssertionUtil;

public class FieldDescImpl
implements FieldDesc {
    protected final BeanDesc beanDesc;
    protected final Field field;
    protected final String fieldName;
    protected final Class<?> fieldType;
    protected final ParameterizedClassDesc parameterizedClassDesc;

    public FieldDescImpl(BeanDesc beanDesc, Field field) {
        AssertionUtil.assertArgumentNotNull("beanDesc", beanDesc);
        AssertionUtil.assertArgumentNotNull("field", field);
        this.beanDesc = beanDesc;
        this.field = field;
        this.fieldName = field.getName();
        this.fieldType = field.getType();
        this.parameterizedClassDesc = ParameterizedClassDescFactory.createParameterizedClassDesc(field, beanDesc.getTypeVariables());
    }

    @Override
    public BeanDesc getBeanDesc() {
        return this.beanDesc;
    }

    @Override
    public Field getField() {
        return this.field;
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public <T> Class<T> getFieldType() {
        return this.fieldType;
    }

    @Override
    public boolean isPublic() {
        return FieldUtil.isPublicField(this.field);
    }

    @Override
    public boolean isStatic() {
        return !FieldUtil.isInstanceField(this.field);
    }

    @Override
    public boolean isFinal() {
        return FieldUtil.isFinalField(this.field);
    }

    @Override
    public boolean isParameterized() {
        return this.parameterizedClassDesc != null && this.parameterizedClassDesc.isParameterizedClass();
    }

    @Override
    public ParameterizedClassDesc getParameterizedClassDesc() {
        return this.parameterizedClassDesc;
    }

    @Override
    public Class<?> getElementClassOfCollection() {
        if (!Collection.class.isAssignableFrom(this.fieldType) || !this.isParameterized()) {
            return null;
        }
        ParameterizedClassDesc pcd = this.parameterizedClassDesc.getArguments()[0];
        if (pcd == null) {
            return null;
        }
        return pcd.getRawClass();
    }

    @Override
    public Class<?> getKeyClassOfMap() {
        if (!Map.class.isAssignableFrom(this.fieldType) || !this.isParameterized()) {
            return null;
        }
        ParameterizedClassDesc pcd = this.parameterizedClassDesc.getArguments()[0];
        if (pcd == null) {
            return null;
        }
        return pcd.getRawClass();
    }

    @Override
    public Class<?> getValueClassOfMap() {
        if (!Map.class.isAssignableFrom(this.fieldType) || !this.isParameterized()) {
            return null;
        }
        ParameterizedClassDesc pcd = this.parameterizedClassDesc.getArguments()[1];
        if (pcd == null) {
            return null;
        }
        return pcd.getRawClass();
    }

    @Override
    public <T> T getFieldValue(Object target) {
        AssertionUtil.assertArgumentNotNull("target", target);
        return FieldUtil.get(this.field, target);
    }

    @Override
    public <T> T getStaticFieldValue() {
        if (!this.isStatic()) {
            throw new FieldNotStaticRuntimeException(this.beanDesc.getBeanClass(), this.fieldName);
        }
        return FieldUtil.get(this.field);
    }

    @Override
    public void setFieldValue(Object target, Object value) {
        AssertionUtil.assertArgumentNotNull("target", target);
        FieldUtil.set(this.field, target, value);
    }

    @Override
    public void setStaticFieldValue(Object value) {
        if (!this.isStatic()) {
            throw new FieldNotStaticRuntimeException(this.beanDesc.getBeanClass(), this.fieldName);
        }
        FieldUtil.set(this.field, value);
    }
}

