/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.util.lang;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import org.seasar.util.beans.BeanDesc;
import org.seasar.util.beans.MethodDesc;
import org.seasar.util.beans.factory.BeanDescFactory;
import org.seasar.util.collection.CollectionsUtil;
import org.seasar.util.misc.AssertionUtil;

public abstract class AnnotationUtil {
    public static Map<String, Object> getProperties(Annotation annotation) {
        AssertionUtil.assertArgumentNotNull("annotation", annotation);
        HashMap<String, Object> map = CollectionsUtil.newHashMap();
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc(annotation.annotationType());
        for (String name : beanDesc.getMethodNames()) {
            Object v = AnnotationUtil.getProperty(beanDesc, annotation, name);
            if (v == null) continue;
            map.put(name, v);
        }
        return map;
    }

    protected static Object getProperty(BeanDesc beanDesc, Annotation annotation, String name) {
        MethodDesc methodDesc = beanDesc.getMethodDescNoException(name, new Class[0]);
        if (methodDesc == null) {
            return null;
        }
        Object value = methodDesc.invoke(annotation, new Object[0]);
        if (value == null || "".equals(value)) {
            return null;
        }
        return value;
    }
}

