/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.util.sql;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.seasar.util.exception.SQLRuntimeException;
import org.seasar.util.log.Logger;
import org.seasar.util.misc.AssertionUtil;

public abstract class ResultSetUtil {
    private static final Logger logger = Logger.getLogger(ResultSetUtil.class);

    public static void close(ResultSet resultSet) {
        if (resultSet == null) {
            return;
        }
        try {
            resultSet.close();
        }
        catch (SQLException e) {
            logger.log(Logger.format("EUTL0017", e.getMessage()), e);
        }
    }

    public static boolean next(ResultSet resultSet) {
        AssertionUtil.assertArgumentNotNull("resultSet", resultSet);
        try {
            return resultSet.next();
        }
        catch (SQLException ex) {
            throw new SQLRuntimeException(ex);
        }
    }

    public static boolean absolute(ResultSet resultSet, int index) throws SQLRuntimeException {
        AssertionUtil.assertArgumentNotNull("resultSet", resultSet);
        try {
            return resultSet.absolute(index);
        }
        catch (SQLException ex) {
            throw new SQLRuntimeException(ex);
        }
    }
}

