
#include "defextern.h"

#ifndef STRICT
    #define STRICT
#endif
#include <windows.h>
#include <iostream.h>
#include <fstream.h>
#include <wininet.h>
#include <windowsx.h>
/*
*/
#include <commctrl.h>
#include "resource.h"
#include "myfilemv.h"
#include "initial.h"
#include "password.h"
#include "file.h"
#include "main.h"



char cdir[MAX_PATH];
char buffer[2000];
char buffer2[2000];
char cmdline[2000];
char initfile[MAX_PATH]="filemv.ini";
char logfile[MAX_PATH]="filemvlog.txt";
char ldirfile[MAX_PATH]="filemvdir.txt";
char listfile[MAX_PATH]="filemvlist.ini";
char hislfile[MAX_PATH]="filemvhisL.ini";
char hisrfile[MAX_PATH]="filemvhisR.ini";
char autofile[MAX_PATH]="filemvauto.ini";
char keyfile[MAX_PATH]="filemvkey.ini";
char initdirfile[MAX_PATH];
char listdirfile[MAX_PATH];
char hisldirfile[MAX_PATH];
char hisrdirfile[MAX_PATH];
char logdirfile[MAX_PATH];
char localdirfile[MAX_PATH];
char autodirfile[MAX_PATH];
char keydirfile[MAX_PATH];

char cmdstr[1000];


char keykey[]="key";
char keywindow[]="setting";
char keystart[]="start";
char keyfilter[]="filter";
char keydirboth[]="dir set";
char keydirlocal[]="dir left";
char keydirremote[]="dir right";
char keycommand[]="command";
char keyhis[]="his";
int localdirnum;
int bothdirnum;
int remotedirnum;
int sendmenunum;
int findmenunum;


#define MAX_NAME 50
#define autofilesavemax 10
const int namenummax=50;
char namelist[namenummax][MAX_NAME];

DWORD keydic[8000];

struct directory
{
	int num;
	char dir[MAX_PATH];
} stockdir;

int seed;
int sessionNum;


BOOL ishost(char *host)
{
	BOOL flag=FALSE;
	for (int i=0 ;i<sessionNum; i++)
	{
		if(strcmp(host,namelist[i])==0) 
		{
			flag=TRUE;
			break;
		}
	}
	return flag;
}

// ----------------------------------
// ȂtH_`FbNċL^

void savedirlocal(char *dir)
{
	BOOL flag=FALSE;
	ifstream in(localdirfile);
	while(!in.eof())
	{
		in.getline(buffer,MAX_PATH);
		if(in.gcount()==0) break;
		if(strcmp(dir,buffer)==0) 
		{
			flag=TRUE;
			break;
		}
	}
	in.close();
	if(flag==FALSE)
	{
		ofstream ldir(localdirfile,ios::ate);
		ldir<<dir<<endl;
	}
}

void loaddirlocal(char *dir)
{
	ifstream in(localdirfile);
	stockdir.num++;
	int n=stockdir.num;
	while(1)
	{
		in.getline(buffer,MAX_PATH);//getline Iq͎菜
		if(in.gcount()==0) break;
		n--;
		if(n<0) break;
	}
	if(n>=0)
	{
		stockdir.num=0;
	}
	else strcpy(dir,buffer);
}

void initlog(ofstream &log)
{
	SYSTEMTIME st;
	char jikan[16];
	char form[]="%04d/%02d/%02d";

	GetLocalTime(&st);
	wsprintf(
		jikan,
		form,
	
		st.wYear,
		st.wMonth,
		st.wDay
	);
	log.open(logdirfile,ios::ate);
	log<<endl<<jikan<<endl;
}


void openinit()
{
	ShellExecute(NULL, "open","notepad",initdirfile, NULL, SW_SHOW);
}

void openinitdir()
{
	ShellExecute(NULL, "open","explorer",cdir, NULL, SW_SHOW);
}

void initsessionnum()
{
	sessionNum=0;
}

int getsessionNum()
{
	return sessionNum;
}

void setseed(char *s)
{
	for(int i= 0; i<5;i++)
	{
		seed += ((unsigned char*)s)[i];
	}
	seed =seed/ 5 +1;
}


//JgfBNg

void getini_cu()
{
	GetCurrentDirectory(MAX_PATH,cdir);
	wsprintf(initdirfile,"%s\\%s",cdir,initfile);
	wsprintf(listdirfile,"%s\\%s",cdir,listfile);
	wsprintf(logdirfile,"%s\\%s",cdir,logfile);
	wsprintf(localdirfile,"%s\\%s",cdir,ldirfile);
	wsprintf(autodirfile,"%s\\%s",cdir,autofile);
	wsprintf(hisldirfile,"%s\\%s",cdir,hislfile);
	wsprintf(hisrdirfile,"%s\\%s",cdir,hisrfile);
	wsprintf(keydirfile,"%s\\%s",cdir,keyfile);
}



int gethostnum()
{
	char key[4]="&\0\0";
	char buffer[MAX_PATH];
	ifstream in(listdirfile);
	int ans=1;
	do
	{
		in>>buffer;
		if(buffer[0]==0 || in.eof()) break;
		strncpy(namelist[ans-1],buffer,MAX_NAME);
		if(ans<10) key[1]='0'+ans;
		else if(ans<=35) key[1]='a'+ans-10;
		else key[1]='-';
		wsprintf(buffer,"%s. %s",key,namelist[ans-1]);
		AppendMenu(hSessionMenu,MF_STRING,sessionIDBASE+ans-1,buffer);
		ans++;
	}
	while (1);
	return ans-1;
}

void savehostlist()
{
	ofstream ou(listdirfile);
	for(int i=0; i<namenummax ;i++)
	{
		if (namelist[i][0]!=0) ou<<namelist[i]<<endl;
	}
}

void setlistbox(HWND &hdlg,UINT IDC)
{
	for(int i=0; i<sessionNum && i<namenummax ; i++)
	{
		SendDlgItemMessage(hdlg,IDC,LB_ADDSTRING,0,(LPARAM)namelist[i]);
	}
}

void setLogonSession(FTPADDRESS *lpftpad)
{
	WritePrivateProfileString(keywindow, "session", lpftpad->name, initdirfile);
}



void getprofilepos( WINPOS *lpwinpos )
{
	lpwinpos->x = GetPrivateProfileInt(keywindow, "x",0,initdirfile);
	lpwinpos->y = GetPrivateProfileInt(keywindow, "y",0,initdirfile);
	lpwinpos->wx = GetPrivateProfileInt(keywindow, "wx",0,initdirfile);
	lpwinpos->wy = GetPrivateProfileInt(keywindow, "wy",0,initdirfile);
}

void getprofiledir()
{
	int i;
	i=0;
	bothdirnum=0;
	while(1)
	{
		i++;
		wsprintf(buffer,"%d name",i);
		GetPrivateProfileString(keydirboth, buffer, "", buffer, MAX_PATH, initdirfile);
		if(strcmp(buffer,"")==0) break;
		AppendMenu(hBothMenu,MF_STRING,bothdirIDBASE+i-1,buffer);
		bothdirnum++;
	}
	i=0;
	localdirnum=0;
	while(1)
	{
		i++;
		wsprintf(buffer,"%d",i);
		GetPrivateProfileString(keydirlocal, buffer, "", buffer, MAX_PATH, initdirfile);
		if(strcmp(buffer,"")==0) break;
		AppendMenu(hLeftMenu,MF_STRING,localdirIDBASE+i-1,buffer);
		localdirnum++;
	}
	i=0;
	remotedirnum=0;
	while(1)
	{
		i++;
		wsprintf(buffer,"%d",i);
		GetPrivateProfileString(keydirremote, buffer, "", buffer, MAX_PATH, initdirfile);
		if(strlen(buffer)==0) break;
		AppendMenu(hRemoteMenu,MF_STRING,remotedirIDBASE+i-1,buffer);
		remotedirnum++;
	}
	i=0;
	findmenunum=0;
	while(1)
	{
		i++;
		wsprintf(buffer,"%d",i);
		GetPrivateProfileString(keyfilter, buffer, "", buffer, MAX_PATH, initdirfile);
		if(strlen(buffer)==0) break;
		AppendMenu(hFindMenu,MF_STRING,findIDBASE+i-1,buffer);
		findmenunum++;
	}
	i=0;
	sendmenunum=0;
	getnextfile(sendtoPath, "*", buffer, 0);
	while(1)
	{
		if(strlen(buffer)==0) break;
		if(buffer[0]!='.')  //folder
		{
			i++;
			AppendMenu(hSendtoMenu,MF_STRING,sendIDBASE+i-1,buffer);
			sendmenunum++;
		}
		if(getnextfile(sendtoPath, "*", buffer, 1)<0) break;
	}
}

char *loadlastdir(int i)
{
	static char buff[MAX_INFO];
	wsprintf(buffer,"%d",i);
	GetPrivateProfileString(keystart, buffer, "", buff, MAX_INFO, initdirfile);
	return buff;
}

// VfBNgۑ

void saveprofiledir(char *key, int *num, char *dir)
{
	BOOL flag=TRUE;
	char buff[MAX_PATH];
	if(dir[0]=='\\') return;
	//if(strcmp(dir,".")==0) return;

	int i=0;
	while(1)
	{
		i++;
		wsprintf(buff,"%d",i);
		GetPrivateProfileString(key, buff, "", buffer, MAX_PATH, initdirfile);
		if(strcmp(buffer,dir)==0 )
		{
			flag=FALSE;
			break;
		}
		if( strlen(buffer)==0 )
		{
			break;
		}
	}
	if (flag==FALSE ) return;
	(*num)++;
	wsprintf(buff,"%d",*num);
	WritePrivateProfileString(key, buff, dir, initdirfile);
}

void saveremotedir(char *dir)
{
	saveprofiledir(keydirremote,&remotedirnum,dir);
}
void savelocaldir(int tab, char *dir)
{
	if(tab == 1) saveprofiledir(keydirlocal,&localdirnum,dir);
	else saveremotedir(dir);
}


static int his[2];
#define HISMAX 100

void hisInit()
{
	GetPrivateProfileInt(keyhis, "now", his[tab_l-1], hisldirfile);
	GetPrivateProfileInt(keyhis, "now", his[tab_r-1], hisrdirfile);
	GetPrivateProfileString(keyhis, "now", "",buffer, MAX_PATH,hisldirfile);
	sscanf(buffer ,"%d" ,&his[tab_l-1]);
	GetPrivateProfileString(keyhis, "now", "",buffer, MAX_PATH,hisrdirfile);
	sscanf(buffer ,"%d" ,&his[tab_r-1]);
	initflag=TRUE;
}

void hisreset()
{
	for(int i=0;i<2;i++) his[i]=1;
}

void writehispos(int tab, char *file)
{
	wsprintf(buffer,"%d",his[tab-1]);
	WritePrivateProfileString(keyhis, "now", buffer, file);
}

// ۑAOƓłȂ.
// ۑƂhis[]͎wĂ

void savehisdir(int tab, char *dir)
{
	if(!initflag) return;
	if(tab<1 || tab>2) tab=1;
	if(tab ==tab_l) 
	{
		wsprintf(buffer,"%d",his[tab-1]-1);
		GetPrivateProfileString(keyhis, buffer, "", buffer, MAX_PATH, hisldirfile);
		if(strcmp(dir,buffer)==0) return;
		wsprintf(buffer,"%d",his[tab-1]);
		WritePrivateProfileString(keyhis, buffer, dir, hisldirfile);
		writehispos(tab, hisldirfile);
	}
	if(tab ==tab_r) 
	{
		wsprintf(buffer,"%d",his[tab-1]-1);
		GetPrivateProfileString(keyhis, buffer, "", buffer, MAX_PATH, hisrdirfile);
		if(strcmp(dir,buffer)==0) return;
		wsprintf(buffer,"%d",his[tab-1]);
		WritePrivateProfileString(keyhis, buffer, dir, hisrdirfile);
		writehispos(tab, hisrdirfile);
	}
	his[tab-1]++;
	if(his[tab-1]>100) his[tab-1]=1;
}

char *loadhisdir(int tab, char *dir, int pos)
{
	if(tab<1 || tab>2) tab=1;
	int po =his[tab-1]+pos-1;
	if(po>HISMAX) his[tab-1] =1;
	if(po<0) his[tab-1] =1;
	else his[tab-1]=po;
	wsprintf(buffer,"%d",his[tab-1]);
	if(tab ==tab_l) 
	{
		GetPrivateProfileString(keyhis, buffer, "", buffer, MAX_PATH, hisldirfile);
		//if(pos<0) writehispos(tab, hisldirfile);
	}
	if(tab ==tab_r) 
	{
		GetPrivateProfileString(keyhis, buffer, "", buffer, MAX_PATH, hisrdirfile);
		//if(pos<0) writehispos(tab, hisrdirfile);
	}
	if(strlen(buffer)>0) sprintf(dir,"%s",buffer);
	his[tab-1]++;
	return dir;
}

int getbothnum()
{
	char buff[MAX_PATH];
	int i =0;
	while(1)
	{
		i++;
		wsprintf(buff,"%d name",i);
		GetPrivateProfileString(keydirboth, buff, "", buffer, MAX_PATH, initdirfile);
		if( strlen(buffer)==0 )
		{
			break;
		}

	}
	return i-1;
}

void loadbothdir(int num, char *ldir, char *rdir)
{
	BOOL flag=TRUE;
	char buff[MAX_PATH];

	wsprintf(buff,"%d right", num);
	GetPrivateProfileString(keydirboth, buff, "", rdir, MAX_PATH, initdirfile);
	wsprintf(buff,"%d left", num);
	GetPrivateProfileString(keydirboth, buff, "", ldir, MAX_PATH, initdirfile);
}

void savebothdir(char *name, char *ldir, char *rdir)
{
	
	BOOL flag=TRUE;
	char buff[MAX_PATH];

	if(strlen(name)==0) name=ldir;
	int i=0;
	i =getbothnum()+1;
	wsprintf(buff,"%d name", i);
	WritePrivateProfileString(keydirboth, buff, name, initdirfile);
	wsprintf(buff,"%d right", i);
	WritePrivateProfileString(keydirboth, buff, rdir, initdirfile);
	wsprintf(buff,"%d left", i);
	WritePrivateProfileString(keydirboth, buff, ldir, initdirfile);
}

// O̎Abv[ht@CƈႤꍇ
// sAbv[ht@C@shift āAǉ

void AddAutofile(char *file)
{
	char buff[MAX_PATH+1]="";
	char buffer[10];
	int i=autofilesavemax;
	
	wsprintf(buffer,"%d",1);
	GetPrivateProfileString("autofile", buffer, "", buff, MAX_PATH, autodirfile);
	if( strcmp(file,buff)==0 ) return;

	while(i>0)
	{
		wsprintf(buffer,"%d",i);
		GetPrivateProfileString("autofile", buffer, "", buff, MAX_PATH, autodirfile);
		if (strlen(buff)==0) break;
		wsprintf(buffer,"%d",i+1);
		WritePrivateProfileString("autofile", buffer, buff, autodirfile);
		i--;
	}
	wsprintf(buff,"%d",1);
	WritePrivateProfileString("autofile", buff, file, autodirfile);
}

BOOL SearchProfileString(char *key, char * str, char *file )
{
	int num =0;
	char buff[MAX_FILTER];
	char buffer[10];
	
	while(1)
	{
		num++;
		wsprintf(buffer,"%d",num);
		if( GetPrivateProfileString(key, buffer, "", buff, MAX_FILTER, file) ==0) break;
		if(strcmp(buff, str)==0) return TRUE;
	}
	return FALSE;
}

int GetProfileNum(char *key, char *file)
{
	int num =0;
	char buff[MAX_PATH+1]="";
	char buffer[10];
	
	while(1)
	{
		num++;
		wsprintf(buffer,"%d",num);
		GetPrivateProfileString(key, buffer, "", buff, MAX_PATH, file);
		if(buff[0]==0) break;
	}
	return num-1;
}


void GetAutoFile(int num, char *file)
{
	char buff[MAX_PATH+1]="";
	char buffer[10];
	
	wsprintf(buffer,"%d",num);
	GetPrivateProfileString("autofile", buffer, "", buff, MAX_PATH, autodirfile);
	strncpy(file,buff,MAX_PATH);
}


void initkey()
{
	int c=0;
	for( DWORD i=0; i<8000 ; i++ )
	{
		wsprintf(buffer,"%ld",i);
		GetPrivateProfileString(keykey, buffer, "", buffer, MAX_PATH,keydirfile);
		if(strlen(buffer)>0) sscanf(buffer,"%d",&keydic[i]);
		//GetPrivateProfileInt(keykey, buffer, keydic[i], keydirfile);
		if(keydic[i]==0) keydic[i]=i;
		else c++;
	}
}

void MyGetInitialData(WINPOS *lpwinpos)
{
	char newword[100];

	getini_cu();
	hisInit();
	initkey();

	dontoverwrite =FALSE;//㏑
	autoedit =FALSE;//ҏW@㏑Ȃ
	getprofilepos(lpwinpos);
	getprofiledir();
	GetPrivateProfileString(keywindow, "edit", "notepad", editor, MAX_PATH, initdirfile);
	GetPrivateProfileString(keywindow, "auto edit", "", newword, 100, initdirfile);
	if(strcmp(newword,"yes")==0) autoedit=TRUE;

	sessionNum =gethostnum();
	stockdir.num=0;

	return;
}

void GetVol(int len, char *vol)
{
    DWORD SectorsPerCluster;
    DWORD BytesPerSector;
    DWORD NumberOfFreeClusters;
    DWORD TotalNumberOfClusters;
	const int INFOBUF_SIZE=1000;
    char drives[INFOBUF_SIZE];
    GetLogicalDriveStrings(INFOBUF_SIZE, drives);   //  LȃhCüꗗ擾
    const char *ptr = drives;
	strcpy(vol,"");
    while( *ptr != '\0' ) {                         //  LȃhCucĂ
//        uint driveType = GetDriveType(ptr);
        SHFILEINFO shFileInfo;
        SHGetFileInfo(ptr, 0, &shFileInfo, sizeof(SHFILEINFO), SHGFI_DISPLAYNAME);
        strcat(vol,  ptr);
		strcat(vol, shFileInfo.szDisplayName);
		strcat(vol,"\n");
        ptr = strchr(ptr, '\0');                    //  ̃hCu
        //ASSERT(ptr);
        ptr += 1;
    }
 

}


void savelastdir(int tab, char *dir)
{
	char buffer[4];
	wsprintf(buffer,"%d",tab);
	WritePrivateProfileString(keystart, buffer, dir, initdirfile);
}


void savefilter(char *str)
{
	char buffer[4];
	int num;
	if ( SearchProfileString( keyfilter, str, initdirfile ) ) return;
	num =GetProfileNum(keyfilter, initdirfile);
	wsprintf(buffer,"%d",num+1);
	WritePrivateProfileString(keyfilter, buffer, str, initdirfile);
}

void MySaveInitialData( WINPOS *lpwinpos)
{
	char buffer[MAX_INFO];
	//itoa()
	wsprintf(buffer,"%d",lpwinpos->x);
	WritePrivateProfileString(keywindow, "x", buffer, initdirfile);
	wsprintf(buffer,"%d",lpwinpos->y);
	WritePrivateProfileString(keywindow, "y", buffer, initdirfile);
	wsprintf(buffer,"%d",lpwinpos->wx);
	WritePrivateProfileString(keywindow, "wx", buffer, initdirfile);
	wsprintf(buffer,"%d",lpwinpos->wy);
	WritePrivateProfileString(keywindow, "wy", buffer, initdirfile);
	return;
}


WORD transkey(WORD key)
{
	if(key>=8000) return key;
	return keydic[key];
}

// R}hC̒$PȂǂ̏

char *TransCmd(char *cmd, char *file, char *path)
{
	char *cmdstr =cmd;
	char *buf =buffer2;

	while(1)
	{
		if(*cmdstr!='$') *buf++ = *cmdstr++ ;
		else
		{
			cmdstr++;
			if ( *cmdstr == 'F' ) 
			{
				strcpy( buf, file);
				buf += strlen(file);
				cmdstr++;
			}
			else if ( *cmdstr == 'P' ) 
			{
				strcpy( buf, path);
				buf += strlen(path);
				cmdstr++;
			}
		}
		if(*cmdstr == 0 ) break;
	}
	*buf = 0;
	strcpy(cmd, buffer2);
	return cmd;
}

char *GetMyCmdStr( int mode )
{
	char buff[10];
	wsprintf(buff,"%d",mode);
	GetPrivateProfileString(keycommand, buff, "notepad %s", cmdstr, MAX_PATH, initdirfile);
	return cmdstr;
}

// o^R}hŎs

char *cmd(char *file, char *path, int mode)
{
	strcpy(cmdline,TransCmd(GetMyCmdStr(mode), file, path));
	sprintf(buffer, cmdline, quote( GetFullName(buffer2, file, path, MAX_PATH) ) );
	return buffer;
}

// ڎwR}hŎs
char *cmd(char *file, char *path, char *com)
{
	strcpy(cmdline,TransCmd(com, file, path));
	wsprintf(buffer, cmdline, quote( GetFullName(buffer2, file, path, MAX_PATH) ) );
	return buffer;
}


void myexec( char *cmd)
{
	system(cmd);
	//ShellExecute(NULL, NULL, cmd, NULL, NULL, SW_SHOW);
}