/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ktz.puzzle.fillo.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import jp.gr.java_conf.ktz.puzzle.fillo.io.ProblemCollection;
import jp.gr.java_conf.ktz.puzzle.fillo.io.ProblemReader;
import jp.gr.java_conf.ktz.puzzle.framework.ProblemInfo;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;

public abstract class AbstractXMLProblemReader
implements ProblemReader {
    private ProblemInfo[] mProblemList = new ProblemInfo[0];

    public void load(File inFile) throws FileNotFoundException, IOException {
        try {
            ProblemCollection aCollection = this.loadCollection(inFile);
            this.mProblemList = this.createProblemInfo(inFile.getName(), aCollection);
        }
        catch (JiBXException e) {
            throw new IOException("Unexpectied file is passed");
        }
    }

    public ProblemInfo getProblemAt(int inIndex) {
        return this.mProblemList[inIndex];
    }

    public ProblemInfo[] getAllProblems() {
        return this.mProblemList;
    }

    public int getSize() {
        return this.mProblemList.length;
    }

    private ProblemCollection loadCollection(File inFile) throws JiBXException, FileNotFoundException {
        Class aClass = this.getClassForProblemCollection();
        IBindingFactory aFactory = BindingDirectory.getFactory((Class)aClass);
        IUnmarshallingContext aContext = aFactory.createUnmarshallingContext();
        FileInputStream aStream = new FileInputStream(inFile);
        Object aObj = aContext.unmarshalDocument((InputStream)aStream, null);
        try {
            ((InputStream)aStream).close();
        }
        catch (IOException ioe) {
            System.out.println("close operation is not successful !");
        }
        return (ProblemCollection)aObj;
    }

    protected abstract Class getClassForProblemCollection();

    protected abstract ProblemInfo[] createProblemInfo(String var1, ProblemCollection var2);
}

