/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ktz.puzzle.fillo.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import jp.gr.java_conf.ktz.puzzle.fillo.io.ProblemReader;
import jp.gr.java_conf.ktz.puzzle.fillo.util.LoadadProblemListModel;
import jp.gr.java_conf.ktz.puzzle.fillo.util.MockCommandContainer;
import jp.gr.java_conf.ktz.puzzle.framework.ProblemInfo;
import jp.gr.java_conf.ktz.puzzle.framework.util.Command;
import jp.gr.java_conf.ktz.puzzle.framework.util.GUIUtility;
import jp.gr.java_conf.ktz.puzzle.framework.util.TextUtility;
import jp.gr.java_conf.ktz.puzzle.framework.view.CommandContainer;
import jp.gr.java_conf.ktz.puzzle.framework.view.awt.AWTDispatchCommandQueue;
import jp.gr.java_conf.ktz.puzzle.framework.view.command.LoadCommand;

public class ProblemChooser
extends JFrame {
    private CommandContainer mOwner;
    private ProblemReader mReader;
    private JList mList;
    private JLabel mPathLabel;
    private File mCurPath;

    public ProblemChooser(CommandContainer inOwner) {
        this.mOwner = inOwner;
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent inEvent) {
                ProblemChooser.this.setVisible(false);
            }
        });
    }

    protected void frameInit() {
        super.frameInit();
        this.mCurPath = new File("problem").getAbsoluteFile();
        this.setTitle("title");
        Container aPane = this.getContentPane();
        JPanel aPathPanel = new JPanel();
        aPane.add((Component)aPathPanel, "North");
        aPathPanel.setPreferredSize(new Dimension(250, 45));
        aPathPanel.setBackground(Color.white);
        JPanel aPanel = new JPanel();
        aPane.add((Component)aPanel, "Center");
        aPanel.setPreferredSize(new Dimension(270, 190));
        aPanel.setBackground(Color.white);
        this.setResizable(false);
        this.pack();
        SpringLayout aLayout = new SpringLayout();
        aPathPanel.setLayout(aLayout);
        this.mPathLabel = new JLabel(this.mCurPath.getAbsolutePath());
        this.mPathLabel.setBorder(new TitledBorder("path"));
        aPathPanel.add((Component)this.mPathLabel, new SpringLayout.Constraints(Spring.constant(5), Spring.constant(5), Spring.constant(210), Spring.constant(35)));
        Insets aInsets = this.mPathLabel.getInsets();
        int aWidth = this.mPathLabel.getWidth() - aInsets.left - aInsets.right;
        String aText = TextUtility.truncText((FontMetrics)this.mPathLabel.getFontMetrics(this.mPathLabel.getFont()), (int)aWidth, (String)this.mCurPath.getAbsolutePath(), (int)1);
        this.mPathLabel.setText(aText);
        JButton aChangePath = new JButton("...");
        aChangePath.addActionListener(new ActionListener(){
            private JFileChooser mChooser = new JFileChooser();
            {
                this.mChooser.setFileFilter(new FileFilter(this){
                    private final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public boolean accept(File inFile) {
                        if (inFile.isDirectory()) {
                            return true;
                        }
                        int aIndex = inFile.getName().toLowerCase().indexOf(".xml");
                        return 0 < aIndex;
                    }

                    public String getDescription() {
                        return "XML file (version 1.0)";
                    }
                });
            }

            public void actionPerformed(ActionEvent inEvent) {
                File aDir = ProblemChooser.this.mCurPath;
                if (!aDir.isDirectory()) {
                    aDir = new File(ProblemChooser.this.mCurPath.getParent());
                }
                this.mChooser.setCurrentDirectory(aDir);
                int aSel = this.mChooser.showOpenDialog(ProblemChooser.this);
                if (aSel == 0) {
                    ProblemChooser.this.mCurPath = this.mChooser.getSelectedFile();
                    Insets aInsets = ProblemChooser.this.mPathLabel.getInsets();
                    int aWidth = ProblemChooser.this.mPathLabel.getWidth() - aInsets.left - aInsets.right;
                    String aText = TextUtility.truncText((FontMetrics)ProblemChooser.this.mPathLabel.getFontMetrics(ProblemChooser.this.mPathLabel.getFont()), (int)aWidth, (String)ProblemChooser.this.mCurPath.getAbsolutePath(), (int)1);
                    ProblemChooser.this.mPathLabel.setText(aText);
                }
            }
        });
        aPathPanel.add((Component)aChangePath, new SpringLayout.Constraints(Spring.constant(225), Spring.constant(15), Spring.constant(20), Spring.constant(20)));
        aPanel.setLayout(aLayout);
        LoadadProblemListModel aModel = new LoadadProblemListModel();
        this.mReader = aModel;
        this.mList = new JList();
        this.mList.setModel(aModel);
        this.mList.setCellRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                this.setComponentOrientation(list.getComponentOrientation());
                if (isSelected) {
                    this.setBackground(list.getSelectionBackground());
                    this.setForeground(list.getSelectionForeground());
                } else {
                    this.setBackground(list.getBackground());
                    this.setForeground(list.getForeground());
                }
                this.setFont(list.getFont());
                this.setText(ProblemChooser.this.convertStringFrom((ProblemInfo)value));
                this.setEnabled(list.isEnabled());
                this.setBorder(cellHasFocus ? UIManager.getBorder("List.focusCellHighlightBorder") : noFocusBorder);
                return this;
            }
        });
        this.mList.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent inEvent) {
                if (2 != inEvent.getClickCount()) {
                    ProblemChooser.this.notifyProblemLoaded();
                }
            }

            public void mousePressed(MouseEvent inEvent) {
            }

            public void mouseReleased(MouseEvent inEvent) {
            }

            public void mouseEntered(MouseEvent inEvent) {
            }

            public void mouseExited(MouseEvent inEvent) {
            }
        });
        aPanel.add((Component)new JScrollPane(this.mList, 22, 31), new SpringLayout.Constraints(Spring.constant(5), Spring.constant(5), Spring.constant(150), Spring.constant(180)));
        JButton aLoad = new JButton("Load");
        aLoad.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent inEvent) {
                if (ProblemChooser.this.mPathLabel.getText().equals("")) {
                    return;
                }
                try {
                    ProblemChooser.this.mReader.load(ProblemChooser.this.mCurPath.getAbsoluteFile());
                }
                catch (IOException e) {
                    System.out.println("the specified file, " + ProblemChooser.this.mCurPath + " is not a problem file");
                }
            }
        });
        aPanel.add((Component)aLoad, new SpringLayout.Constraints(Spring.constant(165), Spring.constant(10), Spring.constant(100), Spring.constant(25)));
        JButton aOK = new JButton("OK");
        aOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent inEvent) {
                ProblemChooser.this.notifyProblemLoaded();
            }
        });
        aPanel.add((Component)aOK, new SpringLayout.Constraints(Spring.constant(165), Spring.constant(45), Spring.constant(100), Spring.constant(25)));
        JButton aCancel = new JButton("Cancel");
        aCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent inEvent) {
                ProblemChooser.this.notifyLoadCanceled();
            }
        });
        aPanel.add((Component)aCancel, new SpringLayout.Constraints(Spring.constant(165), Spring.constant(75), Spring.constant(100), Spring.constant(25)));
    }

    private String convertStringFrom(ProblemInfo inInfo) {
        return "Q. " + inInfo.getIndex() + " (" + inInfo.getWidth() + " X " + inInfo.getHeight() + ")";
    }

    public void setVisible(boolean inIsShow) {
        GUIUtility.LayoutToCenter((Component)this);
        super.setVisible(inIsShow);
    }

    private void notifyProblemLoaded() {
        int aIndex = this.mList.getSelectedIndex();
        if (aIndex < 0) {
            return;
        }
        this.setVisible(false);
        AWTDispatchCommandQueue.postCommand((Command)new LoadCommand(this.mOwner, this.mReader.getProblemAt(aIndex)));
    }

    private void notifyLoadCanceled() {
        this.setVisible(false);
    }

    public static void main(String[] inArgs) {
        new ProblemChooser(new MockCommandContainer()).show();
    }
}

