/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ktz.puzzle.fillo.app.controller;

import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import jp.gr.java_conf.ktz.puzzle.fillo.app.controller.ChangeEventFactory;
import jp.gr.java_conf.ktz.puzzle.fillo.app.controller.ChangeHandler;
import jp.gr.java_conf.ktz.puzzle.fillo.util.InputUtility;
import jp.gr.java_conf.ktz.puzzle.framework.StateEventCode;
import jp.gr.java_conf.ktz.puzzle.framework.StateManager;
import jp.gr.java_conf.ktz.puzzle.framework.constants.Direction;
import jp.gr.java_conf.ktz.puzzle.framework.fsm.DecoratedState;
import jp.gr.java_conf.ktz.puzzle.framework.fsm.State;
import jp.gr.java_conf.ktz.puzzle.framework.model.Model;

public class FilloChangeHandler
implements ChangeHandler {
    private static final Direction[] DIRECTIONS = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST};
    private Point mActivePos;
    private List mSelectedStack = new ArrayList();
    private Model mModel;

    public FilloChangeHandler(Model inModel) {
        this.mModel = inModel;
        this.mActivePos = new Point(Integer.MIN_VALUE, Integer.MIN_VALUE);
    }

    public boolean notifySelectionChanged(int inX, int inY, boolean inSelectedBlock, boolean inAppendable) {
        StateEventCode aEvent;
        if (!this.mModel.contains(inX, inY)) {
            return false;
        }
        Point aNewActive = new Point(inX, inY);
        if (!inSelectedBlock) {
            this.resetSelectedStack();
            this.mActivePos = aNewActive;
        } else {
            if (this.mModel.isSpaceAt(inX, inY)) {
                return false;
            }
            this.mActivePos = aNewActive;
            this.traceBlockRange(inX, inY, this.mSelectedStack);
            if (!this.mSelectedStack.isEmpty()) {
                aEvent = ChangeEventFactory.createSelectionEvent(false);
                this.changeBlockRange(aEvent);
            }
        }
        aEvent = ChangeEventFactory.createSelectionEvent(true);
        this.mModel.nextStateAt(inX, inY, aEvent);
        return this.mModel.isModified();
    }

    private void traceBlockRange(int inX, int inY, Collection outStack) {
        State aState = this.peelState(this.mModel.getCurStateAt(inX, inY));
        String aValue = StateManager.getInstance().findIdentityOf(aState);
        int aInputNum = InputUtility.getInputValue(aValue);
        ArrayList aStack = new ArrayList();
        this.velifyInputRangeSub(aValue, aInputNum, new Point(inX, inY), aStack);
        outStack.addAll(aStack);
    }

    boolean isActivePos(Point inPos) {
        return this.mActivePos.equals(inPos);
    }

    public boolean notifyAdjacentSelected(Direction inDirection, boolean inAppendable) {
        Point aDiff = inDirection.getDifference();
        int aNewX = this.mActivePos.x + aDiff.x;
        int aNewY = this.mActivePos.y + aDiff.y;
        if (!this.mModel.contains(aNewX, aNewY)) {
            return false;
        }
        this.mActivePos.setLocation(aNewX, aNewY);
        this.resetSelectedStack();
        StateEventCode aEvent = ChangeEventFactory.createSelectionEvent(true);
        this.mModel.nextStateAt(aNewX, aNewY, aEvent);
        return this.mModel.isModified();
    }

    public boolean notifyInputOccured(String inVal) {
        if (this.isSameAsInputed(this.mActivePos, inVal)) {
            return false;
        }
        StateEventCode aEvent = ChangeEventFactory.createNumberInputEvent(inVal);
        if (!this.mSelectedStack.isEmpty()) {
            this.changeBlockRange(aEvent);
        }
        this.mModel.nextStateAt(this.mActivePos.x, this.mActivePos.y, aEvent);
        return this.mModel.isModified();
    }

    boolean velifyInputRange(String inVal) {
        if (InputUtility.isDeleteOccured(inVal)) {
            return true;
        }
        int aInputNum = InputUtility.getInputValue(inVal);
        Point aStart = new Point(this.mActivePos);
        HashSet<Point> aSeries = new HashSet<Point>();
        aSeries.add(aStart);
        return this.velifyInputRangeSub(inVal, aInputNum, aStart, aSeries);
    }

    private boolean velifyInputRangeSub(String inVal, int inInputNum, Point inPos, Collection outSeries) {
        if (!this.isActivePos(inPos)) {
            outSeries.add(new Point(inPos));
        }
        for (int i = 0; i < DIRECTIONS.length; ++i) {
            Point aDiff = DIRECTIONS[i].getDifference();
            inPos.translate(aDiff.x, aDiff.y);
            if (!(this.isActivePos(inPos) || outSeries.contains(inPos) || !this.isSameNumberAsInputed(inPos, inVal) && !this.mSelectedStack.contains(inPos) || this.velifyInputRangeSub(inVal, inInputNum, inPos, outSeries))) {
                return false;
            }
            inPos.translate(-aDiff.x, -aDiff.y);
        }
        return true;
    }

    State peelState(State inState) {
        if (inState instanceof DecoratedState) {
            return this.peelState(((DecoratedState)inState).getDecorated());
        }
        return inState;
    }

    private void changeBlockRange(StateEventCode inEvent) {
        int size = this.getSelectedStackSize();
        for (int i = 0; i < size; ++i) {
            Point aPos = (Point)this.mSelectedStack.get(i);
            this.mModel.nextStateAt(aPos.x, aPos.y, inEvent);
        }
    }

    boolean isSameAsInputed(Point inPos, String inVal) {
        if (null == inVal) {
            throw new IllegalArgumentException("inVal is null");
        }
        State aState = this.peelState(this.mModel.getCurStateAt(inPos.x, inPos.y));
        String aIDs = StateManager.getInstance().findIdentityOf(aState);
        return aIDs.equals(inVal);
    }

    private boolean isSameNumberAsInputed(Point inPos, String inVal) {
        if (!this.mModel.isNumberAt(inPos.x, inPos.y)) {
            return false;
        }
        return this.isSameAsInputed(inPos, inVal);
    }

    int getSelectedStackSize() {
        return this.mSelectedStack.size();
    }

    private void resetSelectedStack() {
        if (this.mSelectedStack.isEmpty()) {
            return;
        }
        StateEventCode aEvent = ChangeEventFactory.createDeselectionEvent();
        this.changeBlockRange(aEvent);
        this.mSelectedStack.clear();
    }
}

