/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ktz.puzzle.fillo.app.model;

import java.awt.Dimension;
import java.awt.Point;
import java.util.HashSet;
import java.util.Set;
import jp.gr.java_conf.ktz.puzzle.fillo.util.StateEventUtility;
import jp.gr.java_conf.ktz.puzzle.framework.ProblemInfo;
import jp.gr.java_conf.ktz.puzzle.framework.StateEventCode;
import jp.gr.java_conf.ktz.puzzle.framework.StateManager;
import jp.gr.java_conf.ktz.puzzle.framework.fsm.State;
import jp.gr.java_conf.ktz.puzzle.framework.model.AbstractDecoratedModel;
import jp.gr.java_conf.ktz.puzzle.framework.model.Model;
import jp.gr.java_conf.ktz.puzzle.framework.model.NullModel;

public class BoardModel
extends AbstractDecoratedModel {
    private Cell[] mCells;
    private int mWidth;
    private int mHeight;
    private Set mLastModified = new HashSet();

    public BoardModel() {
        this(NullModel.getInstance());
    }

    public BoardModel(Model inModel) {
        super(inModel);
    }

    protected void createBoardSelf(int inWidth, int inHeight) {
        if (inWidth == this.mWidth && inHeight == this.mHeight) {
            return;
        }
        this.flushSelf();
        this.mWidth = inWidth;
        this.mHeight = inHeight;
        this.mCells = new Cell[this.mWidth * this.mHeight];
        for (int y = 0; y < this.mHeight; ++y) {
            for (int x = 0; x < this.mWidth; ++x) {
                this.mCells[y * this.mWidth + x] = new Cell();
                this.mLastModified.add(new Point(x, y));
            }
        }
    }

    public int setProblem(ProblemInfo inInfo) {
        if (this.mWidth != inInfo.getWidth() || this.mHeight != inInfo.getHeight()) {
            this.createBoard(inInfo.getWidth(), inInfo.getHeight());
        }
        if (!inInfo.isMoreRead()) {
            return Integer.MIN_VALUE;
        }
        int aReadPos = 0;
        if (inInfo.isDivideRead()) {
            aReadPos = inInfo.getOffset();
        }
        for (int i = aReadPos; i < aReadPos + inInfo.getReadOnce(); ++i) {
            State aState = this.idsToState((String)inInfo.getRecordAt(i));
            if (this.mCells[i].getState() == aState) continue;
            this.mCells[i].setState(aState);
            this.addModifiedSet(i);
        }
        return inInfo.isDivideRead() ? inInfo.getReadOnce() : Integer.MIN_VALUE;
    }

    protected void initProblemAtSelf(int inX, int inY, Object inRecord) {
        if (!this.contains(inX, inY)) {
            throw new IllegalArgumentException("0 < x <= " + this.mWidth + ", 0 < y <= " + this.mHeight + " (inX : " + inX + ", inY : " + inY + ")");
        }
        if (null == inRecord) {
            throw new IllegalArgumentException("Cannot pass null-value to inRecord");
        }
        State aState = this.idsToState((String)inRecord);
        Cell aCell = this.getCellAt(inX, inY);
        if (aCell.getState() != aState) {
            aCell.setState(aState);
            this.addModifiedSet(inX, inY);
        }
        if (aCell.isNumber()) {
            aCell.setImmutable();
        }
    }

    private State idsToState(String inIDs) {
        State aState = StateManager.getInstance().createStateOf(inIDs.trim());
        if (aState == null) {
            throw new IllegalArgumentException("A specified ID '" + inIDs.trim() + "' is ignore.");
        }
        return aState;
    }

    private void addModifiedSet(int inIndex) {
        int aX = inIndex % this.mWidth;
        int aY = inIndex / this.mWidth;
        this.addModifiedSet(aX, aY);
    }

    private void addModifiedSet(int inX, int inY) {
        this.mLastModified.add(new Point(inX, inY));
    }

    public boolean check() {
        return false;
    }

    public void reset() {
    }

    protected void resetAtSelf(int inX, int inY) {
    }

    public Dimension getSize() {
        return new Dimension(this.mWidth, this.mHeight);
    }

    public int getWidth() {
        return this.mWidth;
    }

    public int getHeight() {
        return this.mHeight;
    }

    public State getCurStateAt(int inX, int inY) {
        return this.getCellAt(inX, inY).getState();
    }

    public void nextStateAt(int inX, int inY) {
        throw new UnsupportedOperationException("Needs to pass a arg inEvent for the method nextStateAt.");
    }

    protected void nextStateAtSelf(int inX, int inY, StateEventCode inCode) {
        if (!StateEventUtility.isNumberStateEventCode(inCode)) {
            throw new IllegalArgumentException("inCode is not NumberStateEventCode");
        }
        Cell aCell = this.getCellAt(inX, inY);
        if (aCell.isImmutable()) {
            return;
        }
        State aNextState = StateManager.getInstance().getNextState(aCell.getState(), inCode);
        if (aCell.getState() != aNextState) {
            aCell.setState(aNextState);
            this.mLastModified.add(new Point(inX, inY));
        }
    }

    public void prevStateAt(int inX, int inY) {
        throw new UnsupportedOperationException("Needs to pass a arg inEvent for the method prevStateAt.");
    }

    protected void prevStateAtSelf(int inX, int inY, StateEventCode inEvent) {
        throw new UnsupportedOperationException();
    }

    protected synchronized Point[] lastModifiedSelf() {
        return this.mLastModified.toArray(new Point[this.mLastModified.size()]);
    }

    protected synchronized boolean isModifiedSelf() {
        return !this.mLastModified.isEmpty();
    }

    protected synchronized void flushSelf() {
        if (this.mLastModified.isEmpty()) {
            return;
        }
        this.mLastModified.clear();
    }

    public boolean isNumberAt(int inX, int inY) {
        if (!this.contains(inX, inY)) {
            return false;
        }
        return this.getCellAt(inX, inY).isNumber();
    }

    public boolean isSpaceAt(int inX, int inY) {
        if (!this.contains(inX, inY)) {
            return false;
        }
        return this.getCellAt(inX, inY).isSpace();
    }

    public boolean isTransitAt(int inX, int inY, StateEventCode inTransitCode) {
        if (!this.contains(inX, inY)) {
            return false;
        }
        throw new UnsupportedOperationException();
    }

    public boolean isTransitAt(int inX, int inY) {
        throw new UnsupportedOperationException("the method isTransitAt(int, int) is unsupported");
    }

    protected boolean isAcceptableEvent(StateEventCode inCode) {
        return StateEventUtility.isNumberStateEventCode(inCode);
    }

    public boolean contains(int inX, int inY) {
        return inX >= 0 && inX < this.mWidth && inY >= 0 && inY < this.mHeight;
    }

    public State getCorrectStateAt(int inX, int inY) {
        throw new UnsupportedOperationException("This model isnot supported getCorrectStateAt method.");
    }

    private Cell getCellAt(int inX, int inY) {
        if (!this.contains(inX, inY)) {
            throw new IndexOutOfBoundsException("0 <= x < " + this.mWidth + ", 0 <= y < " + this.mHeight + " (inX : " + inX + ", inY : " + inY + ")");
        }
        return this.mCells[inY * this.mWidth + inX];
    }

    private static class Cell {
        private State mState = this.getDefaultState();
        private boolean mImmutable;

        Cell() {
        }

        State getState() {
            return this.mState;
        }

        void setState(State inState) {
            this.mState = inState;
        }

        private State getDefaultState() {
            return StateManager.getInstance().createDefaultState();
        }

        boolean isSpace() {
            return StateManager.getInstance().isSpaceState(this.mState);
        }

        boolean isNumber() {
            return StateManager.getInstance().isNumberState(this.mState);
        }

        void setImmutable() {
            this.mImmutable = true;
        }

        boolean isImmutable() {
            return this.mImmutable;
        }
    }
}

