/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ktz.puzzle.fillo.app.model;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import jp.gr.java_conf.ktz.puzzle.fillo.util.StateEventUtility;
import jp.gr.java_conf.ktz.puzzle.framework.DecoratedStateManagerImpl;
import jp.gr.java_conf.ktz.puzzle.framework.StateEventCode;
import jp.gr.java_conf.ktz.puzzle.framework.StateManagerImpl;
import jp.gr.java_conf.ktz.puzzle.framework.fsm.NumberState;
import jp.gr.java_conf.ktz.puzzle.framework.fsm.SpaceState;
import jp.gr.java_conf.ktz.puzzle.framework.fsm.State;

public class EditableNumberStateManagerImpl
extends DecoratedStateManagerImpl {
    public static final String SPACE_ID = "s";
    private Map mStateMap = new HashMap();
    private State mTransit;

    public EditableNumberStateManagerImpl() {
        this(null);
    }

    public EditableNumberStateManagerImpl(StateManagerImpl inManager) {
        super(inManager);
        this.initMap();
    }

    private void initMap() {
        StateEventCode aCode = StateEventUtility.getNumberStateEventCode(SPACE_ID);
        this.mStateMap.put(aCode, SpaceState.getInstance());
    }

    protected State createStateOfSelf(String inStateID) {
        StateEventCode aCode = StateEventUtility.getNumberStateEventCode(inStateID);
        if (aCode == null) {
            throw new IllegalArgumentException("The inStateID : '" + inStateID + "' is illegal.");
        }
        if (this.mStateMap.containsKey(aCode)) {
            return (State)this.mStateMap.get(aCode);
        }
        return this.idsToState(inStateID, aCode);
    }

    private State idsToState(String inIDs, StateEventCode inCode) {
        NumberState aState = null;
        try {
            int aNum = Integer.parseInt(inIDs);
            aState = new NumberState(aNum);
            this.mStateMap.put(inCode, aState);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("The inStateID : " + inIDs + " is illegal.");
        }
        return aState;
    }

    protected State createDefaultStateSelf() {
        return this.createStateOfSelf(SPACE_ID);
    }

    protected String findIdentityOfSelf(State inState) {
        Iterator aIt = this.mStateMap.entrySet().iterator();
        while (aIt.hasNext()) {
            Map.Entry aEntry = aIt.next();
            if (!aEntry.getValue().equals(inState)) continue;
            return ((StateEventCode)aEntry.getKey()).getValue();
        }
        return SPACE_ID;
    }

    protected State getNextStateSelf(State inState) {
        throw new UnsupportedOperationException("getNextStateSelf(State) method is not supported.");
    }

    protected State getNextStateSelf(State inState, StateEventCode inEvent) {
        return this.getTransitedState(inEvent);
    }

    protected State getPrevStateSelf(State inState) {
        throw new UnsupportedOperationException("getPrevStateSelf(State) method is not supported.");
    }

    protected State getPrevStateSelf(State inState, StateEventCode inEvent) {
        return this.getTransitedState(inEvent);
    }

    private State getTransitedState(StateEventCode inEvent) {
        State aState = (State)this.mStateMap.get(inEvent);
        if (aState != null) {
            return aState;
        }
        return this.idsToState(inEvent.getValue(), inEvent);
    }

    protected boolean isNumberStateSelf(State inState) {
        return inState instanceof NumberState;
    }

    protected boolean isSpaceStateSelf(State inState) {
        return inState instanceof SpaceState;
    }

    protected boolean isTransitSelf(State inState) {
        throw new UnsupportedOperationException("isTransitSelf(State) method is not supported.");
    }

    protected boolean isTransitSelf(State inState, StateEventCode inEvent) {
        return this.mStateMap.get(inEvent) != inState;
    }

    protected boolean acceptableEventCode(StateEventCode inEvent) {
        return StateEventUtility.isNumberStateEventCode(inEvent);
    }
}

