/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ktz.puzzle.fillo.app.view;

import java.awt.Canvas;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import jp.gr.java_conf.ktz.puzzle.fillo.app.controller.ChangeHandler;
import jp.gr.java_conf.ktz.puzzle.fillo.app.controller.FilloChangeHandler;
import jp.gr.java_conf.ktz.puzzle.fillo.app.controller.FilloProblemLoader;
import jp.gr.java_conf.ktz.puzzle.fillo.app.controller.ProblemLoader;
import jp.gr.java_conf.ktz.puzzle.fillo.app.model.BoardModel;
import jp.gr.java_conf.ktz.puzzle.fillo.app.model.SelectionModel;
import jp.gr.java_conf.ktz.puzzle.fillo.app.view.FilloDefaultRendererFactory;
import jp.gr.java_conf.ktz.puzzle.fillo.app.view.FilloRenderStrategy;
import jp.gr.java_conf.ktz.puzzle.fillo.app.view.FilloStateRendererFactory;
import jp.gr.java_conf.ktz.puzzle.fillo.app.view.InputHandler;
import jp.gr.java_conf.ktz.puzzle.fillo.app.view.RenderStrategy;
import jp.gr.java_conf.ktz.puzzle.fillo.constants.AppColors;
import jp.gr.java_conf.ktz.puzzle.fillo.util.InputUtility;
import jp.gr.java_conf.ktz.puzzle.framework.ProblemInfo;
import jp.gr.java_conf.ktz.puzzle.framework.model.Model;
import jp.gr.java_conf.ktz.puzzle.framework.util.Command;
import jp.gr.java_conf.ktz.puzzle.framework.view.CommandContainer;
import jp.gr.java_conf.ktz.puzzle.framework.view.awt.AWTDispatchCommandQueue;
import jp.gr.java_conf.ktz.puzzle.framework.view.awt.BoardView;
import jp.gr.java_conf.ktz.puzzle.framework.view.command.AbstractBottomUpCommand;
import jp.gr.java_conf.ktz.puzzle.framework.view.command.BoardSizeCommand;
import jp.gr.java_conf.ktz.puzzle.framework.view.command.LoadCommand;
import jp.gr.java_conf.ktz.puzzle.framework.view.command.PieceSizeCommand;

public class FilloBoardView
extends Canvas
implements BoardView {
    private BoardView mParent;
    private RenderStrategy mStrategy;
    private InputHandler mInputHandler;
    private ProblemLoader mProblemLoader;

    public void initialize() {
        SelectionModel aModel = new SelectionModel((Model)new BoardModel());
        aModel.createBoard(7, 7);
        this.mStrategy = new FilloRenderStrategy((Model)aModel);
        this.mStrategy.setBackground(AppColors.BACK_COLOR);
        this.mStrategy.installDefaultRenderer(new FilloDefaultRendererFactory());
        this.mStrategy.installRenderer(new FilloStateRendererFactory());
        FilloInputHandler aInputHandler = new FilloInputHandler((Model)aModel);
        this.addMouseListener(aInputHandler);
        this.addKeyListener(aInputHandler);
        this.mInputHandler = aInputHandler;
        this.mProblemLoader = new FilloProblemLoader((Model)aModel);
        this.mInputHandler.resetActivePos(0, 0);
        this.setBackground(AppColors.BACK_COLOR);
        Dimension aSize = this.mStrategy.getBoardSize();
        BoardSizeCommand aCommand = new BoardSizeCommand((CommandContainer)this, aSize.width, aSize.height);
        AWTDispatchCommandQueue.postCommand((Command)aCommand);
        aCommand = new PieceSizeCommand((CommandContainer)this, this.mStrategy.getPieceSize().width);
        AWTDispatchCommandQueue.postCommand((Command)aCommand);
    }

    private void setBoardSize(int inWidth, int inHeight) {
        this.setSize(inWidth, inHeight);
    }

    public void setParent(BoardView inBoard) {
        this.mParent = inBoard;
    }

    public boolean isModified() {
        return this.mParent.isModified();
    }

    public Component getComponent() {
        return this;
    }

    public void setFocus(boolean inFocused) {
        this.mParent.setFocus(inFocused);
    }

    public boolean isFocused() {
        return this.mParent.isFocused();
    }

    public void processCommand(Command inCommand) {
        this.processCommandImpl(inCommand);
        if (!inCommand.isConsumed() && inCommand instanceof AbstractBottomUpCommand) {
            this.mParent.processCommand(inCommand);
        }
    }

    protected void processCommandImpl(Command inCommand) {
        boolean aModified = false;
        if (inCommand instanceof LoadCommand) {
            this.loadProblem(((LoadCommand)inCommand).getProblem());
            inCommand.consume();
        } else if (inCommand instanceof BoardSizeCommand) {
            int aWidth = ((BoardSizeCommand)inCommand).getComponentWidth();
            int aHeight = ((BoardSizeCommand)inCommand).getComponentHeight();
            this.setBoardSize(aWidth, aHeight);
        }
        if (aModified) {
            Rectangle aClip = this.mStrategy.getClipBounds();
            this.repaint(aClip.x, aClip.y, aClip.width, aClip.height);
        }
    }

    private boolean loadProblem(ProblemInfo inProblem) {
        boolean aModified = this.mProblemLoader.loadProblem(inProblem);
        this.mInputHandler.resetActivePos(0, 0);
        Dimension aSize = this.mStrategy.getBoardSize();
        BoardSizeCommand aCommand = new BoardSizeCommand((CommandContainer)this, aSize.width, aSize.height);
        AWTDispatchCommandQueue.postCommand((Command)aCommand);
        return aModified;
    }

    public void update(Graphics inGra) {
        this.paint(inGra);
    }

    public void paint(Graphics inGra) {
        inGra.drawImage(this.mStrategy.render(), 0, 0, this);
    }

    private class FilloInputHandler
    implements InputHandler,
    MouseListener,
    KeyListener {
        ChangeHandler mHandler;

        FilloInputHandler(Model inModel) {
            this.mHandler = new FilloChangeHandler(inModel);
        }

        public void resetActivePos(int inX, int inY) {
            this.mHandler.notifySelectionChanged(inX, inY, false, false);
        }

        public void mousePressed(MouseEvent inEvent) {
            int aCount = inEvent.getClickCount();
            if (2 >= aCount) {
                Point aPos = FilloBoardView.this.mStrategy.calcPortToBoardPos(inEvent.getX(), inEvent.getY());
                boolean aBlockselected = this.isBlockSelected(aCount);
                boolean aModified = this.mHandler.notifySelectionChanged(aPos.x, aPos.y, aBlockselected, false);
                if (aModified) {
                    Rectangle aClip = FilloBoardView.this.mStrategy.getClipBounds();
                    FilloBoardView.this.repaint(aClip.x, aClip.y, aClip.width, aClip.height);
                }
            }
        }

        private boolean isBlockSelected(int inClickedCount) {
            if (inClickedCount == 2) {
                return true;
            }
            if (inClickedCount == 1) {
                return false;
            }
            throw new IllegalArgumentException("The clicked count must be less than or equal 2");
        }

        public void keyTyped(KeyEvent inEvent) {
            char aPressedCode = inEvent.getKeyChar();
            boolean aModified = false;
            if (InputUtility.availableInputKey(aPressedCode)) {
                aModified = this.mHandler.notifyInputOccured(InputUtility.convertValueFor(aPressedCode));
            }
            if (aModified) {
                Rectangle aClip = FilloBoardView.this.mStrategy.getClipBounds();
                FilloBoardView.this.repaint(aClip.x, aClip.y, aClip.width, aClip.height);
            }
        }

        public void keyPressed(KeyEvent inEvent) {
            int aPressedCode = inEvent.getKeyCode();
            boolean aModified = false;
            if (InputUtility.availableCursorKey(aPressedCode)) {
                aModified = this.mHandler.notifyAdjacentSelected(InputUtility.toDirection(aPressedCode), false);
            }
            if (aModified) {
                Rectangle aClip = FilloBoardView.this.mStrategy.getClipBounds();
                FilloBoardView.this.repaint(aClip.x, aClip.y, aClip.width, aClip.height);
            }
        }

        public void mouseClicked(MouseEvent inEvent) {
        }

        public void mouseReleased(MouseEvent inEvent) {
        }

        public void mouseEntered(MouseEvent inEvent) {
        }

        public void mouseExited(MouseEvent inEvent) {
        }

        public void keyReleased(KeyEvent inEvent) {
        }
    }
}

