/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ktz.puzzle.fillo.app.view;

import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import jp.gr.java_conf.ktz.puzzle.fillo.app.view.AbstractDefaultRendererFactory;
import jp.gr.java_conf.ktz.puzzle.fillo.app.view.RenderEvent;
import jp.gr.java_conf.ktz.puzzle.fillo.app.view.Renderer;
import jp.gr.java_conf.ktz.puzzle.fillo.constants.AppColors;
import jp.gr.java_conf.ktz.puzzle.framework.util.GUIUtility;

public class FilloDefaultRendererFactory
extends AbstractDefaultRendererFactory {
    protected Renderer createDefaultRenderer() {
        return new DefaltRenderer();
    }

    private static final class DefaltRenderer
    implements Renderer {
        private BufferedImage mCachedImage;

        private DefaltRenderer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void render(RenderEvent inEvent) {
            Graphics aGra = inEvent.getGraphics();
            Rectangle aBounds = inEvent.getBounds();
            if (null == this.mCachedImage) {
                Graphics aCachedGra = null;
                try {
                    this.mCachedImage = GUIUtility.createImage((int)aBounds.width, (int)aBounds.height);
                    aCachedGra = this.mCachedImage.createGraphics();
                    aCachedGra.setColor(AppColors.SPACE);
                    aCachedGra.fillRect(0, 0, aBounds.width, aBounds.height);
                    float aWidth = (float)((double)(aBounds.width > aBounds.height ? aBounds.width : aBounds.height) * 0.05);
                    aCachedGra.setColor(AppColors.WALL_COLOR);
                    ((Graphics2D)aCachedGra).setStroke(new BasicStroke(aWidth));
                    Line2D.Float aLine = new Line2D.Float();
                    ((Line2D)aLine).setLine(0.0, 0.0, (double)aBounds.width * 0.1, 0.0);
                    this.drawLine((Graphics2D)aCachedGra, aLine, 0, 0);
                    this.drawLine((Graphics2D)aCachedGra, aLine, (int)((double)aBounds.width * 0.9), 0);
                    this.drawLine((Graphics2D)aCachedGra, aLine, 0, aBounds.height);
                    this.drawLine((Graphics2D)aCachedGra, aLine, (int)((double)aBounds.width * 0.9), aBounds.height);
                    ((Line2D)aLine).setLine(0.0, 0.0, 0.0, (int)((double)aBounds.height * 0.1));
                    this.drawLine((Graphics2D)aCachedGra, aLine, 0, 0);
                    this.drawLine((Graphics2D)aCachedGra, aLine, aBounds.width, 0);
                    this.drawLine((Graphics2D)aCachedGra, aLine, 0, (int)((double)aBounds.height * 0.9));
                    this.drawLine((Graphics2D)aCachedGra, aLine, aBounds.width, (int)((double)aBounds.height * 0.9));
                }
                finally {
                    aCachedGra.dispose();
                }
            }
            aGra.translate(aBounds.x, aBounds.y);
            aGra.drawImage(this.mCachedImage, 0, 0, null);
            aGra.translate(-aBounds.x, -aBounds.y);
        }

        private void drawLine(Graphics2D inGra, Line2D inLine, int inOffX, int inOffY) {
            inGra.translate(inOffX, inOffY);
            inGra.draw(inLine);
            inGra.translate(-inOffX, -inOffY);
        }
    }
}

