/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ktz.puzzle.fillo.app.view;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Area;
import jp.gr.java_conf.ktz.puzzle.fillo.app.view.AbstractDefaultRendererFactory;
import jp.gr.java_conf.ktz.puzzle.fillo.app.view.FilloRendererLocator;
import jp.gr.java_conf.ktz.puzzle.fillo.app.view.RenderEvent;
import jp.gr.java_conf.ktz.puzzle.fillo.app.view.RenderStrategy;
import jp.gr.java_conf.ktz.puzzle.fillo.app.view.Renderer;
import jp.gr.java_conf.ktz.puzzle.fillo.app.view.RendererFactory;
import jp.gr.java_conf.ktz.puzzle.fillo.app.view.RendererLocator;
import jp.gr.java_conf.ktz.puzzle.framework.fsm.State;
import jp.gr.java_conf.ktz.puzzle.framework.model.Model;
import jp.gr.java_conf.ktz.puzzle.framework.util.GUIUtility;

public class FilloRenderStrategy
implements RenderStrategy {
    private static final int DEFAULT_PIECE_SIZE = 24;
    private int mPieceUnit = 24;
    private Image mOffImage;
    private Model mModel;
    private int mWidth;
    private int mHeight;
    private RendererLocator mLocator = new FilloRendererLocator();
    private RenderEvent mEvent;
    private Color mBackColor = Color.black;

    public FilloRenderStrategy(Model inModel) {
        this.mModel = inModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image render() {
        if (this.mModel.isModified()) {
            Point[] aPos = this.mModel.lastModified();
            Graphics aGraphics = this.mOffImage.getGraphics();
            try {
                Renderer aDefault = this.mLocator.getDefaultRenderer();
                for (int i = 0; i < aPos.length; ++i) {
                    State aState = this.mModel.getCurStateAt(aPos[i].x, aPos[i].y);
                    Renderer aListener = this.mLocator.lookup(aState);
                    this.resetRenderEvent(aPos[i], aState, aGraphics);
                    aDefault.render(this.mEvent);
                    if (aDefault == aListener) continue;
                    aListener.render(this.mEvent);
                }
            }
            finally {
                aGraphics.dispose();
            }
            this.mModel.flush();
        }
        return this.getRenderedImage();
    }

    private void resetRenderEvent(Point inPos, State inState, Graphics inGra) {
        inGra.setColor(this.mBackColor);
        if (null == this.mEvent) {
            Rectangle aBounds = new Rectangle(inPos.x * this.mPieceUnit, inPos.y * this.mPieceUnit, this.mPieceUnit, this.mPieceUnit);
            this.mEvent = new RenderEvent(this.mLocator, inGra, this.mBackColor, aBounds, inState);
        } else {
            Rectangle aBounds = this.mEvent.getBounds();
            aBounds.setBounds(inPos.x * this.mPieceUnit, inPos.y * this.mPieceUnit, this.mPieceUnit, this.mPieceUnit);
            this.mEvent.reset(this.mLocator, inGra, this.mBackColor, aBounds, inState);
        }
    }

    public void installRenderer(RendererFactory inFactory) {
        this.mLocator.installRenderer(inFactory);
    }

    public void installDefaultRenderer(AbstractDefaultRendererFactory inFactory) {
        this.mLocator.installDefaultRenderer(inFactory);
    }

    public Image getRenderedImage() {
        if (null == this.mOffImage) {
            this.setSize(this.mModel.getWidth(), this.mModel.getHeight());
        }
        return this.mOffImage;
    }

    public void setBackground(Color inColor) {
        this.mBackColor = inColor;
    }

    public void setSize(int inWidth, int inHeight) {
        if (null != this.mOffImage && this.mModel.getWidth() == inWidth && this.mModel.getHeight() == inHeight) {
            return;
        }
        int aImageWidth = inWidth * this.mPieceUnit;
        int aImageHeight = inHeight * this.mPieceUnit;
        this.mOffImage = GUIUtility.createImage((int)aImageWidth, (int)aImageHeight);
        this.mWidth = inWidth;
        this.mHeight = inHeight;
    }

    public Dimension getBoardSize() {
        if (null == this.mOffImage || this.mModel.getWidth() != this.mWidth || this.mModel.getHeight() != this.mHeight) {
            this.mOffImage = null;
            this.setSize(this.mModel.getWidth(), this.mModel.getHeight());
        }
        return new Dimension(this.mOffImage.getWidth(null), this.mOffImage.getHeight(null));
    }

    public void setPieceSize(Dimension inSize) {
        this.mPieceUnit = inSize.width;
    }

    public Dimension getPieceSize() {
        return new Dimension(this.mPieceUnit, this.mPieceUnit);
    }

    public Point calcPortToBoardPos(int inX, int inY) {
        return new Point((int)Math.floor((double)inX / (double)this.mPieceUnit), (int)Math.floor((double)inY / (double)this.mPieceUnit));
    }

    public Rectangle getClipBounds() {
        return this.calcClip().getBounds();
    }

    private Shape calcClip() {
        Area aArea = new Area();
        Rectangle aBounds = new Rectangle();
        Point[] aPos = this.mModel.lastModified();
        for (int i = 0; i < aPos.length; ++i) {
            aBounds.setBounds(aPos[i].x * this.mPieceUnit, aPos[i].y * this.mPieceUnit, this.mPieceUnit, this.mPieceUnit);
            aArea.add(new Area(aBounds));
        }
        return aArea;
    }

    RendererLocator getLocator() {
        return this.mLocator;
    }
}

