/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding.classes;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.generic.ANEWARRAY;
import org.apache.bcel.generic.BranchHandle;
import org.apache.bcel.generic.BranchInstruction;
import org.apache.bcel.generic.CompoundInstruction;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.LocalVariableGen;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.NEWARRAY;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.Type;
import org.jibx.binding.classes.BindingMethod;
import org.jibx.binding.classes.ClassFile;
import org.jibx.binding.classes.ClassItem;
import org.jibx.binding.classes.InstructionBuilder;
import org.jibx.runtime.JiBXException;

public abstract class MethodBuilder
extends BindingMethod {
    public static final String FRAMEWORK_EXCEPTION_CLASS = "org.jibx.runtime.JiBXException";
    public static final String EXCEPTION_CONSTRUCTOR_SIGNATURE1 = "(Ljava/lang/String;)V";
    public static final String EXCEPTION_CONSTRUCTOR_SIGNATURE2 = "(Ljava/lang/String;Ljava/lang/Throwable;)V";
    protected static ArrayList s_argNameLists = new ArrayList();
    protected InstructionBuilder m_instructionBuilder;
    protected InstructionList m_instructionList;
    protected MethodGen m_generator;
    protected Method m_method;
    protected ClassItem m_item;
    protected ArrayList m_exceptions;
    protected int m_hashCode;
    protected BranchHandle[] m_targetBranches;
    protected HashMap m_valueMap;

    protected MethodBuilder(String name, Type ret, Type[] args, ClassFile cf, int access) throws JiBXException {
        super(cf);
        if (args.length >= s_argNameLists.size()) {
            int i = s_argNameLists.size();
            while (i <= args.length) {
                String[] list = new String[i];
                if (i > 0) {
                    Object last = s_argNameLists.get(i - 1);
                    System.arraycopy(last, 0, list, 0, i - 1);
                    list[i - 1] = "arg" + i;
                }
                s_argNameLists.add(list);
                ++i;
            }
        }
        String[] names = (String[])s_argNameLists.get(args.length);
        this.m_instructionList = new InstructionList();
        this.m_instructionBuilder = cf.getInstructionBuilder();
        this.m_generator = new MethodGen(access, ret, args, names, name, cf.getName(), this.m_instructionList, cf.getConstPoolGen());
    }

    public String getName() {
        return this.m_generator.getName();
    }

    public String getSignature() {
        return this.m_generator.getSignature();
    }

    public int getAccessFlags() {
        return this.m_generator.getAccessFlags();
    }

    public void setAccessFlags(int flags) {
        this.m_generator.setAccessFlags(flags);
    }

    public Method getMethod() {
        if (this.m_method == null) {
            throw new IllegalStateException("Method still under construction");
        }
        return this.m_method;
    }

    public Object setKeyValue(Object key, Object value) {
        if (this.m_valueMap == null) {
            this.m_valueMap = new HashMap();
        }
        return this.m_valueMap.put(key, value);
    }

    public Object getKeyValue(Object key) {
        return this.m_valueMap == null ? null : this.m_valueMap.get(key);
    }

    public void addException(String name) {
        if (this.m_exceptions == null) {
            this.m_exceptions = new ArrayList();
        }
        if (!this.m_exceptions.contains(name)) {
            this.m_exceptions.add(name);
        }
    }

    public void addMethodExceptions(ClassItem method) {
        String[] excepts = method.getExceptions();
        if (excepts != null) {
            int i = 0;
            while (i < excepts.length) {
                this.addException(excepts[i]);
                ++i;
            }
        }
    }

    public InstructionHandle getFirstInstruction() {
        return this.m_instructionList.getStart();
    }

    public InstructionHandle getLastInstruction() {
        return this.m_instructionList.getEnd();
    }

    protected final void setTarget(InstructionHandle inst) {
        if (this.m_targetBranches != null) {
            int i = 0;
            while (i < this.m_targetBranches.length) {
                this.m_targetBranches[i].setTarget(inst);
                ++i;
            }
            this.m_targetBranches = null;
        }
    }

    public BranchHandle append(BranchInstruction ins) {
        BranchHandle hand = this.m_instructionList.append(ins);
        this.setTarget((InstructionHandle)hand);
        return hand;
    }

    public InstructionHandle append(CompoundInstruction ins) {
        InstructionHandle hand = this.m_instructionList.append(ins);
        this.setTarget(hand);
        return hand;
    }

    public InstructionHandle append(Instruction ins) {
        InstructionHandle hand = this.m_instructionList.append(ins);
        this.setTarget(hand);
        return hand;
    }

    public InstructionHandle appendLoadConstant(int value) {
        return this.append(this.m_instructionBuilder.createLoadConstant(value));
    }

    public InstructionHandle appendLoadConstant(String value) {
        return this.append(this.m_instructionBuilder.createLoadConstant(value));
    }

    public InstructionHandle appendLoadConstant(Object value) {
        return this.append(this.m_instructionBuilder.createLoadConstant(value));
    }

    public InstructionHandle appendGetField(ClassItem item) {
        return this.append((Instruction)this.m_instructionBuilder.createGetField(item));
    }

    public InstructionHandle appendPutField(ClassItem item) {
        return this.append((Instruction)this.m_instructionBuilder.createPutField(item));
    }

    public InstructionHandle appendGetStatic(ClassItem item) {
        return this.append((Instruction)this.m_instructionBuilder.createGetStatic(item));
    }

    public InstructionHandle appendPutStatic(ClassItem item) {
        return this.append((Instruction)this.m_instructionBuilder.createPutStatic(item));
    }

    public InstructionHandle appendCall(ClassItem item) {
        if ((item.getAccessFlags() & 8) == 0) {
            return this.append((Instruction)this.m_instructionBuilder.createCallVirtual(item));
        }
        return this.append((Instruction)this.m_instructionBuilder.createCallStatic(item));
    }

    public InstructionHandle appendCallStatic(String method, String signature) {
        return this.append((Instruction)this.m_instructionBuilder.createCallStatic(method, signature));
    }

    public InstructionHandle appendCallVirtual(String method, String signature) {
        return this.append((Instruction)this.m_instructionBuilder.createCallVirtual(method, signature));
    }

    public InstructionHandle appendCallInterface(String method, String signature) {
        return this.append((Instruction)this.m_instructionBuilder.createCallInterface(method, signature));
    }

    public InstructionHandle appendCreateNew(String name) {
        return this.append((Instruction)this.m_instructionBuilder.createNew(name));
    }

    public InstructionHandle appendCallInit(String name, String signature) {
        return this.append((Instruction)this.m_instructionBuilder.createCallInit(name, signature));
    }

    public InstructionHandle appendCreateArray(String type) {
        if (ClassItem.isPrimitive(type)) {
            String sig = Utility.getSignature((String)type);
            return this.append((Instruction)new NEWARRAY(Utility.typeOfSignature((String)sig)));
        }
        return this.append((Instruction)new ANEWARRAY(this.m_instructionBuilder.getConstantPoolGen().addClass(type)));
    }

    public InstructionHandle appendCreateCast(String from, String to) {
        if (from.equals(to)) {
            return null;
        }
        return this.append(this.m_instructionBuilder.createCast((Type)new ObjectType(from), (Type)new ObjectType(to)));
    }

    public InstructionHandle appendCreateCast(String to) {
        if ("java.lang.Object".equals(to)) {
            return null;
        }
        return this.append(this.m_instructionBuilder.createCast((Type)Type.OBJECT, (Type)new ObjectType(to)));
    }

    public InstructionHandle appendInstanceOf(String to) {
        if ("java.lang.Object".equals(to)) {
            InstructionHandle handle = this.append((Instruction)InstructionConstants.POP);
            this.appendLoadConstant(1);
            return handle;
        }
        return this.append((Instruction)this.m_instructionBuilder.createInstanceOf(new ObjectType(to)));
    }

    protected LocalVariableGen createLocal(String name, Type type) {
        LocalVariableGen var = this.m_generator.addLocalVariable(name, type, this.getLastInstruction(), null);
        this.append((Instruction)InstructionFactory.createStore((Type)type, (int)var.getIndex()));
        return var;
    }

    public int addLocal(String name, Type type) {
        LocalVariableGen var = this.createLocal(name, type);
        return var.getIndex();
    }

    public void targetNext(BranchHandle branch) {
        if (branch != null) {
            if (this.m_targetBranches == null) {
                this.m_targetBranches = new BranchHandle[]{branch};
            } else {
                int length = this.m_targetBranches.length;
                BranchHandle[] handles = new BranchHandle[length + 1];
                System.arraycopy(this.m_targetBranches, 0, handles, 0, length);
                handles[length] = branch;
                this.m_targetBranches = handles;
            }
        }
    }

    protected abstract void handleExceptions() throws JiBXException;

    public void codeComplete(boolean suffix) throws JiBXException {
        if (this.m_targetBranches != null) {
            throw new IllegalStateException("Method complete with pending branch target");
        }
        if (this.m_exceptions != null) {
            this.handleExceptions();
        }
        if (suffix) {
            this.m_generator.setName(this.m_classFile.makeUniqueMethodName(this.m_generator.getName()));
        }
        this.m_generator.setMaxStack();
        this.m_generator.setMaxLocals();
        this.m_instructionList.setPositions(true);
        this.m_method = this.m_generator.getMethod();
        this.m_instructionList.dispose();
        this.m_hashCode = BindingMethod.computeMethodHash(this.m_method);
    }

    public ClassItem getItem() {
        if (this.m_item == null) {
            throw new IllegalStateException("Method not added to class");
        }
        return this.m_item;
    }

    public int hashCode() {
        if (this.m_method == null) {
            throw new IllegalStateException("Method still under construction");
        }
        return this.m_hashCode;
    }

    public ClassItem addMethod() throws JiBXException {
        if (this.m_method == null) {
            throw new IllegalStateException("Method not finalized.");
        }
        this.m_item = this.m_classFile.addMethod(this.m_method);
        return this.m_item;
    }
}

