/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding.def;

import org.apache.bcel.generic.BranchHandle;
import org.apache.bcel.generic.BranchInstruction;
import org.apache.bcel.generic.GOTO;
import org.apache.bcel.generic.IFNE;
import org.apache.bcel.generic.IFNONNULL;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionConstants;
import org.jibx.binding.classes.ClassCache;
import org.jibx.binding.classes.ClassFile;
import org.jibx.binding.classes.ClassItem;
import org.jibx.binding.classes.MethodBuilder;
import org.jibx.binding.def.StringConversion;
import org.jibx.runtime.JiBXException;

public class ObjectStringConversion
extends StringConversion {
    private static final String TOSTRING_METHOD = "toString";
    private static final String TOSTRING_SIGNATURE = "()Ljava/lang/String;";
    private static final String FROMSTRING_SIGNATURE = "(Ljava/lang/String;)V";
    private boolean m_needDeserialize;
    private ClassItem m_initFromString;
    private boolean m_needSerialize;
    private ClassItem m_instToString;

    ObjectStringConversion(String type, ObjectStringConversion inherit) throws JiBXException {
        super(type, inherit);
        if (type.equals(inherit.m_typeName)) {
            this.m_needDeserialize = inherit.m_needDeserialize;
            this.m_initFromString = inherit.m_initFromString;
            this.m_needSerialize = inherit.m_needSerialize;
            this.m_instToString = inherit.m_instToString;
        } else {
            this.initMethods();
        }
    }

    ObjectStringConversion(Object dflt, String ser, String deser, String type) {
        super(dflt, ser, deser, type);
        try {
            this.initMethods();
        }
        catch (JiBXException ex) {
            throw new IllegalArgumentException(ex.getMessage());
        }
    }

    private void initMethods() throws JiBXException {
        if (!"java.lang.String".equals(this.m_typeName)) {
            this.m_needSerialize = true;
            this.m_needDeserialize = !"java.lang.Object".equals(this.m_typeName);
            ClassFile cf = ClassCache.getClassFile(this.m_typeName);
            this.m_initFromString = cf.getInitializerMethod(FROMSTRING_SIGNATURE);
            this.m_instToString = cf.getMethod(TOSTRING_METHOD, TOSTRING_SIGNATURE);
        }
    }

    public void genFromText(MethodBuilder mb) throws JiBXException {
        if (this.m_deserializer != null) {
            mb.addMethodExceptions(this.m_deserializer);
            mb.appendCall(this.m_deserializer);
        } else if (this.m_initFromString != null) {
            mb.append((Instruction)InstructionConstants.DUP);
            BranchHandle ifnnull = mb.append((BranchInstruction)new IFNONNULL(null));
            mb.append((Instruction)InstructionConstants.POP);
            mb.append(InstructionConstants.ACONST_NULL);
            BranchHandle toend = mb.append((BranchInstruction)new GOTO(null));
            ifnnull.setTarget(mb.appendCreateNew(this.m_typeName));
            mb.append((Instruction)InstructionConstants.DUP_X1);
            mb.append((Instruction)InstructionConstants.SWAP);
            mb.appendCallInit(this.m_typeName, FROMSTRING_SIGNATURE);
            mb.targetNext(toend);
        } else if (this.m_needDeserialize) {
            throw new JiBXException("No deserializer for " + this.m_typeName + "; define serializer or toString() method");
        }
    }

    public void genParseOptional(boolean attr, MethodBuilder mb) throws JiBXException {
        mb.appendLoadConstant((String)this.m_default);
        String name = attr ? "org.jibx.runtime.impl.UnmarshallingContext.attributeText" : "org.jibx.runtime.impl.UnmarshallingContext.parseElementText";
        mb.appendCallVirtual(name, "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;");
        this.genFromText(mb);
    }

    public void genParseRequired(boolean attr, MethodBuilder mb) throws JiBXException {
        String name = attr ? "org.jibx.runtime.impl.UnmarshallingContext.attributeText" : "org.jibx.runtime.impl.UnmarshallingContext.parseElementText";
        mb.appendCallVirtual(name, "(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;");
        this.genFromText(mb);
    }

    public void genToText(String type, MethodBuilder mb) throws JiBXException {
        if (this.m_serializer == null && this.m_needSerialize) {
            if (this.m_instToString == null) {
                throw new JiBXException("No serializer for " + this.m_typeName + "; define serializer or toString() method");
            }
            mb.addMethodExceptions(this.m_instToString);
            mb.appendCall(this.m_instToString);
        } else {
            super.genToText(type, mb);
        }
    }

    protected BranchHandle genToOptionalText(String type, MethodBuilder mb, int extra) throws JiBXException {
        if (this.m_default == null) {
            this.genToText(type, mb);
            return null;
        }
        this.genToText(type, mb);
        mb.append((Instruction)InstructionConstants.DUP);
        mb.appendLoadConstant((String)this.m_default);
        mb.appendCallStatic("org.jibx.runtime.Utility.isEqual", "(Ljava/lang/Object;Ljava/lang/Object;)Z");
        BranchHandle ifne = mb.append((BranchInstruction)new IFNE(null));
        this.genPopValues(extra + 1, mb);
        BranchHandle toend = mb.append((BranchInstruction)new GOTO(null));
        mb.targetNext(ifne);
        return toend;
    }

    public boolean isPrimitive() {
        return false;
    }

    protected Object convertDefault(String text) throws JiBXException {
        return text;
    }

    public StringConversion derive(String type, String ser, String dser, String dflt) throws JiBXException {
        if (type == null) {
            type = this.m_typeName;
        }
        ObjectStringConversion inst = new ObjectStringConversion(type, this);
        if (ser != null) {
            inst.setSerializer(ser);
        }
        if (dser != null) {
            inst.setDeserializer(dser);
        }
        if (dflt != null) {
            inst.m_default = ((StringConversion)inst).convertDefault(dflt);
        }
        return inst;
    }
}

