/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ktz.puzzle.framework.model;

import java.awt.Dimension;
import java.awt.Point;
import java.util.Arrays;
import java.util.HashSet;
import jp.gr.java_conf.ktz.puzzle.framework.ModelState;
import jp.gr.java_conf.ktz.puzzle.framework.ProblemInfo;
import jp.gr.java_conf.ktz.puzzle.framework.StateEventCode;
import jp.gr.java_conf.ktz.puzzle.framework.fsm.State;
import jp.gr.java_conf.ktz.puzzle.framework.model.Model;
import jp.gr.java_conf.ktz.puzzle.framework.model.NullModel;

public abstract class AbstractDecoratedModel
implements Model {
    protected Model mModel;

    protected AbstractDecoratedModel() {
        this(NullModel.getInstance());
    }

    protected AbstractDecoratedModel(Model inModel) {
        this.addModel(inModel);
    }

    public void addModel(Model inModel) {
        Model aModel = this.getDecorated();
        if ((!(aModel instanceof NullModel) || null != aModel) && aModel instanceof AbstractDecoratedModel) {
            ((AbstractDecoratedModel)aModel).addModel(inModel);
            return;
        }
        this.mModel = inModel;
    }

    protected Model getDecorated() {
        return this.mModel;
    }

    public final void createBoard(int inWidth, int inHeight) {
        this.createBoardSelf(inWidth, inHeight);
        this.mModel.createBoard(inWidth, inHeight);
    }

    protected abstract void createBoardSelf(int var1, int var2);

    public int setProblem(ProblemInfo inProblem) {
        return this.mModel.setProblem(inProblem);
    }

    public void initProblemAt(int inX, int inY, Object inRecord) {
        this.initProblemAtSelf(inX, inY, inRecord);
        this.mModel.initProblemAt(inX, inY, inRecord);
    }

    protected abstract void initProblemAtSelf(int var1, int var2, Object var3);

    public boolean check() {
        return this.mModel.check();
    }

    public void reset() {
        this.mModel.reset();
    }

    public void resetAt(int inX, int inY) {
        this.resetAtSelf(inX, inY);
        this.mModel.resetAt(inX, inY);
    }

    protected abstract void resetAtSelf(int var1, int var2);

    public void setModelState(ModelState inState) {
        if (this.acceptableModelState(inState)) {
            this.setModelStateSelf(inState);
        }
        this.mModel.setModelState(inState);
    }

    protected boolean acceptableModelState(ModelState inState) {
        return false;
    }

    protected void setModelStateSelf(ModelState inState) {
    }

    public Dimension getSize() {
        return this.mModel.getSize();
    }

    public int getWidth() {
        return this.mModel.getWidth();
    }

    public int getHeight() {
        return this.mModel.getHeight();
    }

    public State getCurStateAt(int inX, int inY) {
        return this.mModel.getCurStateAt(inX, inY);
    }

    public State getCorrectStateAt(int inX, int inY) {
        return this.mModel.getCorrectStateAt(inX, inY);
    }

    protected abstract boolean isAcceptableEvent(StateEventCode var1);

    public void nextStateAt(int inX, int inY) {
        this.mModel.nextStateAt(inX, inY);
    }

    public void nextStateAt(int inX, int inY, StateEventCode inCode) {
        if (this.isAcceptableEvent(inCode)) {
            this.nextStateAtSelf(inX, inY, inCode);
        }
        this.mModel.nextStateAt(inX, inY, inCode);
    }

    protected abstract void nextStateAtSelf(int var1, int var2, StateEventCode var3);

    public void prevStateAt(int inX, int inY) {
        this.mModel.prevStateAt(inX, inY);
    }

    public void prevStateAt(int inX, int inY, StateEventCode inCode) {
        if (this.isAcceptableEvent(inCode)) {
            this.prevStateAtSelf(inX, inY, inCode);
        }
        this.mModel.prevStateAt(inX, inY, inCode);
    }

    protected abstract void prevStateAtSelf(int var1, int var2, StateEventCode var3);

    public final Point[] lastModified() {
        Point[] aPos1 = this.mModel.lastModified();
        Point[] aPos2 = this.lastModifiedSelf();
        if (0 == aPos1.length) {
            return aPos2;
        }
        if (0 < aPos2.length) {
            HashSet<Point> aSet = new HashSet<Point>();
            aSet.addAll(Arrays.asList(aPos1));
            aSet.addAll(Arrays.asList(aPos2));
            Point[] aRet = aSet.toArray(new Point[aSet.size()]);
            aSet.clear();
            return aRet;
        }
        return aPos1;
    }

    protected abstract Point[] lastModifiedSelf();

    public boolean contains(int inX, int inY) {
        return this.mModel.contains(inX, inY);
    }

    public boolean isTransitAt(int inX, int inY) {
        return this.mModel.isTransitAt(inX, inY);
    }

    public boolean isTransitAt(int inX, int inY, StateEventCode inTransitCode) {
        return this.mModel.isTransitAt(inX, inY, inTransitCode);
    }

    public boolean isSpaceAt(int inX, int inY) {
        return this.mModel.isSpaceAt(inX, inY);
    }

    public boolean isNumberAt(int inX, int inY) {
        return this.mModel.isNumberAt(inX, inY);
    }

    public final boolean isModified() {
        return this.mModel.isModified() || this.isModifiedSelf();
    }

    protected abstract boolean isModifiedSelf();

    public final void flush() {
        this.mModel.flush();
        this.flushSelf();
    }

    protected abstract void flushSelf();
}

