//
//	Copyright (C) 2003 Kazuhiko TAMURA. All rights reserved.
//
//	This library is free software; you can redistribute it and/or
//	modify it under the terms of the GNU Lesser General Public
//	License as published by the Free Software Foundation; either
//	version 2.1 of the License, or (at your option) any later version.
//
//	This library is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//	Lesser General Public License for more details.
//
//	You should have received a copy of the GNU Lesser General Public
//	License along with this library; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//	NAME:		DecoratedStateManagerImpl.java
//	DATE:		2003.7.1
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.framework;

import jp.gr.java_conf.ktz.puzzle.framework.fsm.State;
import jp.gr.java_conf.ktz.puzzle.framework.fsm.NullState;

/**
 *	KwꂽԑJڂ邽߂̃IuWFNg
 *	̎ŁAȂꍇAʂStateManagerImpl
 *	bZ[W]B
 *
 *	@see	State
 *	@see	StateManagerImpl
 */
public abstract class DecoratedStateManagerImpl implements StateManagerImpl {
	/** ʂStateManagerImpl */
	protected StateManagerImpl mDecorated;
	
	/** ȂԂ\ĂȂƂ萔 */
	protected static final State NULL_STATE = new NullState();
	
	/**
	 *	ʂManagerύX
	 *	ɊKwĂꍇAKwj󂳂̂Œ
	 *
	 *	@param	inManager	ʂɔzuStateManager
	 */
	public final void addStateManager(StateManagerImpl inManager) {
		mDecorated = inManager;
	}
	
	/**
	 *	w肳ꂽIDɑΉԂ쐬B
	 *
	 *	@param	inStateID ԂɑΉID
	 *	@return 쐬ꂽ
	 */
	public final State createStateOf(String inStateID) {
		if (null != mDecorated) {
			return mDecorated.createStateOf(inStateID);
		}

		return createStateOfSelf(inStateID);
	}
	
	/**
	 *	w肳ꂽIDɑΉԂ쐬B
	 *
	 *	̃\bh́AcreateStateOfĂ΂B
	 *
	 *	@param	inStateID ԂɑΉID
	 *	@return 쐬ꂽ
	 */
	protected abstract State createStateOfSelf(String inStateID);
	
	/**
	 *	ftHg̏Ԃ쐬B
	 *
	 *	@param	inStateID ԂɑΉID
	 *	@return 쐬ꂽ
	 */
	public final State createDefaultState() {
		if (null != mDecorated) {
			return mDecorated.createDefaultState();
		}
		
		return createDefaultStateSelf();
	}
	
	/**
	 *	ftHg̏Ԃ쐬B
	 *
	 *	̃\bh́AcreateDefaultStateOfSelfĂ΂B
	 *
	 *	@param	inStateID ԂɑΉID
	 *	@return 쐬ꂽ
	 */
	protected abstract State createDefaultStateSelf();
	
	/**
	 *	w肵ԂɑΉAIDԂB
	 *	́AcreateStateOf̋t̑łB
	 *
	 *	@param	inState ϊ
	 *	@return	ԂɑΉAID
	 */
	public final String findIdentityOf(State inState) {
		State aState = peelState(inState);
		
		if (null != mDecorated) {
			return mDecorated.findIdentityOf(aState);
		}
		
		return findIdentityOfSelf(aState);
	}
	
	/**
	 *	w肵ԂKwĂꍇA
	 *	ȌԂ𔍂B
	 *	AAȌԂAManagerƊ֘AtĂȂꍇ͉A
	 *	̂܂ܕԂ
	 *
	 *	̃\bh́AfindIdentityOfĂ΂B
	 *
	 *	@param	inState	Ώۂ̏
	 *
	 *	@return	̏
	 */
	protected State peelState(State inState) {
		return inState;
	}
	
	/**
	 *	w肵ԂɑΉAIDԂB
	 *	́AcreateStateOf̋t̑łB
	 *
	 *	̃\bh́AfindIdentityOfĂ΂B
	 *
	 *	@param	inState ϊ
	 *	@return	ԂɑΉAID
	 */
	protected abstract String findIdentityOfSelf(State inState);
	
	/**
	 *	Ԃ1i߂B
	 *
	 *	@param inState ݂̏
	 *	@return ̏
	 */
	public final State getNextState(State inState) {
		if (null != mDecorated) {
			return mDecorated.getNextState(inState);
		}
		
		return getNextStateSelf(inState);
	}
	
	/**
	 *	Ԃ1i߂B
	 *
	 *	̃\bh́AgetNextStateĂ΂B
	 *
	 *	@param inState ݂̏
	 *	@return ̏
	 */
	protected abstract State getNextStateSelf(State inState);
	
	/**
	 *	Ԃ1i߂B
	 *	ŁAinEventlɏ]ēJڂs
	 *
	 *	@param inState ݂̏
	 *	@param inEvent JڂɊւCxgl
	 *	@return ̏
	 */
	public final State getNextState(State inState, StateEventCode inEvent) {
		if (acceptableEventCode(inEvent)) {
			return getNextStateSelf(inState, inEvent);
		}
		if (null != mDecorated) {
			return mDecorated.getNextState(inState, inEvent);
		}
		
		return NULL_STATE;
	}
	
	/**
	 *	Ԃ1i߂B
	 *	ŁAinEventlɏ]ēJڂs
	 *
	 *	̃\bh́AgetNextStateĂ΂B
	 *
	 *	@param inState ݂̏
	 *	@param inEvent JڂɊւCxgl
	 *	@return ̏
	 */	
	protected abstract State getNextStateSelf(State inState, StateEventCode inEvent);
	
	/**
	 *	Ԃ1߂B
	 *
	 *	@param inState ݂̏
	 *	@return ̏
	 */
	public final State getPrevState(State inState) {
		if (null != mDecorated) {
			return mDecorated.getPrevState(inState);
		}
		
		return getPrevStateSelf(inState);
	}
	
	/**
	 *	Ԃ1߂B
	 *
	 *	̃\bh́AgetPrevStateSelfĂ΂B
	 *
	 *	@param inState ݂̏
	 *	@return ̏
	 */
	protected abstract State getPrevStateSelf(State inState);

	/**
	 *	Ԃ1߂B
	 *	ŁAinEventlɏ]ēJڂs
	 *
	 *	@param inState ݂̏
	 *	@param inEvent JڂɊւCxgl
	 *	@return ̏
	 */
	public final State getPrevState(State inState, StateEventCode inEvent) {
		if (acceptableEventCode(inEvent)) {
			return getPrevStateSelf(inState, inEvent);
		}
		if (null != mDecorated) {
			return mDecorated.getPrevState(inState, inEvent);
		}
		
		return NULL_STATE;
	}
	
	/**
	 *	Ԃ1߂B
	 *	ŁAinEventlɏ]ēJڂs
	 *
	 *	̃\bh́AgetPrevStateĂ΂B
	 *
	 *	@param inState ݂̏
	 *	@param inEvent JڂɊւCxgl
	 *	@return ̏
	 */
	protected abstract State getPrevStateSelf(State inState, StateEventCode inEvent);
	
	/**
	 *	w肳ꂽԂł邩ǂׂ
	 *
	 *	@param	inState 
	 *	@return	łtrueԂB
	 */
	public final boolean isNumberState(State inState) {
		if (null != mDecorated) {
			return mDecorated.isNumberState(inState);
		}
		
		return isNumberStateSelf(inState);
	}
	
	/**
	 *	w肳ꂽԂł邩ǂׂ
	 *
	 *	̃\bh́AisNumberStateĂ΂B
	 *
	 *	@param	inState 
	 *	@return	łtrueԂB
	 */
	protected abstract boolean isNumberStateSelf(State inState);

	/**
	 *	w肳ꂽԂ󔒂ł邩ǂׂ
	 *
	 *	@param	inState 
	 *	@return	󔒂łtrueԂB
	 */
	public final boolean isSpaceState(State inState) {
		if (null != mDecorated) {
			return mDecorated.isSpaceState(inState);
		}
		
		return isSpaceStateSelf(inState);
	}
	
	/**
	 *	w肳ꂽԂ󔒂ł邩ǂׂ
	 *
	 *	̃\bh́AisSpaceStateĂ΂B
	 *
	 *	@param	inState 
	 *	@return	󔒂łtrueԂB
	 */
	protected abstract boolean isSpaceStateSelf(State inState);

	/**
	 *	w肳ꂽԂAJڂł邩ǂ`FbNB
	 *	̎ł́AJڂ܂ł̃`FbN͍sȂB
	 *
	 *	@param inState `FbNState object
	 *	@return Jڂł̂ł΁AtrueԂB
	 */
	public final boolean isTransit(State inState) {
		if (null != mDecorated) {
			return mDecorated.isTransit(inState);
		}
		
		return isTransitSelf(inState);
	}
	
	/**
	 *	w肳ꂽԂAJڂł邩ǂ`FbNB
	 *	̎ł́AJڂ܂ł̃`FbN͍sȂB
	 *
	 *	̃\bh́AisTransitĂ΂B
	 *
	 *	@param inState `FbNState object
	 *	@return Jڂł̂ł΁AtrueԂB
	 */
	protected abstract boolean isTransitSelf(State inState);

	/**
	 *	w肳ꂽԂAJڂł邩ǂ`FbNB
	 *
	 *	@param inState `FbNState object
	 *	@param inEvent ɓJڂ҂̂łΎw肷B
	 *	@return Jڂł̂ł΁AtrueԂB
	 */
	public final boolean isTransit(State inState, StateEventCode inEvent) {
		if (acceptableEventCode(inEvent)) {
			return isTransitSelf(inState, inEvent);
		}
		if (null != mDecorated) {
			return mDecorated.isTransit(inState, inEvent);
		}
		
		return false;
	}
	
	/**
	 *	w肳ꂽԂAJڂł邩ǂ`FbNB
	 *
	 *	̃\bh́AisTransitĂ΂B
	 *
	 *	@param inState `FbNState object
	 *	@param inEvent ɓJڂ҂̂łΎw肷B
	 *	@return Jڂł̂ł΁AtrueԂB
	 */
	protected abstract boolean isTransitSelf(State inState, StateEventCode inEvent);
	
	/**
	 *	w肵StateEventCodeStateManagerŏł邩ǂ`FbN
	 *
	 *	@param	inEvent	Cxg̎
	 *	@return	łꍇAtrueԂ
	 *
	 *	@see #isTransit(State, StateEventCode)
	 *	@see #getNextState(State, StateEventCode)
	 *	@see #getPrevState(State, StateEventCode)
	 */
	protected abstract boolean acceptableEventCode(StateEventCode inEvent);
	
	/**
	 *	RXgN^
	 *
	 *	@param	ʂɔzuManager
	 */
	protected DecoratedStateManagerImpl(StateManagerImpl inManager) {
		mDecorated = inManager;
	}
}