// ***************************************************************************************
//
//	Copyright (C) 2003 Kazuhiko TAMURA. All rights reserved.
//
//	This program is free software; you can redistribute it and/or 
//	modify it under the terms of the GNU General Public License
//	as published by the Free Software Foundation; either version 2
//	of the License, or (at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//	NAME:		PieceSizeCommand.java
//	DATE:		2003.6.26
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.framework.view.command;

import jp.gr.java_conf.ktz.puzzle.framework.view.CommandContainer;

/**
 *	ViewKwpiece sizeύXƂʒm邽߂Command
 */
public class PieceSizeCommand extends AbstractBottomUpCommand {
	/** ύXpiece size */
	private final int mPieceSize;
	
	/**
	 *	RXgN^
	 *
	 *	@param	inSrcView	Command`d̃Gg[|Cg
	 *	@param	inSize		ύXpiece size
	 */
	public PieceSizeCommand(CommandContainer inSrcView, final int inSize) {
		super(inSrcView);
		
		mPieceSize = inSize;
	}
	
	/** 
	 *	ύXpiece sizeo
	 *
	 *	@return	ύXpiece size
	 */
	public int getPieceSize() {
		return mPieceSize;
	}
	
	public String toString() {
		return PieceSizeCommand.class.getName();
	}
}