/****************************************************************************
 *
 *	Copyright (c) 1999-2008, Watanabe Lab, School of Media Science,
 *	Tokyo University of Technology, All rights reserved.
 *
 *	Redistribution and use in source and binary forms,
 *	with or without modification, are permitted provided that the
 *	following conditions are met:
 *
 *		- Redistributions of source code must retain the above
 *			copyright notice, this list of conditions and the
 *			following disclaimer.
 *
 *		- Redistributions in binary form must reproduce the above
 *			copyright notice, this list of conditions and the
 *			following disclaimer in the documentation and/or
 *			other materials provided with the distribution.
 *
 *		- Neither the name of the copyright holders nor the names
 *			of its contributors may be used to endorse or promote
 *			products derived from this software without specific
 *			prior written permission.
 *
 *	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *	"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *	LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 *	FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 *	COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 *	INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 *	(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 *	SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 *	HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 *	STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 *	IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *	POSSIBILITY OF SUCH DAMAGE. 
 *
 ****************************************************************************/
/****************************************************************************
 *
 *	Copyright (c) 1999-2008, Watanabe Lab, School of Media Science,
 *	Tokyo University of Technology, All rights reserved.
 *
 *	本ソフトウェアおよびソースコードのライセンスは、基本的に
 *	「修正 BSD ライセンス」に従います。以下にその詳細を記します。
 *
 *	ソースコード形式かバイナリ形式か、変更するかしないかを問わず、
 *	以下の条件を満たす場合に限り、再頒布および使用が許可されます。
 *
 *	- ソースコードを再頒布する場合、上記の著作権表示、本条件一覧、
 *		および下記免責条項を含めること。
 *
 *	- バイナリ形式で再頒布する場合、頒布物に付属のドキュメント等の
 *		資料に、上記の著作権表示、本条件一覧、および下記免責条項を
 *		含めること。
 *
 *	- 書面による特別の許可なしに、本ソフトウェアから派生した製品の
 *		宣伝または販売促進に、本ソフトウェアの著作権者の名前または
 *		コントリビューターの名前を使用してはならない。
 *
 *	本ソフトウェアは、著作権者およびコントリビューターによって「現
 *	状のまま」提供されており、明示黙示を問わず、商業的な使用可能性、
 *	および特定の目的に対する適合性に関す暗黙の保証も含め、またそれ
 *	に限定されない、いかなる保証もないものとします。著作権者もコン
 *	トリビューターも、事由のいかんを問わず、損害発生の原因いかんを
 *	問わず、かつ責任の根拠が契約であるか厳格責任であるか(過失その
 *	他の)不法行為であるかを問わず、仮にそのような損害が発生する可
 *	能性を知らされていたとしても、本ソフトウェアの使用によって発生
 *	した(代替品または代用サービスの調達、使用の喪失、データの喪失、
 *	利益の喪失、業務の中断も含め、またそれに限定されない)直接損害、
 *	間接損害、偶発的な損害、特別損害、懲罰的損害、または結果損害に
 *	ついて、一切責任を負わないものとします。
 *
 ****************************************************************************/
#ifndef	__FK_IMAGE_HEADER__
#define	__FK_IMAGE_HEADER__

#include <FK/Base.h>
#include <FK/Material.h>
#include <vector>
#include <string>

#ifdef	NO_GL_LIBRARY
typedef	unsigned char	fk_ImType;
typedef unsigned int	fk_TexID;
#else
#include <FK/OpenGL.h>
typedef GLubyte			fk_ImType;
typedef GLuint			fk_TexID;
#endif

enum fk_ImageStatus {
	FK_IMAGE_OK,
	FK_IMAGE_OPENERROR,
	FK_IMAGE_DATAERROR,
	FK_IMAGE_READERROR
};

enum fk_ImageFix {
	FK_FIX_LARGE,
	FK_FIX_SMALL,
	FK_FIX_64,
	FK_FIX_128,
	FK_FIX_256,
	FK_FIX_512,
	FK_FIX_1024,
	FK_FIX_2048,
	FK_FIX_4096,
	FK_FIX_8192,
	FK_FIX_16384,
	FK_FIX_32768,
	FK_FIX_65536
};

enum fk_ImageType {
	FK_IMAGE_BMP,
	FK_IMAGE_PNG,
	FK_IMAGE_JPG
};

class fk_Dimension {
 public:
	int		w, h;

	fk_Dimension(int = 0, int = 0);
	fk_Dimension(const fk_Dimension &);
	void set(int, int);
};

class fk_Rect {
 public:
	int		x, y, w, h;

	fk_Rect(int = 0, int = 0, int = 0, int = 0);
	fk_Rect(const fk_Rect &);

	void			set(int, int, int, int);
	void			setPos(int, int);
	void			setSize(int, int);

	fk_Dimension	getSize(void);
};


class fk_Image : public fk_BaseObject {

	friend class	fk_Texture;

 private:

	fk_Dimension			imageSize, bufSize;
	std::vector<fk_ImType>	imageBuf;
	fk_TexID				texID;
	bool					initFlag;
	// テクスチャの部分更新用情報
	fk_Rect					updateRect;

	unsigned int		ChgUInt(fk_ImType *, int) const;
	unsigned int		ChgUShort(fk_ImType *, int) const;

	int					GetOffset(int, int) const;
	fk_ImType			RoundVal(int) const;
	fk_ImageStatus		CreateImg(const string);
	fk_ImageStatus		CreateImg(fk_ImType *);
	void				CreateBuffer(bool = true);
	void				CreateBuffer(int, int, bool = true);
	void				CreateBuffer(const fk_Dimension, bool = true);
	bool				IsPixelStatus(int, int) const;
	int					GetOneBufferSize(int, int, int);
	int					GetFixVal(fk_ImageFix, int) const;

	void				SetLong2Byte(long, fk_ImType *, int);
	void				SetInt2Byte(int, fk_ImType *, int);

	bool				GetInitFlag(void);
	void				SetInitFlag(bool);
	void				SetTexID(const fk_TexID);

	// <-ImageIO
	bool				IsBmpFile(const string) const;
	bool				IsBmpData(fk_ImType *) const;
	fk_ImageStatus		LoadBmpFile(const string);
	fk_ImageStatus		LoadBmpData(fk_ImType *);
	void				SetRGBA4Bmp(int, int, fk_ImType *,
									int, vector<fk_ImType> &);

	bool				GetBmpFileHeader(FILE *, fk_ImType *);
	bool				GetBmpInfoHeader(FILE *, fk_ImType *);
	fk_Dimension		GetBmpSize(fk_ImType *);

	fk_ImageStatus		SaveBmpFile(string, bool);
	void				MakeBmpFileHeader(int, int, int,
										  std::vector<fk_ImType> &);
	void				MakeBmpInfoHeader(int, int, int,
										  std::vector<fk_ImType> &);
	void				MakeBmpBuffer(int, int, bool, fk_ImType *);

	bool				IsPngFile(const string) const;
	bool				IsPngData(fk_ImType *) const;
	fk_ImageStatus		LoadPngFile(const string);
	fk_ImageStatus		LoadPngData(fk_ImType *);
	// ->

 public:
	fk_Image(int = 0, int = 0);
	~fk_Image();
	fk_Image(const fk_Image &);

	// 全初期化関数 
	void					init();

	// <- ImageIO
	// BMP ファイル入力用関数 
	bool					readBMP(const string);

	// BMP データ入力用関数
	bool					readBMPData(fk_ImType *);

	// PNG ファイル入力用関数
	bool					readPNG(const string);

	// PNG データ入力用関数
	bool					readPNGData(fk_ImType *);

	// JPEG ファイル入力用関数
	bool					readJPG(const string);

	// 画像ファイル出力用関数
	bool					writeBMP(const string, const bool = false);

	// PNG ファイル出力用関数
	bool					writePNG(const string, const bool = true);

	// JPEG ファイル出力用関数
	bool					writeJPG(const string, int = 80);
	// ->

	// 画像データ生成用関数 
	void					newImage(int, int, bool = true);

	// 画像データコピー用関数 
	void					copyImage(const fk_Image *);
	void					copyImage(const fk_Image *, int, int);

	// 画像データ部分抽出用関数
	bool					subImage(const fk_Image *, int, int, int, int);

	// 画像幅取得関数 
	int						getWidth(void) const;

	// 画像高取得関数 
	int						getHeight(void) const;

	// 画像サイズ取得関数 
	const fk_Dimension *	getImageSize(void);

	// 画像バッファサイズ取得関数 
	const fk_Dimension *	getBufferSize(void);

	// ピクセル赤要素取得関数 
	int						getR(int, int) const;

	// ピクセル緑要素取得関数 
	int						getG(int, int) const;

	// ピクセル青要素取得関数 
	int						getB(int, int) const;

	// ピクセル透明度要素取得関数 
	int						getA(int, int) const;

	// ピクセル色要素取得関数 
	fk_Color				getColor(int, int) const;

	// ピクセル RGBA 値設定関数 
	bool					setRGBA(int, int, int, int, int, int);

	// ピクセル RGB 値設定関数 
	bool					setRGB(int, int, int, int, int);

	// ピクセル赤要素設定関数 
	bool					setR(int, int, int);

	// ピクセル緑要素設定関数 
	bool					setG(int, int, int);

	// ピクセル青要素設定関数 
	bool					setB(int, int, int);

	// ピクセル透明度要素設定関数 
	bool					setA(int, int, int);

	// ピクセル色値設定関数 
	bool					setColor(int, int, const fk_Color &);

	// バッファ全体の同一色設定
	void					fillColor(const fk_Color &);
	void					fillColor(int, int, int, int = 0);

	// バッファポインタ取得関数	
	const fk_ImType *		getBufPointer(void) const;

	fk_TexID				GetTexID(void);

	// 矩形更新領域指定用関数
	void					ClearUpdateArea(void);
	void					SetUpdateArea(void);
	void					SetUpdateArea(int, int, int, int);
	fk_Rect					GetUpdateArea(void);

};

#endif	// __FK_IMAGE_HEADER__
